/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import android.text.TextUtils;
import com.chinapex.android.monitor.utils.MLog;
import java.security.MessageDigest;

public class MD5Utils {
    private static final String TAG = MD5Utils.class.getSimpleName();
    private static final String ERROR_MD5 = "error_md5";

    public static String getMD5(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            MLog.e(TAG, "getMD5() -> s is null or empty!");
            return ERROR_MD5;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            MLog.e(TAG, "getMD5() -> Exception:" + e.getMessage());
            return ERROR_MD5;
        }
    }
}

