/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import android.text.TextUtils;
import com.chinapex.android.monitor.utils.MLog;

public class PageUtils {
    private static final String TAG = PageUtils.class.getSimpleName();
    private static final String HASH_SEPARATOR = "##";
    private static final String DOT_SEPARATOR = "\\.";

    public static String getClassName(String classPath) {
        if (TextUtils.isEmpty((CharSequence)classPath)) {
            MLog.e(TAG, "getSimpleName()-> str is null");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] fragmentNames = classPath.split(HASH_SEPARATOR);
        if (fragmentNames.length == 0) {
            MLog.e(TAG, "getSimpleName()-> fragmentNames is empty");
            return "";
        }
        for (int i = 0; i < fragmentNames.length; ++i) {
            String[] partNames = fragmentNames[i].split(DOT_SEPARATOR);
            if (partNames.length == 0) {
                MLog.e(TAG, "getSimpleName()-> partNames is empty");
                return "";
            }
            String simpleName = partNames[partNames.length - 1];
            if (i > 0) {
                sb.append(HASH_SEPARATOR);
            }
            sb.append(simpleName);
        }
        return sb.toString();
    }

    public static String getPagePathName(String pagePath) {
        String pagePathName = "";
        if (pagePath.contains("::") && pagePath.split("::").length == 2) {
            String[] strs = pagePath.split("::");
            pagePathName = PageUtils.getClassName(strs[0]) + "::" + strs[1];
        } else {
            pagePathName = PageUtils.getClassName(pagePath);
        }
        return pagePathName;
    }
}

