/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;

public class PhoneStateUtils {
    private static final String TAG = PhoneStateUtils.class.getSimpleName();

    public static String getVersionName() {
        if (null == MonitorCache.getInstance().getContext()) {
            MLog.e(TAG, "getVersionName() -> context is null!");
            return "defaultAppVersion";
        }
        PackageManager pm = MonitorCache.getInstance().getContext().getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(MonitorCache.getInstance().getContext().getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            MLog.e(TAG, "getVersionName() -> exception:" + e.getMessage());
            return "defaultAppVersion";
        }
    }

    public static String getAppName(Context context) {
        if (null == context) {
            MLog.e(TAG, "getAppName() -> context is null!");
            return null;
        }
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo info = pm.getApplicationInfo(context.getPackageName(), 0);
            return info.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            MLog.e(TAG, "getAppName() -> exception:" + e.getMessage());
            return null;
        }
    }
}

