/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.view.View;
import com.chinapex.android.monitor.utils.MLog;

public class SnapshotUtil {
    private static final String TAG = SnapshotUtil.class.getSimpleName();

    public static Bitmap takeSnapshot(View view) {
        if (null == view) {
            MLog.e(TAG, "takeSnapshot()-> view is null!");
            return null;
        }
        int width = view.getWidth();
        int height = view.getHeight();
        if (width == 0 || height == 0) {
            MLog.e(TAG, "takeSnapshot()-> full layout of this view is not finished!");
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        if (height >= 480) {
            Matrix matrix = new Matrix();
            matrix.setScale(0.5f, 0.5f);
            Bitmap bm = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            bitmap.recycle();
            bitmap = null;
            return bm;
        }
        return bitmap;
    }
}

