/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.chinapex.android.monitor.utils.MLog;

public class SpUtils {
    private static final String TAG = SpUtils.class.getSimpleName();
    private static final String SP_NAME = "apex_sp";

    public static void putParam(Context context, String key, Object value) {
        if (null == context) {
            MLog.e(TAG, "setParam() -> context is null!");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)key) || null == value) {
            MLog.e(TAG, "setParam() -> key or value is null!");
            return;
        }
        String clsName = value.getClass().getSimpleName();
        if (TextUtils.isEmpty((CharSequence)clsName)) {
            MLog.e(TAG, "setParam() -> key's clsName is null!");
            return;
        }
        SharedPreferences sp = context.getSharedPreferences(SP_NAME, 0);
        SharedPreferences.Editor editor = sp.edit();
        switch (clsName) {
            case "Long": {
                editor.putLong(key, ((Long)value).longValue());
                break;
            }
            case "String": {
                editor.putString(key, (String)value);
                break;
            }
            case "Integer": {
                editor.putInt(key, ((Integer)value).intValue());
                break;
            }
            case "Boolean": {
                editor.putBoolean(key, ((Boolean)value).booleanValue());
                break;
            }
            case "Float": {
                editor.putFloat(key, ((Float)value).floatValue());
                break;
            }
        }
        editor.apply();
    }

    public static Object getParam(Context context, String key, Object defVal) {
        if (null == context) {
            MLog.e(TAG, "getParam() -> context is null!");
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)key) || null == defVal) {
            MLog.e(TAG, "getParam() -> key or defVal is null!");
            return null;
        }
        String clsName = defVal.getClass().getSimpleName();
        if (TextUtils.isEmpty((CharSequence)clsName)) {
            MLog.e(TAG, "getParam() -> key's clsName is null!");
            return null;
        }
        SharedPreferences sp = context.getSharedPreferences(SP_NAME, 0);
        switch (clsName) {
            case "Long": {
                return sp.getLong(key, ((Long)defVal).longValue());
            }
            case "String": {
                return sp.getString(key, (String)defVal);
            }
            case "Integer": {
                return sp.getInt(key, ((Integer)defVal).intValue());
            }
            case "Boolean": {
                return sp.getBoolean(key, ((Boolean)defVal).booleanValue());
            }
            case "Float": {
                return Float.valueOf(sp.getFloat(key, ((Float)defVal).floatValue()));
            }
        }
        return null;
    }
}

