/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.utils.net;

import android.text.TextUtils;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.net.INetCallback;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpClientManager {
    private static final String TAG = OkHttpClientManager.class.getSimpleName();
    private static OkHttpClientManager sOkHttpClientManager;
    private OkHttpClient mOkHttpClient;
    private MediaType mediaTypeJson = MediaType.parse((String)"application/json; charset=utf-8");
    private MediaType mediaTypePng = MediaType.parse((String)"image/png");

    private OkHttpClientManager() {
        this.mOkHttpClient = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).sslSocketFactory(this.createSSLSocketFactory(), (X509TrustManager)new TrustAllManager()).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier()).build();
    }

    private SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
            sSLSocketFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClientManager getInstance() {
        if (null != sOkHttpClientManager) return sOkHttpClientManager;
        Class<OkHttpClientManager> clazz = OkHttpClientManager.class;
        synchronized (OkHttpClientManager.class) {
            if (null != sOkHttpClientManager) return sOkHttpClientManager;
            sOkHttpClientManager = new OkHttpClientManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sOkHttpClientManager;
        }
    }

    public void postJson(String url, String jsonStr, final INetCallback iNetCallback) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)jsonStr)) {
            MLog.e(TAG, "postJson() -> url or jsonStr is null or empty!");
            return;
        }
        if (null == iNetCallback) {
            MLog.e(TAG, "postJson() -> iNetCallback is null!");
            return;
        }
        RequestBody requestBody = RequestBody.create((MediaType)this.mediaTypeJson, (String)jsonStr);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Call call = this.mOkHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                iNetCallback.onFailed(-1, e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (null == responseBody) {
                    iNetCallback.onFailed(0, "NET_BODY_NULL");
                    MLog.e(TAG, "postJson onResponse() -> responseBody is null");
                    return;
                }
                String result = responseBody.string();
                iNetCallback.onSuccess(1, "NET_SUCCESS", result);
            }
        });
    }

    public void postJsonByAuth(String url, String jsonStr, final INetCallback iNetCallback) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)jsonStr)) {
            MLog.e(TAG, "postJson() -> url or jsonStr is null or empty!");
            return;
        }
        if (null == iNetCallback) {
            MLog.e(TAG, "postJson() -> iNetCallback is null!");
            return;
        }
        RequestBody requestBody = RequestBody.create((MediaType)this.mediaTypeJson, (String)jsonStr);
        Request request = new Request.Builder().url(url).addHeader("", "").post(requestBody).build();
        Call call = this.mOkHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                iNetCallback.onFailed(-1, e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (null == responseBody) {
                    iNetCallback.onFailed(0, "NET_BODY_NULL");
                    MLog.e(TAG, "postJsonByAuth onResponse() -> responseBody is null");
                    return;
                }
                String result = responseBody.string();
                iNetCallback.onSuccess(1, "NET_SUCCESS", result);
            }
        });
    }

    public void postMultipartSnapshotRequest(String url, Map<String, String> files, final INetCallback iNetCallback) {
        if (TextUtils.isEmpty((CharSequence)url) || null == files || files.isEmpty()) {
            MLog.e(TAG, "postMultipartSnapshotRequest()-> url or files is empty");
            return;
        }
        if (null == iNetCallback) {
            MLog.e(TAG, "postMultipartSnapshotRequest()-> iNetCallback is null");
            return;
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        builder.addFormDataPart("terminal", "ANDROID");
        builder.addFormDataPart("Content-Type", "image/png");
        builder.addFormDataPart("Content-Length", "10074");
        int i = 1;
        for (Map.Entry<String, String> entry : files.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) {
                MLog.e(TAG, "postMultipartSnapshotRequest()-> file name or file path is empty , skip");
                continue;
            }
            File file = new File(entry.getValue());
            RequestBody requestBody = RequestBody.create((MediaType)this.mediaTypePng, (File)file);
            builder.addFormDataPart("image_" + i, entry.getKey(), requestBody);
            ++i;
        }
        MultipartBody requestBody = builder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        Call call = this.mOkHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                iNetCallback.onFailed(-1, e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (null == responseBody) {
                    iNetCallback.onFailed(0, "NET_BODY_NULL");
                    MLog.e(TAG, "postMultipartSnapshotRequest onResponse() -> responseBody is null");
                    return;
                }
                String result = responseBody.string();
                iNetCallback.onSuccess(1, "NET_SUCCESS", result);
            }
        });
    }

    public void get(String url, final INetCallback iNetCallback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            MLog.e(TAG, "get() -> url is null!");
            return;
        }
        if (null == iNetCallback) {
            MLog.e(TAG, "get() -> iNetCallback is null!");
            return;
        }
        Request request = new Request.Builder().url(url).build();
        Call call = this.mOkHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                iNetCallback.onFailed(-1, e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody responseBody = response.body();
                if (null == responseBody) {
                    iNetCallback.onFailed(0, "NET_BODY_NULL");
                    MLog.e(TAG, "get onResponse() -> responseBody is null");
                    return;
                }
                String result = responseBody.string();
                iNetCallback.onSuccess(1, "NET_SUCCESS", result);
            }
        });
    }

    private class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return MonitorCache.getInstance().getHostnameVerifier().equals(hostname);
        }
    }

    private class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

