/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.IFloatingView;

public class BaseFloatingView
extends FrameLayout
implements IFloatingView {
    private static final String TAG = BaseFloatingView.class.getSimpleName();
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mParams;
    private int mWindowType;

    public BaseFloatingView(@NonNull Context context, int windowType) {
        super(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mParams = this.getDefaultParams();
        this.mWindowType = windowType;
    }

    @Override
    public void show() {
        try {
            this.setVisibility(0);
            this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)this.mParams);
        }
        catch (Exception e) {
            MLog.e(TAG, "show exception:" + e.getMessage());
        }
    }

    @Override
    public void hide() {
        try {
            this.setVisibility(4);
        }
        catch (Exception e) {
            MLog.e(TAG, "hide exception:" + e.getMessage());
        }
    }

    @Override
    public void dismiss() {
        try {
            this.mWindowManager.removeView((View)this);
        }
        catch (Exception e) {
            MLog.e(TAG, "show exception:" + e.getMessage());
        }
    }

    @Override
    public boolean isHiding() {
        return this.getVisibility() == 4;
    }

    public int getWindowType() {
        return this.mWindowType;
    }

    protected WindowManager.LayoutParams getWindowParams() {
        return this.mParams;
    }

    protected void updateLayout() {
        this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
    }

    private WindowManager.LayoutParams getDefaultParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.width = -1;
        params.height = -1;
        params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
        params.flags = 1024;
        params.format = -3;
        params.gravity = 17;
        return params;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4 && event.getAction() == 1) {
            FloatingViewManager.getInstance().dismissFloatingView(this.mWindowType);
            return true;
        }
        return super.dispatchKeyEvent(event);
    }
}

