/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view;

import android.content.Context;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.IFloatingView;
import com.chinapex.android.monitor.view.config.ImportConfigView;
import com.chinapex.android.monitor.view.confirm.ConfirmDeleteStatisticsView;
import com.chinapex.android.monitor.view.event.DefineEventView;
import com.chinapex.android.monitor.view.event.DefinePathView;
import com.chinapex.android.monitor.view.event.InputPageOrElementNameView;
import com.chinapex.android.monitor.view.loading.LoadingView;
import com.chinapex.android.monitor.view.menu.FloatingWindow;
import com.chinapex.android.monitor.view.snapshot.SnapshotView;
import com.chinapex.android.monitor.view.statistics.StatisticsView;
import com.chinapex.android.monitor.view.upload.UploadView;
import java.util.HashMap;
import java.util.Map;

public class FloatingViewManager {
    private static final String TAG = FloatingViewManager.class.getSimpleName();
    private Map<Integer, IFloatingView> mFloatingViewMap = new HashMap<Integer, IFloatingView>();

    private FloatingViewManager() {
    }

    public static FloatingViewManager getInstance() {
        return FloatingViewManagerHolder.S_FLOATING_VIEW_MANAGER;
    }

    public void showFloatingView(int viewType) {
        IFloatingView iFloatingView = this.mFloatingViewMap.containsKey(viewType) ? this.mFloatingViewMap.get(viewType) : this.createView(viewType);
        if (null == iFloatingView) {
            MLog.e(TAG, "showFloatingView()-> error:show floating view failed");
            return;
        }
        iFloatingView.show();
    }

    public void hideFloatingView(int viewType) {
        if (this.mFloatingViewMap.containsKey(viewType)) {
            IFloatingView iFloatingView = this.mFloatingViewMap.get(viewType);
            if (null == iFloatingView) {
                MLog.e(TAG, "hideFloatingView()-> hide floating view failed");
                return;
            }
            iFloatingView.hide();
        }
    }

    public void dismissFloatingView(int viewType) {
        if (this.mFloatingViewMap.containsKey(viewType)) {
            IFloatingView iFloatingView = this.mFloatingViewMap.get(viewType);
            if (null == iFloatingView) {
                MLog.e(TAG, "dismissFloatingView()-> dismiss floating view failed");
                return;
            }
            iFloatingView.dismiss();
            this.mFloatingViewMap.remove(viewType);
        }
    }

    public void hideAll() {
        for (IFloatingView iFloatingView : this.mFloatingViewMap.values()) {
            if (null == iFloatingView) {
                MLog.e(TAG, "hideAll()-> there is a null object in the map");
                continue;
            }
            iFloatingView.hide();
        }
    }

    public void showAll() {
        for (IFloatingView iFloatingView : this.mFloatingViewMap.values()) {
            if (null == iFloatingView) {
                MLog.e(TAG, "showAll()-> there is a null object in the map");
                continue;
            }
            if (!iFloatingView.isHiding()) continue;
            iFloatingView.show();
        }
    }

    public void dismissAll() {
        for (IFloatingView iFloatingView : this.mFloatingViewMap.values()) {
            if (null == iFloatingView) {
                MLog.e(TAG, "dismissAll()-> there is a null object in the map");
                continue;
            }
            iFloatingView.dismiss();
        }
        this.mFloatingViewMap.clear();
    }

    public IFloatingView getFloatingView(int viewType) {
        if (!this.mFloatingViewMap.containsKey(viewType)) {
            MLog.e(TAG, "getFloatingView()-> mFloatingViewMap do not have this view type");
            return null;
        }
        return this.mFloatingViewMap.get(viewType);
    }

    private IFloatingView createView(int viewType) {
        BaseFloatingView iFloatingView;
        Context mContext = MonitorCache.getInstance().getContext();
        if (null == mContext) {
            MLog.e(TAG, "createView()-> error:context=null, create view failed");
            return null;
        }
        switch (viewType) {
            case 0: {
                iFloatingView = new FloatingWindow(mContext, 0);
                break;
            }
            case 1: {
                iFloatingView = new DefineEventView(mContext, 1);
                break;
            }
            case 2: {
                iFloatingView = new DefineEventView(mContext, 2);
                break;
            }
            case 3: {
                iFloatingView = new DefineEventView(mContext, 3);
                break;
            }
            case 4: {
                iFloatingView = new StatisticsView(mContext, 4);
                break;
            }
            case 5: {
                iFloatingView = new UploadView(mContext, 5);
                break;
            }
            case 6: {
                iFloatingView = new SnapshotView(mContext, 6);
                break;
            }
            case 7: {
                iFloatingView = new ImportConfigView(mContext, 7);
                break;
            }
            case 8: {
                iFloatingView = new LoadingView(mContext, 8);
                break;
            }
            case 9: {
                iFloatingView = new InputPageOrElementNameView(mContext, 9);
                break;
            }
            case 10: {
                iFloatingView = new ConfirmDeleteStatisticsView(mContext, 10);
                break;
            }
            case 11: {
                iFloatingView = new DefinePathView(mContext, 11);
                break;
            }
            default: {
                iFloatingView = null;
                MLog.e(TAG, "createView()-> no this view type!");
            }
        }
        if (null == iFloatingView) {
            MLog.e(TAG, "createView()-> create view failed");
            return null;
        }
        this.mFloatingViewMap.put(viewType, iFloatingView);
        return iFloatingView;
    }

    private static final class FloatingViewManagerHolder {
        private static final FloatingViewManager S_FLOATING_VIEW_MANAGER = new FloatingViewManager();

        private FloatingViewManagerHolder() {
        }
    }
}

