/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.adapter;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.StatisticsBean;
import com.chinapex.android.monitor.utils.DensityUtil;
import com.chinapex.android.monitor.utils.NumberUtils;
import java.util.List;

public class ColumnListAdapter
extends BaseAdapter {
    private List<StatisticsBean> mStatisticsBeans;
    private long mMaxCount;

    public ColumnListAdapter(List<StatisticsBean> mStatisticsBeans) {
        this.mStatisticsBeans = mStatisticsBeans;
        AdapterDataSetObserver observer = new AdapterDataSetObserver();
        this.registerDataSetObserver(observer);
    }

    public int getCount() {
        return this.mStatisticsBeans.size();
    }

    public Object getItem(int i) {
        return this.mStatisticsBeans.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View convertView, ViewGroup viewGroup) {
        ViewHolder viewHolder;
        View view;
        StatisticsBean bean = this.mStatisticsBeans.get(i);
        if (null == convertView) {
            view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.count_rank_list_item, viewGroup, false);
            viewHolder = new ViewHolder();
            viewHolder.eventNameTv = (TextView)view.findViewById(R.id.tv_event_name);
            viewHolder.percentTv = (TextView)view.findViewById(R.id.tv_column_percent);
            viewHolder.columnView = (ImageView)view.findViewById(R.id.v_column);
            view.setTag((Object)viewHolder);
        } else {
            view = convertView;
            viewHolder = (ViewHolder)convertView.getTag();
        }
        float maxWidth = (float)DensityUtil.getScreenWidth(viewGroup.getContext()) - viewGroup.getContext().getResources().getDimension(R.dimen.column_margin_left) - viewGroup.getContext().getResources().getDimension(R.dimen.column_margin_right);
        int columnViewWidth = (int)(maxWidth * (float)bean.getClickCount() / (float)this.mMaxCount);
        viewHolder.eventNameTv.setText((CharSequence)(TextUtils.isEmpty((CharSequence)bean.getEventLabel()) ? bean.getViewPathMD5() : bean.getEventLabel()));
        viewHolder.percentTv.setText((CharSequence)NumberUtils.getFormatPercent(bean.getClickProportion(), 2));
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)viewHolder.columnView.getLayoutParams();
        layoutParams.width = columnViewWidth;
        viewHolder.columnView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        viewHolder.columnView.invalidate();
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(0);
        drawable2.setGradientType(0);
        drawable2.setCornerRadius(20.0f);
        drawable2.setColor(bean.getColor());
        viewHolder.columnView.setBackground((Drawable)drawable2);
        return view;
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        AdapterDataSetObserver() {
        }

        public void onChanged() {
            for (StatisticsBean bean : ColumnListAdapter.this.mStatisticsBeans) {
                if (bean.getClickCount() <= ColumnListAdapter.this.mMaxCount) continue;
                ColumnListAdapter.this.mMaxCount = bean.getClickCount();
            }
        }

        public void onInvalidated() {
        }
    }

    static class ViewHolder {
        TextView eventNameTv;
        TextView percentTv;
        ImageView columnView;

        ViewHolder() {
        }
    }
}

