/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ImportConfigBean;
import com.chinapex.android.monitor.utils.MLog;
import java.util.List;

public class ConfigRvAdapter
extends RecyclerView.Adapter<ConfigRvHolder>
implements View.OnClickListener {
    private static final String TAG = ConfigRvAdapter.class.getSimpleName();
    private OnItemClickListener mOnItemClickListener;
    private List<ImportConfigBean> mVersions;

    public ConfigRvAdapter(List<ImportConfigBean> versions) {
        this.mVersions = versions;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void onClick(View v) {
        if (null == this.mOnItemClickListener) {
            MLog.e(TAG, "mOnItemClickListener is null!");
            return;
        }
        Integer position = (Integer)v.getTag();
        for (int i = 0; i < this.mVersions.size(); ++i) {
            ImportConfigBean importConfigBean = this.mVersions.get(i);
            if (null == importConfigBean) {
                MLog.i(TAG, "onClick() -> importConfigBean is null!");
                continue;
            }
            if (i == position) {
                importConfigBean.setState(1);
                continue;
            }
            importConfigBean.setState(0);
        }
        this.notifyDataSetChanged();
        this.mOnItemClickListener.onItemClick(position);
    }

    @NonNull
    public ConfigRvHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.config_version_item, parent, false);
        ConfigRvHolder configRvHolder = new ConfigRvHolder(view);
        view.setOnClickListener((View.OnClickListener)this);
        return configRvHolder;
    }

    public void onBindViewHolder(@NonNull ConfigRvHolder holder, int position) {
        if (null == this.mVersions) {
            MLog.e(TAG, "onBindViewHolder() -> mVersions is null!");
            return;
        }
        ImportConfigBean importConfigBean = this.mVersions.get(position);
        if (null == importConfigBean) {
            MLog.e(TAG, "onBindViewHolder() -> importConfigBean is null!");
            return;
        }
        holder.tick.setOnClickListener((View.OnClickListener)this);
        holder.tick.setTag((Object)position);
        holder.version.setText((CharSequence)importConfigBean.getVersion());
        switch (importConfigBean.getState()) {
            case 1: {
                holder.tick.setChecked(true);
                break;
            }
            case 0: {
                holder.tick.setChecked(false);
                break;
            }
        }
        holder.itemView.setTag((Object)position);
    }

    public int getItemCount() {
        return null == this.mVersions ? 0 : this.mVersions.size();
    }

    class ConfigRvHolder
    extends RecyclerView.ViewHolder {
        TextView version;
        RadioButton tick;

        ConfigRvHolder(View itemView) {
            super(itemView);
            this.version = (TextView)itemView.findViewById(R.id.tv_import_config_version);
            this.tick = (RadioButton)itemView.findViewById(R.id.ib_import_config_tick);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

