/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.PageUtils;
import java.util.ArrayList;
import java.util.List;

public class PathListAdapter
extends BaseAdapter {
    private static final String TAG = PathListAdapter.class.getSimpleName();
    private static final String HASH_SEPARATOR = "##";
    private static final String DOT_SEPARATOR = "\\.";
    private List<String> pages;
    private List<String> simpleName;
    private Context mContext;

    public PathListAdapter(Context context) {
        this.mContext = context;
        this.pages = new ArrayList<String>();
        this.simpleName = new ArrayList<String>();
    }

    public void addAll(List<String> pages) {
        this.pages.addAll(pages);
        for (String page : pages) {
            this.simpleName.add(PageUtils.getPagePathName(page));
        }
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.pages.clear();
        this.simpleName.clear();
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.pages.size();
    }

    public Object getItem(int position) {
        return this.pages.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view;
        if (null == convertView) {
            view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.path_list_item, parent, false);
            TextView textView = (TextView)view.findViewById(R.id.spinner_text);
            textView.setText((CharSequence)this.simpleName.get(position));
            view.setTag((Object)textView);
        } else {
            view = convertView;
            TextView textView = (TextView)view.getTag();
            textView.setText((CharSequence)this.simpleName.get(position));
        }
        return view;
    }

    private String getSimpleName(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            MLog.e(TAG, "getSimpleName()-> str is null");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] fragmentNames = str.split(HASH_SEPARATOR);
        if (fragmentNames.length == 0) {
            MLog.e(TAG, "getSimpleName()-> fragmentNames is empty");
            return "";
        }
        for (int i = 0; i < fragmentNames.length; ++i) {
            String[] partNames = fragmentNames[i].split(DOT_SEPARATOR);
            if (partNames.length == 0) {
                MLog.e(TAG, "getSimpleName()-> partNames is empty");
                return "";
            }
            String simpleName = partNames[partNames.length - 1];
            if (i > 0) {
                sb.append(HASH_SEPARATOR);
            }
            sb.append(simpleName);
        }
        return sb.toString();
    }
}

