/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.StatisticsBean;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.NumberUtils;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.snapshot.SnapshotView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsListAdapter
extends BaseExpandableListAdapter
implements View.OnClickListener {
    private static final String TAG = StatisticsListAdapter.class.getSimpleName();
    private List<StatisticsBean> mStatisticsBeans;
    private OnItemClickListener mOnItemClickListener;
    private Map<String, StatisticsBean> checkStatisticsMap;

    public Map<String, StatisticsBean> getCheckStatisticsMap() {
        return this.checkStatisticsMap;
    }

    public StatisticsListAdapter(List<StatisticsBean> statisticsBeans) {
        this.mStatisticsBeans = statisticsBeans;
        this.checkStatisticsMap = new HashMap<String, StatisticsBean>();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public int getGroupCount() {
        return null == this.mStatisticsBeans ? 0 : this.mStatisticsBeans.size();
    }

    public int getChildrenCount(int groupPosition) {
        if (null == this.mStatisticsBeans) {
            return 0;
        }
        StatisticsBean statisticsBean = this.mStatisticsBeans.get(groupPosition);
        if (null == statisticsBean) {
            return 0;
        }
        String viewPathMD5 = statisticsBean.getViewPathMD5();
        if (TextUtils.isEmpty((CharSequence)viewPathMD5)) {
            return 0;
        }
        if (viewPathMD5.equals(Constant.OTHERS_VIEW_PATH_MD5)) {
            return 0;
        }
        return 1;
    }

    public Object getGroup(int groupPosition) {
        return this.mStatisticsBeans.get(groupPosition);
    }

    public Object getChild(int groupPosition, int childPosition) {
        return childPosition;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return false;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupViewHolder groupViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.statistics_list_item_group, parent, false);
            groupViewHolder = new GroupViewHolder(convertView);
            convertView.setTag((Object)groupViewHolder);
        } else {
            groupViewHolder = (GroupViewHolder)convertView.getTag();
        }
        if (null == this.mStatisticsBeans) {
            MLog.e(TAG, "getGroupView() -> mUploadViewBeans is null !");
            return convertView;
        }
        StatisticsBean statisticsBean = this.mStatisticsBeans.get(groupPosition);
        if (null == statisticsBean) {
            MLog.e(TAG, "getGroupView() -> statisticsBean is null !");
            return convertView;
        }
        String tag = TextUtils.isEmpty((CharSequence)statisticsBean.getEventLabel()) ? statisticsBean.getViewPathMD5() : statisticsBean.getEventLabel();
        groupViewHolder.evenName.setText((CharSequence)tag);
        groupViewHolder.clickCount.setText((CharSequence)String.valueOf(statisticsBean.getClickCount()));
        groupViewHolder.clickProportion.setText((CharSequence)NumberUtils.getFormatPercent(statisticsBean.getClickProportion(), 2));
        groupViewHolder.checkStatisticsItemIv.setTag((Object)statisticsBean);
        groupViewHolder.checkStatisticsItemIv.setOnClickListener((View.OnClickListener)this);
        if (this.checkStatisticsMap.containsKey(tag)) {
            groupViewHolder.checkStatisticsItemIv.setImageResource(R.drawable.check_analyse_selected);
        } else {
            groupViewHolder.checkStatisticsItemIv.setImageResource(R.drawable.check_analyse_normal);
        }
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ChildViewHolder childViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.statistics_list_item_child, parent, false);
            childViewHolder = new ChildViewHolder(convertView);
            convertView.setTag((Object)childViewHolder);
        } else {
            childViewHolder = (ChildViewHolder)convertView.getTag();
        }
        if (null == this.mStatisticsBeans) {
            MLog.e(TAG, "getChildView() -> mUploadViewBeans is null !");
            return convertView;
        }
        StatisticsBean statisticsBean = this.mStatisticsBeans.get(groupPosition);
        if (null == statisticsBean) {
            MLog.e(TAG, "getChildView() -> statisticsBean is null !");
            return convertView;
        }
        final String snapshotPath = MonitorCache.getInstance().getServerRoot() + "app/downSnapshot" + "?md5=" + statisticsBean.getViewPathMD5() + "&terminal=" + "ANDROID";
        ((RequestBuilder)Glide.with((View)parent).load(snapshotPath).centerInside()).into(childViewHolder.thumbnail);
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingViewManager.getInstance().showFloatingView(6);
                SnapshotView sv = (SnapshotView)FloatingViewManager.getInstance().getFloatingView(6);
                sv.loadImage(snapshotPath);
            }
        });
        return convertView;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.check_statistics_item_iv) {
            String tag;
            StatisticsBean statisticsBean = (StatisticsBean)v.getTag();
            String string2 = tag = TextUtils.isEmpty((CharSequence)statisticsBean.getEventLabel()) ? statisticsBean.getViewPathMD5() : statisticsBean.getEventLabel();
            if (this.checkStatisticsMap.containsKey(tag)) {
                this.checkStatisticsMap.remove(tag);
            } else {
                this.checkStatisticsMap.put(tag, statisticsBean);
            }
            this.notifyDataSetChanged();
        }
    }

    public void selectAllStatistics() {
        this.checkStatisticsMap.clear();
        for (StatisticsBean statisticsBean : this.mStatisticsBeans) {
            if (statisticsBean == null) continue;
            String tag = TextUtils.isEmpty((CharSequence)statisticsBean.getEventLabel()) ? statisticsBean.getViewPathMD5() : statisticsBean.getEventLabel();
            this.checkStatisticsMap.put(tag, statisticsBean);
        }
        this.notifyDataSetChanged();
    }

    public void cancelSelectStatistics() {
        this.checkStatisticsMap.clear();
        this.notifyDataSetChanged();
    }

    class ChildViewHolder {
        ImageView thumbnail;

        ChildViewHolder(View itemView) {
            this.thumbnail = (ImageView)itemView.findViewById(R.id.iv_thumbnail_statistic);
        }
    }

    class GroupViewHolder {
        TextView evenName;
        TextView clickCount;
        TextView clickProportion;
        ImageView checkStatisticsItemIv;
        RelativeLayout statisticsItemRl;

        GroupViewHolder(View itemView) {
            this.evenName = (TextView)itemView.findViewById(R.id.tv_event_name);
            this.clickCount = (TextView)itemView.findViewById(R.id.tv_item_click_cnt_value);
            this.clickProportion = (TextView)itemView.findViewById(R.id.tv_item_click_proportion_value);
            this.checkStatisticsItemIv = (ImageView)itemView.findViewById(R.id.check_statistics_item_iv);
            this.statisticsItemRl = (RelativeLayout)itemView.findViewById(R.id.statistics_item_rl);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

