/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.BitmapStorageUtil;
import com.chinapex.android.monitor.utils.MD5Utils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.PageUtils;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.snapshot.SnapshotView;
import java.util.List;
import java.util.Map;

public class UploadListAdapter
extends BaseExpandableListAdapter
implements View.OnClickListener {
    private static final String TAG = UploadListAdapter.class.getSimpleName();
    private List<UploadViewBean> mUploadViewBeans;
    private OnItemClickListener mOnItemClickListener;
    private Map<String, ConfigBean.PvBean> mPvBeans;

    public UploadListAdapter(List<UploadViewBean> uploadViewBeans) {
        this.mUploadViewBeans = uploadViewBeans;
        this.mPvBeans = MonitorCache.getInstance().getPvBeans();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public int getGroupCount() {
        return null == this.mUploadViewBeans ? 0 : this.mUploadViewBeans.size();
    }

    public int getChildrenCount(int groupPosition) {
        return 1;
    }

    public Object getGroup(int groupPosition) {
        return this.mUploadViewBeans.get(groupPosition);
    }

    public Object getChild(int groupPosition, int childPosition) {
        return childPosition;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return false;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupViewHolder groupViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.upload_event_list_item_group, parent, false);
            groupViewHolder = new GroupViewHolder(convertView);
            convertView.setTag((Object)groupViewHolder);
        } else {
            groupViewHolder = (GroupViewHolder)convertView.getTag();
        }
        if (null == this.mUploadViewBeans) {
            MLog.e(TAG, "getGroupView() -> mUploadViewBeans is null !");
            return convertView;
        }
        UploadViewBean uploadViewBean = this.mUploadViewBeans.get(groupPosition);
        if (null == uploadViewBean) {
            MLog.e(TAG, "getGroupView() -> uploadViewBean is null !");
            return convertView;
        }
        int eventType = uploadViewBean.getEventType();
        if (eventType == 4) {
            groupViewHolder.elementBelongPageNameTv.setVisibility(8);
            groupViewHolder.elementNameTv.setVisibility(8);
            groupViewHolder.pageNameTv.setVisibility(0);
            groupViewHolder.pagePathTv.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)uploadViewBean.getAlias())) {
                groupViewHolder.pageNameTv.setText((CharSequence)("\u9875\u9762" + uploadViewBean.getAlias()));
            }
            if (!TextUtils.isEmpty((CharSequence)uploadViewBean.getPageClassName())) {
                groupViewHolder.pagePathTv.setText((CharSequence)("\u8def\u5f84 [" + PageUtils.getPagePathName(uploadViewBean.getPageClassName()) + "]"));
            }
        } else {
            String mPvMD5;
            ConfigBean.PvBean pvBean;
            groupViewHolder.elementBelongPageNameTv.setVisibility(0);
            groupViewHolder.elementNameTv.setVisibility(0);
            groupViewHolder.pageNameTv.setVisibility(8);
            groupViewHolder.pagePathTv.setVisibility(8);
            if (!TextUtils.isEmpty((CharSequence)uploadViewBean.getAlias())) {
                groupViewHolder.elementNameTv.setText((CharSequence)("\u5143\u7d20" + uploadViewBean.getAlias()));
            }
            if (!TextUtils.isEmpty((CharSequence)uploadViewBean.getPageClassName()) && (pvBean = this.mPvBeans.get(mPvMD5 = MD5Utils.getMD5(uploadViewBean.getPageClassName()))) != null && !TextUtils.isEmpty((CharSequence)pvBean.getAlias())) {
                groupViewHolder.elementBelongPageNameTv.setText((CharSequence)("\u5c5e\u4e8e [" + pvBean.getAlias() + "]"));
            }
        }
        groupViewHolder.deleteEventIv.setTag((Object)groupPosition);
        groupViewHolder.deleteEventIv.setOnClickListener((View.OnClickListener)this);
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ChildViewHolder childViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.upload_event_list_item_child, parent, false);
            childViewHolder = new ChildViewHolder(convertView);
            convertView.setTag((Object)childViewHolder);
        } else {
            childViewHolder = (ChildViewHolder)convertView.getTag();
        }
        if (null == this.mUploadViewBeans) {
            MLog.e(TAG, "getChildView() -> mUploadViewBeans is null !");
            return convertView;
        }
        UploadViewBean uploadViewBean = this.mUploadViewBeans.get(groupPosition);
        if (null == uploadViewBean) {
            MLog.e(TAG, "getChildView() -> uploadViewBean is null !");
            return convertView;
        }
        final String snapshotPath = BitmapStorageUtil.isBitmapExist(uploadViewBean.getMd5()) ? BitmapStorageUtil.getBitmapStoragePath(uploadViewBean.getMd5()) : MonitorCache.getInstance().getServerRoot() + "app/downSnapshot" + "?md5=" + uploadViewBean.getMd5() + "&terminal=" + "ANDROID";
        ((RequestBuilder)Glide.with((View)parent).load(snapshotPath).centerInside()).into(childViewHolder.thumbnail);
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingViewManager.getInstance().showFloatingView(6);
                SnapshotView sv = (SnapshotView)FloatingViewManager.getInstance().getFloatingView(6);
                sv.loadImage(snapshotPath);
            }
        });
        return convertView;
    }

    public void onClick(View v) {
        if (null == this.mOnItemClickListener) {
            MLog.e(TAG, "mOnItemClickListener is null!");
            return;
        }
        int tag = (Integer)v.getTag();
        this.mOnItemClickListener.onItemClick(tag);
        this.notifyDataSetChanged();
    }

    class ChildViewHolder {
        ImageView thumbnail;

        public ChildViewHolder(View itemView) {
            this.thumbnail = (ImageView)itemView.findViewById(R.id.iv_thumbnail_upload);
        }
    }

    class GroupViewHolder {
        ImageView jumpToPageIv;
        ImageView deleteEventIv;
        TextView elementNameTv;
        TextView elementBelongPageNameTv;
        TextView pageNameTv;
        TextView pagePathTv;

        public GroupViewHolder(View itemView) {
            this.jumpToPageIv = (ImageView)itemView.findViewById(R.id.upload_event_list_item_group_jump_to_page_iv);
            this.deleteEventIv = (ImageView)itemView.findViewById(R.id.upload_event_list_item_group_delete_event_iv);
            this.elementNameTv = (TextView)itemView.findViewById(R.id.upload_event_list_item_group_element_name_tv);
            this.elementBelongPageNameTv = (TextView)itemView.findViewById(R.id.upload_event_list_item_group_element_belong_page_name_tv);
            this.pageNameTv = (TextView)itemView.findViewById(R.id.upload_event_list_item_group_page_name_tv);
            this.pagePathTv = (TextView)itemView.findViewById(R.id.upload_event_list_item_group_page_path_tv);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);

        public void jumpToActivity(String var1);
    }
}

