/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.charts;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.LineChartPoint;
import com.chinapex.android.monitor.utils.DateUtils;
import com.chinapex.android.monitor.utils.DensityUtil;
import com.chinapex.android.monitor.utils.MLog;
import java.util.ArrayList;
import java.util.List;

public class LineChart
extends View {
    private static final String TAG = LineChart.class.getSimpleName();
    private static final int CLICK_LINE_ID = 0;
    private static final int PV_LINE_ID = 1;
    private static final int DEFAULT_HEIGHT = 250;
    private static final int DEFAULT_WIDTH = 250;
    private static final int MAX_DATA_LENGTH = 7;
    private long[] mDateArray;
    private long[] mClickCountArray;
    private long[] mPvCountArray;
    private int mWidth;
    private int mHeight;
    private float basePadding;
    private float itemWidth;
    private float maxLineHeight;
    private float minLineHeight;
    private float mLineSpace;
    private float mBaseLinePosition;
    private long mMaxCount;
    private long mMinCount;
    private long mRange;
    private int mPointColor;
    private int mPointStrokeColor;
    private int mTextColor;
    private int mBaseLineColor;
    private int mBrokenLineColor;
    private int mDashLineColor;
    private float mPointRadius;
    private float mPointStrokeWidth;
    private float mTextSize;
    private float mBaseLineWidth;
    private float mBrokenLineWidth;
    private float mDashLineWidth;
    private List<LineChartPoint> mPointsInfoList;
    private Path mPath;
    private Paint mPointPaint;
    private Paint mPointStrokePaint;
    private Paint mBaseLinePaint;
    private Paint mTextPaint;
    private Paint mBrokenLinePaint;
    private Paint mDashLinePaint;

    public LineChart(Context context) {
        this(context, null);
    }

    public LineChart(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LineChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LineChart, 0, 0);
        int defPointColor = -1;
        int defPointStrokeColor = this.getResources().getColor(R.color.c_66BB6A);
        float defPointStrokeWidth = DensityUtil.dip2px(context, 5.0f);
        float defPointRadius = DensityUtil.dip2px(context, 3.0f);
        int defTextColor = Color.parseColor((String)"#212121");
        float defTextSize = DensityUtil.sp2px(context, 12.0f);
        int defBaseLineColor = -16777216;
        float defBaseLineWidth = DensityUtil.dip2px(context, 3.0f);
        int defBrokenLineColor = this.getResources().getColor(R.color.c_66BB6A);
        float defBrokenLineWidth = DensityUtil.dip2px(context, 1.0f);
        int defDashLineColor = -16777216;
        float defDashLineWidth = DensityUtil.dip2px(context, 1.0f);
        this.mPointColor = a.getColor(R.styleable.LineChart_pointColor, defPointColor);
        this.mPointStrokeColor = a.getColor(R.styleable.LineChart_pointStrokeColor, defPointStrokeColor);
        this.mPointRadius = a.getDimension(R.styleable.LineChart_pointRadius, defPointRadius);
        this.mPointStrokeWidth = a.getDimension(R.styleable.LineChart_pointStrokeWidth, defPointStrokeWidth);
        this.mTextColor = a.getColor(R.styleable.LineChart_textColor, defTextColor);
        this.mTextSize = a.getDimension(R.styleable.LineChart_textSize, defTextSize);
        this.mBaseLineColor = a.getColor(R.styleable.LineChart_baseLineColor, defBaseLineColor);
        this.mBaseLineWidth = a.getDimension(R.styleable.LineChart_baseLineWidth, defBaseLineWidth);
        this.mBrokenLineColor = a.getColor(R.styleable.LineChart_brokenLineColor, defBrokenLineColor);
        this.mBrokenLineWidth = a.getDimension(R.styleable.LineChart_baseLineWidth, defBrokenLineWidth);
        this.mDashLineColor = a.getColor(R.styleable.LineChart_dashLineColor, defDashLineColor);
        this.mDashLineWidth = a.getDimension(R.styleable.LineChart_dashLineWidth, defDashLineWidth);
        a.recycle();
        this.init();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measureWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measureHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int measureWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int measureHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (measureWidthMode == Integer.MIN_VALUE && measureHeightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(250, 250);
        } else if (measureWidthMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(250, measureHeightSize);
        } else if (measureHeightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(measureWidthSize, 250);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w - this.getPaddingLeft() - this.getPaddingRight();
        this.mHeight = h - this.getPaddingTop() - this.getPaddingBottom();
        this.basePadding = (float)this.mWidth / 16.0f;
        this.itemWidth = ((float)this.mWidth - 2.0f * this.basePadding) / 6.0f;
        this.minLineHeight = this.mHeight - this.mHeight * 4 / 5;
        this.maxLineHeight = this.mHeight - this.mHeight / 5;
        this.mLineSpace = this.maxLineHeight - this.minLineHeight;
        this.caculatePointsInfo();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawDateText(canvas);
        this.drawBaseLine(canvas);
        this.drawPoints(canvas);
    }

    public void setData(long[] dateArray, long[] clickCountArray, long[] pvCountArray) {
        int n;
        long[] tmp;
        if (null == dateArray || null == clickCountArray || null == pvCountArray) {
            MLog.e(TAG, "setData()-> params can not be null!");
            return;
        }
        if (dateArray.length == 0 || clickCountArray.length == 0 || pvCountArray.length == 0) {
            MLog.e(TAG, "setData()-> no data in the array!");
            return;
        }
        if (dateArray.length > 7) {
            tmp = dateArray;
            dateArray = new long[7];
            System.arraycopy(tmp, 0, dateArray, 0, 7);
        }
        if (clickCountArray.length > 7) {
            tmp = clickCountArray;
            clickCountArray = new long[7];
            System.arraycopy(tmp, 0, clickCountArray, 0, 7);
        }
        if (pvCountArray.length > 7) {
            tmp = pvCountArray;
            pvCountArray = new long[7];
            System.arraycopy(tmp, 0, pvCountArray, 0, 7);
        }
        this.mDateArray = dateArray;
        this.mClickCountArray = clickCountArray;
        this.mPvCountArray = pvCountArray;
        long minTmp = clickCountArray[0];
        long maxTmp = clickCountArray[0];
        long[] lArray = clickCountArray;
        int n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            Long count = lArray[n];
            if (count < 0L) continue;
            if (count < minTmp) {
                minTmp = count;
            }
            if (count <= maxTmp) continue;
            maxTmp = count;
        }
        lArray = pvCountArray;
        n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            Long pv = lArray[n];
            if (pv < 0L) continue;
            if (pv < minTmp) {
                minTmp = pv;
            }
            if (pv <= maxTmp) continue;
            maxTmp = pv;
        }
        this.mMaxCount = maxTmp;
        this.mMinCount = minTmp;
        MLog.d(TAG, "max" + this.mMaxCount + "min" + this.mMinCount);
        this.mRange = this.mMaxCount - this.mMinCount;
        this.mRange = this.mRange == 0L ? 1L : this.mRange;
        this.caculatePointsInfo();
        this.invalidate();
    }

    public List<LineChartPoint> getmPointsInfoList() {
        return this.mPointsInfoList;
    }

    private void init() {
        this.mPath = new Path();
        this.mPointsInfoList = new ArrayList<LineChartPoint>();
        this.mPointPaint = new Paint(1);
        this.mPointPaint.setStyle(Paint.Style.FILL);
        this.mPointPaint.setColor(this.mPointColor);
        this.mPointStrokePaint = new Paint(1);
        this.mPointStrokePaint.setStyle(Paint.Style.STROKE);
        this.mPointStrokePaint.setColor(this.mPointStrokeColor);
        this.mPointStrokePaint.setStrokeWidth(this.mPointStrokeWidth);
        this.mBaseLinePaint = new Paint(1);
        this.mBaseLinePaint.setStyle(Paint.Style.FILL);
        this.mBaseLinePaint.setColor(this.mBaseLineColor);
        this.mBaseLinePaint.setStrokeWidth(this.mBaseLineWidth);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mBrokenLinePaint = new Paint(1);
        this.mBrokenLinePaint.setStyle(Paint.Style.STROKE);
        this.mBrokenLinePaint.setColor(this.mBrokenLineColor);
        this.mBrokenLinePaint.setStrokeWidth(this.mBrokenLineWidth);
        this.mDashLinePaint = new Paint(1);
        this.mDashLinePaint.setStyle(Paint.Style.STROKE);
        this.mDashLinePaint.setStrokeWidth(this.mDashLineWidth);
        this.mDashLinePaint.setColor(this.mDashLineColor);
        this.mDashLinePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{5.0f, 10.0f}, 0.0f));
    }

    private void caculatePointsInfo() {
        LineChartPoint point;
        float dy;
        float dx;
        int i;
        if (null == this.mDateArray) {
            MLog.w(TAG, "caculatePointsInfo()-> mDateArray is null");
            return;
        }
        if (null == this.mClickCountArray) {
            MLog.w(TAG, "caculatePointsInfo()-> mClickCount is null");
            return;
        }
        if (null == this.mPvCountArray) {
            MLog.d(TAG, "caculatePointsInfo()-> mPvCountArray is null");
            return;
        }
        int dataLength = this.mDateArray.length;
        this.mPointsInfoList.clear();
        for (i = 0; i < dataLength; ++i) {
            dx = this.basePadding + this.itemWidth * (float)i;
            dy = (float)this.mHeight - ((float)(this.mClickCountArray[i] - this.mMinCount) * this.mLineSpace / (float)this.mRange + this.minLineHeight);
            point = LineChartPoint.of(dx, dy, this.mDateArray[i], this.mClickCountArray[i], 0);
            this.mPointsInfoList.add(point);
        }
        for (i = 0; i < dataLength; ++i) {
            dx = this.basePadding + this.itemWidth * (float)i;
            dy = (float)this.mHeight - ((float)(this.mPvCountArray[i] - this.mMinCount) * this.mLineSpace / (float)this.mRange + this.minLineHeight);
            point = LineChartPoint.of(dx, dy, this.mDateArray[i], this.mPvCountArray[i], 1);
            this.mPointsInfoList.add(point);
        }
    }

    private void drawBaseLine(Canvas canvas) {
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        float fontHeight = fontMetrics.descent - fontMetrics.ascent;
        this.mBaseLinePosition = (float)this.mHeight - fontHeight * 3.0f / 2.0f;
        int startx = (int)this.basePadding;
        int endx = (int)((float)this.mWidth - this.basePadding);
        int y = (int)this.mBaseLinePosition;
        canvas.drawLine((float)startx, (float)y, (float)endx, (float)y, this.mBaseLinePaint);
    }

    private void drawDateText(Canvas canvas) {
        float dy = this.mHeight;
        if (null == this.mDateArray || 0 == this.mDateArray.length) {
            MLog.w(TAG, "drawDateText()-> mDateArray is empty");
            return;
        }
        for (int i = 0; i < this.mDateArray.length; ++i) {
            LineChartPoint point = this.mPointsInfoList.get(i);
            canvas.drawText(DateUtils.long2DateFormat2(this.mDateArray[i]), point.getX(), dy, this.mTextPaint);
        }
    }

    private void drawPoints(Canvas canvas) {
        float dy;
        LineChartPoint point;
        int i;
        boolean needReset = true;
        for (i = 0; i < this.mPointsInfoList.size(); ++i) {
            point = this.mPointsInfoList.get(i);
            float dx = point.getX();
            dy = point.getY();
            long value = point.getValue();
            int lineId = point.getLineId();
            if (value < 0L) {
                needReset = true;
                continue;
            }
            if (i == this.mPointsInfoList.size() / 2) {
                needReset = true;
            }
            if (lineId == 0) {
                this.mBrokenLinePaint.setColor(this.mBrokenLineColor);
            }
            if (lineId == 1) {
                this.mBrokenLinePaint.setColor(this.getResources().getColor(R.color.c_FFB74D));
            }
            if (needReset) {
                this.mPath.reset();
                this.mPath.moveTo(dx, dy);
                needReset = false;
                continue;
            }
            this.mPath.lineTo(dx, dy);
            canvas.drawPath(this.mPath, this.mBrokenLinePaint);
        }
        for (i = 0; i < this.mPointsInfoList.size() / 2; ++i) {
            LineChartPoint point1 = this.mPointsInfoList.get(i);
            LineChartPoint point2 = this.mPointsInfoList.get(this.mPointsInfoList.size() / 2 + i);
            float dx = point1.getX();
            float dy1 = point1.getY();
            float dy2 = point2.getY();
            long value1 = point1.getValue();
            long value2 = point2.getValue();
            if (value1 < 0L && value2 < 0L) continue;
            float dy3 = dy1 > dy2 ? dy2 : dy1;
            this.mPath.reset();
            this.mPath.moveTo(dx, dy3);
            this.mPath.lineTo(dx, this.mBaseLinePosition);
            canvas.drawPath(this.mPath, this.mDashLinePaint);
        }
        for (i = 0; i < this.mPointsInfoList.size(); ++i) {
            point = this.mPointsInfoList.get(i);
            float dx = point.getX();
            dy = point.getY();
            long value = point.getValue();
            int lineId = point.getLineId();
            if (value < 0L) continue;
            if (lineId == 0) {
                this.mPointPaint.setColor(this.mPointColor);
                this.mPointStrokePaint.setColor(this.mPointStrokeColor);
            }
            if (lineId == 1) {
                this.mPointPaint.setColor(-1);
                this.mPointStrokePaint.setColor(this.getResources().getColor(R.color.c_FFB74D));
            }
            canvas.drawCircle(dx, dy, this.mPointRadius, this.mPointStrokePaint);
            canvas.drawCircle(dx, dy, this.mPointRadius, this.mPointPaint);
        }
    }
}

