/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.charts;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.LineChartPoint;
import com.chinapex.android.monitor.utils.DateUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.charts.LineChart;
import java.util.List;

public class LineChartContainer
extends FrameLayout {
    private static final String TAG = LineChartContainer.class.getSimpleName();
    private LineChart mLineChart;
    private TextView label;
    private List<LineChartPoint> mLineChartPointsInfo;
    private float mDownX;
    private float mDownY;
    private int mTouchSlop;

    public LineChartContainer(@NonNull Context context) {
        this(context, null);
    }

    public LineChartContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LineChartContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LineChartContainer.inflate((Context)context, (int)R.layout.layout_linechart_container, (ViewGroup)this);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mLineChart = (LineChart)this.findViewById(R.id.line_chart);
        this.label = (TextView)this.findViewById(R.id.tv_label);
        this.mLineChartPointsInfo = this.mLineChart.getmPointsInfoList();
    }

    public void setData(long[] dateArray, long[] clickCountArray, long[] pvCountArray) {
        this.mLineChart.setData(dateArray, clickCountArray, pvCountArray);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.mDownX = event.getX();
                this.mDownY = event.getY();
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                float x = event.getX();
                float y = event.getY();
                if (this.mLineChartPointsInfo == null || this.mLineChartPointsInfo.size() == 0) {
                    return true;
                }
                if (!(Math.abs(x - this.mDownX) < (float)this.mTouchSlop) || !(Math.abs(y - this.mDownY) < (float)this.mTouchSlop)) break;
                for (LineChartPoint point : this.mLineChartPointsInfo) {
                    float dx = point.getX();
                    float dy = point.getY();
                    float radius = 30.0f;
                    boolean isInCircle = this.mDownX < dx + radius && this.mDownX > dx - radius && this.mDownY < dy + radius && this.mDownY > dy - radius;
                    if (!isInCircle) continue;
                    MLog.d(TAG, "dx=" + dx + " dy=" + dy);
                    String date = DateUtils.long2DateFormat1(point.getDate());
                    String count = String.valueOf(point.getValue());
                    StringBuilder sb = new StringBuilder();
                    sb.append(date).append("\n");
                    if (point.getLineId() == 0) {
                        String labelText = date + "\n" + this.getResources().getString(R.string.click_count) + count;
                        sb.append(this.getResources().getString(R.string.click_count)).append(count);
                        this.label.setTextColor(this.getResources().getColor(R.color.c_66BB6A));
                    } else if (point.getLineId() == 1) {
                        sb.append(this.getResources().getString(R.string.pv_count)).append(count);
                        this.label.setTextColor(this.getResources().getColor(R.color.c_FFB74D));
                    } else {
                        MLog.e(TAG, "no this line id!");
                    }
                    this.label.setText((CharSequence)sb.toString());
                    this.label.setVisibility(0);
                    if (dx < (float)(this.getWidth() / 2)) {
                        this.label.setTranslationX(dx);
                        this.label.setTranslationY(dy);
                    } else {
                        this.label.setTranslationX(dx - (float)this.label.getWidth());
                        this.label.setTranslationY(dy);
                    }
                    return true;
                }
                break;
            }
        }
        return true;
    }
}

