/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.charts;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.chinapex.android.monitor.utils.MLog;
import java.util.ArrayList;
import java.util.List;

public class PieChart
extends View {
    private static final String TAG = PieChart.class.getSimpleName();
    private static final int DEFAULT_RADIUS = 100;
    private static final int INIT_ANIMATION_DURATION = 1000;
    private static final int POP_ANIMATION_DURATION = 300;
    private static final float POP_PIE_TRANSLATION_LENGTH = 25.0f;
    private static final int NO_ANIMATION_RUNNING = 0;
    private static final int POP_ANIMATION_RUNNING = 2;
    private static final int RESTORE_ANIMATION_RUNNING = 4;
    private long[] data;
    private int[] mColor;
    private long sum;
    private Paint mPaint;
    private RectF mRect;
    private List<ArcInfo> arcList;
    private float mAnimateAngle;
    private boolean mIsFirstTimeVisible;
    private int mAnimationFlag;

    public PieChart(Context context) {
        this(context, null);
    }

    public PieChart(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PieChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mIsFirstTimeVisible = true;
        this.arcList = new ArrayList<ArcInfo>();
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-3355444);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measureWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measureHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int measureWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int measureHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (measureWidthMode == Integer.MIN_VALUE && measureHeightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(200, 200);
        } else if (measureWidthMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(200, measureHeightSize);
        } else if (measureHeightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(measureWidthSize, 200);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int width = w - this.getPaddingLeft() - this.getPaddingRight();
        int height = h - this.getPaddingTop() - this.getPaddingBottom();
        int radius = width > height ? height / 2 : width / 2;
        float centerX = (float)w / 2.0f;
        float centerY = (float)h / 2.0f;
        this.mRect = radius > 100 ? new RectF(centerX - (float)radius, centerY - (float)radius, centerX + (float)radius, centerY + (float)radius) : new RectF(centerX - 100.0f, centerY - 100.0f, centerX + 100.0f, centerY + 100.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.arcList == null || this.arcList.size() == 0) {
            canvas.drawArc(this.mRect, 0.0f, 360.0f, true, this.mPaint);
            return;
        }
        for (int i = 0; i < this.arcList.size(); ++i) {
            ArcInfo arcInfo = this.arcList.get(i);
            float startAngle = arcInfo.getStartAngle();
            float sweepAngle = arcInfo.getSweepAngle();
            int color2 = arcInfo.getColor();
            this.mPaint.setColor(color2);
            float animateSweepAngle = Math.min(sweepAngle, this.mAnimateAngle - startAngle);
            if (!(animateSweepAngle > 0.0f)) continue;
            if (arcInfo.isPopPie) {
                canvas.save();
                float dx = arcInfo.getTranslationX();
                float dy = arcInfo.getTranslationY();
                canvas.translate(dx, dy);
                canvas.drawArc(this.mRect, startAngle, animateSweepAngle, true, this.mPaint);
                canvas.restore();
                continue;
            }
            canvas.drawArc(this.mRect, startAngle, animateSweepAngle, true, this.mPaint);
        }
    }

    public void setData(long[] data, int[] color2) {
        this.data = data;
        this.sum = 0L;
        long[] lArray = data;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long i2 = lArray[i];
            this.sum += i2.longValue();
        }
        this.mColor = color2;
        this.calculateArcInfo();
        this.invalidate();
    }

    public void popChosenPie(int i) {
        if (this.mAnimationFlag != 0) {
            MLog.d(TAG, "popChosenPie()-> animation is running, do no operation");
            return;
        }
        if (this.arcList.size() <= 1) {
            MLog.i(TAG, "popChosenPie()-> one pie, do not pop");
            return;
        }
        if (i < 0 || i > this.arcList.size() - 1) {
            MLog.e(TAG, "popChosenPie()-> illegal argument");
            return;
        }
        ArcInfo popPie = this.arcList.get(i);
        ArcInfo prePopPie = null;
        for (ArcInfo arcInfo : this.arcList) {
            if (!arcInfo.isPopPie()) continue;
            prePopPie = arcInfo;
        }
        if (null == prePopPie) {
            this.popAnimator(popPie);
            return;
        }
        if (null == popPie) {
            MLog.d(TAG, "popChosenPie()-> pop pie info is abnormally null");
            return;
        }
        if (popPie.isPopPie()) {
            this.restoreAnimator(popPie);
        } else {
            this.restoreAnimator(prePopPie);
            this.popAnimator(popPie);
        }
    }

    private void calculateArcInfo() {
        if (this.data == null || this.data.length == 0 || this.sum == 0L) {
            this.arcList.clear();
            ArcInfo arcInfo = new ArcInfo();
            arcInfo.setStartAngle(0.0f);
            arcInfo.setSweepAngle(360.0f);
            arcInfo.setCenterAngle(180.0f);
            arcInfo.setColor(-3355444);
            this.arcList.add(arcInfo);
            return;
        }
        if (this.arcList.size() > 0) {
            this.arcList.clear();
        }
        int startAngle = 0;
        for (int i = 0; i < this.data.length; ++i) {
            float sweepAngle = i == this.data.length - 1 ? (float)(360 - startAngle) : (float)this.data[i] / (float)this.sum * 360.0f;
            ArcInfo arcInfo = new ArcInfo();
            arcInfo.setStartAngle(startAngle);
            arcInfo.setSweepAngle(sweepAngle);
            arcInfo.setColor(this.mColor[i]);
            startAngle = (int)((float)startAngle + sweepAngle);
            float centerAngle = (float)startAngle - sweepAngle / 2.0f;
            arcInfo.setCenterAngle(centerAngle);
            this.arcList.add(arcInfo);
        }
    }

    private void initAnimator() {
        ValueAnimator initAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        initAnimation.setDuration(1000L);
        initAnimation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        initAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                PieChart.this.mAnimateAngle = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                PieChart.this.invalidate();
            }
        });
        initAnimation.start();
        this.mIsFirstTimeVisible = false;
    }

    private void popAnimator(final ArcInfo popPie) {
        popPie.setPopPie(true);
        double radian = Math.toRadians(popPie.getCenterAngle());
        float dx = (float)(25.0 * Math.cos(radian));
        float dy = (float)(25.0 * Math.sin(radian));
        ValueAnimator xAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, dx});
        ValueAnimator yAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, dy});
        xAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                popPie.setTranslationX(value);
                PieChart.this.invalidate();
            }
        });
        yAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                popPie.setTranslationY(value);
                PieChart.this.invalidate();
            }
        });
        AnimatorSet popAnimatorSet = new AnimatorSet();
        popAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        popAnimatorSet.playTogether(new Animator[]{xAnimation, yAnimation});
        popAnimatorSet.setDuration(300L);
        popAnimatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                PieChart.this.mAnimationFlag = PieChart.this.mAnimationFlag | 2;
            }

            public void onAnimationEnd(Animator animation) {
                PieChart.this.mAnimationFlag = PieChart.this.mAnimationFlag & 0xFFFFFFFD;
            }

            public void onAnimationCancel(Animator animation) {
                PieChart.this.mAnimationFlag = PieChart.this.mAnimationFlag & 0xFFFFFFFD;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        popAnimatorSet.start();
    }

    private void restoreAnimator(final ArcInfo restorePie) {
        ValueAnimator xAnimation = ValueAnimator.ofFloat((float[])new float[]{restorePie.getTranslationX(), 0.0f});
        ValueAnimator yAnimation = ValueAnimator.ofFloat((float[])new float[]{restorePie.getTranslationY(), 0.0f});
        xAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                restorePie.setTranslationX(value);
                PieChart.this.invalidate();
            }
        });
        yAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                restorePie.setTranslationY(value);
                PieChart.this.invalidate();
            }
        });
        AnimatorSet restoreAnimatorSet = new AnimatorSet();
        restoreAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        restoreAnimatorSet.playTogether(new Animator[]{xAnimation, yAnimation});
        restoreAnimatorSet.setDuration(300L);
        restoreAnimatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                PieChart.this.mAnimationFlag = PieChart.this.mAnimationFlag | 4;
            }

            public void onAnimationEnd(Animator animator) {
                restorePie.setPopPie(false);
                PieChart.this.mAnimationFlag = PieChart.this.mAnimationFlag & 0xFFFFFFFB;
            }

            public void onAnimationCancel(Animator animator) {
                PieChart.this.mAnimationFlag = PieChart.this.mAnimationFlag & 0xFFFFFFFB;
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        restoreAnimatorSet.start();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0 && this.mIsFirstTimeVisible) {
            this.initAnimator();
        }
    }

    class ArcInfo {
        private boolean isPopPie;
        private float translationX;
        private float translationY;
        private float startAngle;
        private float sweepAngle;
        private float centerAngle;
        private int color;

        ArcInfo() {
        }

        public boolean isPopPie() {
            return this.isPopPie;
        }

        public void setPopPie(boolean popPie) {
            this.isPopPie = popPie;
        }

        public float getTranslationX() {
            return this.translationX;
        }

        public void setTranslationX(float translationX) {
            this.translationX = translationX;
        }

        public float getTranslationY() {
            return this.translationY;
        }

        public void setTranslationY(float translationY) {
            this.translationY = translationY;
        }

        float getStartAngle() {
            return this.startAngle;
        }

        void setStartAngle(float startAngle) {
            this.startAngle = startAngle;
        }

        float getSweepAngle() {
            return this.sweepAngle;
        }

        void setSweepAngle(float sweepAngle) {
            this.sweepAngle = sweepAngle;
        }

        float getCenterAngle() {
            return this.centerAngle;
        }

        void setCenterAngle(float centerAngle) {
            this.centerAngle = centerAngle;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color2) {
            this.color = color2;
        }

        public String toString() {
            return "startAngle" + this.startAngle + "\nsweepAngle" + this.sweepAngle + "\ncenterAngle" + this.centerAngle + '\n' + "color" + this.color;
        }
    }
}

