/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.charts;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.utils.NumberUtils;

public class PieForm
extends LinearLayout {
    private ImageView iv;
    private TextView tvEventName;
    private TextView tvClickCount;
    private TextView tvClickPercent;

    public PieForm(Context context) {
        this(context, null);
    }

    public PieForm(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PieForm(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        PieForm.inflate((Context)context, (int)R.layout.layout_pieform, (ViewGroup)this);
        this.init();
    }

    private void init() {
        this.iv = (ImageView)this.findViewById(R.id.event_color_iv);
        this.tvEventName = (TextView)this.findViewById(R.id.tv_event_name);
        this.tvClickCount = (TextView)this.findViewById(R.id.tv_click_count);
        this.tvClickPercent = (TextView)this.findViewById(R.id.tv_click_percent);
    }

    public void setEventColor(int color2) {
        this.iv.setBackgroundColor(color2);
    }

    public void setTvEventName(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        this.tvEventName.setText((CharSequence)name);
    }

    public void setTvClickCount(long count) {
        this.tvClickCount.setText((CharSequence)NumberUtils.getThousandSeparatorNum(count));
    }

    public void setTvClickPercent(float percent) {
        this.tvClickPercent.setText((CharSequence)NumberUtils.getFormatPercent(percent, 2));
    }
}

