/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.config;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ImportConfigBean;
import com.chinapex.android.monitor.callback.IGetAllConfigVersionsCallback;
import com.chinapex.android.monitor.changelistener.IDownloadConfigCallback;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.executor.runnable.DownloadConfig;
import com.chinapex.android.monitor.executor.runnable.GetAllConfigVersions;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.adapter.ConfigRvAdapter;
import com.chinapex.android.monitor.view.loading.LoadingView;
import java.util.ArrayList;
import java.util.List;

public class ImportConfigView
extends BaseFloatingView
implements View.OnClickListener,
ConfigRvAdapter.OnItemClickListener,
IGetAllConfigVersionsCallback,
IDownloadConfigCallback {
    private static final String TAG = ImportConfigView.class.getSimpleName();
    private RecyclerView mRvImportConfig;
    private List<ImportConfigBean> mImportConfigBeans;
    private ConfigRvAdapter mConfigRvAdapter;
    private String mCurrentSelectedVersion;

    public ImportConfigView(@NonNull Context context, int windowType) {
        super(context, windowType);
        ImportConfigView.inflate((Context)context, (int)R.layout.layout_window_import_config, (ViewGroup)this);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.mRvImportConfig = (RecyclerView)this.findViewById(R.id.rv_import_config);
        this.findViewById(R.id.btn_import_config_confirm).setOnClickListener((View.OnClickListener)this);
    }

    private void initData() {
        this.mCurrentSelectedVersion = null;
        this.mImportConfigBeans = new ArrayList<ImportConfigBean>();
        TaskController.getInstance().submit(new GetAllConfigVersions(this));
        this.mConfigRvAdapter = new ConfigRvAdapter(this.mImportConfigBeans);
        this.mConfigRvAdapter.setOnItemClickListener(this);
        this.mRvImportConfig.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(MonitorCache.getInstance().getContext(), 1, false));
        this.mRvImportConfig.setAdapter((RecyclerView.Adapter)this.mConfigRvAdapter);
    }

    @Override
    public void show() {
        super.show();
        IMonitorListenerController.getInstance().addIDownloadConfigCallback(this);
    }

    @Override
    public void dismiss() {
        IMonitorListenerController.getInstance().removeIDownloadConfigCallback(this);
        super.dismiss();
    }

    @Override
    public void getAllConfigVersions(final List<String> versions) {
        if (null == versions || versions.isEmpty()) {
            MLog.e(TAG, "getAllConfigVersions() -> versions is null or empty!");
            return;
        }
        if (null == this.mImportConfigBeans) {
            MLog.e(TAG, "getAllConfigVersions() -> mImportConfigBeans is null!");
            return;
        }
        TaskController.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int preClearSize = ImportConfigView.this.mImportConfigBeans.size();
                ImportConfigView.this.mImportConfigBeans.clear();
                ImportConfigView.this.mConfigRvAdapter.notifyItemRangeRemoved(0, preClearSize);
                for (String version : versions) {
                    if (TextUtils.isEmpty((CharSequence)version)) {
                        MLog.e(TAG, "getAllConfigVersions() -> version is null or empty!");
                        continue;
                    }
                    ImportConfigBean importConfigBean = new ImportConfigBean();
                    importConfigBean.setVersion(version);
                    ImportConfigView.this.mImportConfigBeans.add(importConfigBean);
                }
                ImportConfigView.this.mConfigRvAdapter.notifyItemRangeInserted(0, ImportConfigView.this.mImportConfigBeans.size());
            }
        });
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (R.id.btn_import_config_confirm == viewId) {
            FloatingViewManager.getInstance().showFloatingView(8);
            LoadingView loadingView = (LoadingView)FloatingViewManager.getInstance().getFloatingView(8);
            if (null == loadingView) {
                MLog.e(TAG, "onClick() -> btn_import_config_confirm: loadingView is null!");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mCurrentSelectedVersion)) {
                loadingView.setLoadingFail(this.getResources().getString(R.string.loading_select_config));
            } else {
                loadingView.setLoading(this.getResources().getString(R.string.loading_downloading));
                TaskController.getInstance().submit(new DownloadConfig(this.mCurrentSelectedVersion));
            }
        } else {
            MLog.e(TAG, "unknown click!");
        }
    }

    @Override
    public void onItemClick(int position) {
        if (null == this.mImportConfigBeans) {
            MLog.e(TAG, "onItemClick() -> mImportConfigBeans is null!");
            return;
        }
        ImportConfigBean importConfigBean = this.mImportConfigBeans.get(position);
        if (null == importConfigBean) {
            MLog.e(TAG, "onItemClick() -> importConfigBean is null!");
            return;
        }
        this.mCurrentSelectedVersion = importConfigBean.getVersion();
        MLog.i(TAG, "onItemClick() -> mCurrentSelectedVersion is: " + this.mCurrentSelectedVersion);
    }

    @Override
    public void downloadConfig(final boolean isSuccessful) {
        final LoadingView loadingView = (LoadingView)FloatingViewManager.getInstance().getFloatingView(8);
        if (null == loadingView) {
            MLog.e(TAG, "downloadConfig() -> loadingView is null!");
            return;
        }
        TaskController.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (isSuccessful) {
                    loadingView.setLoadingOk(ImportConfigView.this.getResources().getString(R.string.loading_download_ok));
                    FloatingViewManager.getInstance().dismissFloatingView(7);
                } else {
                    loadingView.setLoadingFail(ImportConfigView.this.getResources().getString(R.string.loading_download_fail));
                }
            }
        });
    }
}

