/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.event;

import android.app.Activity;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.request.EventDataRequest;
import com.chinapex.android.monitor.bean.response.EventDataResponse;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.executor.runnable.IUpdateUI;
import com.chinapex.android.monitor.executor.runnable.PullEventData;
import com.chinapex.android.monitor.executor.runnable.SaveViewSnapshot;
import com.chinapex.android.monitor.executor.runnable.WriteClickToSp;
import com.chinapex.android.monitor.executor.runnable.WriteElemPvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteExpandablePvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteListPvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteListToSp;
import com.chinapex.android.monitor.executor.runnable.WritePvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteRecyclerPvToSp;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MD5Utils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.SnapshotUtil;
import com.chinapex.android.monitor.utils.SystemUtils;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.event.DefineEventContract;
import com.chinapex.android.monitor.view.event.InputPageOrElementNameView;
import com.chinapex.android.monitor.view.snapshot.SnapshotView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class DefineEventPresenter
implements DefineEventContract.Presenter,
IUpdateUI {
    private static final String TAG = DefineEventPresenter.class.getSimpleName();
    private DefineEventContract.View mDefineEventView;
    private ConfigBean.PvBean mPvBean;
    private ConfigBean.ClickBean mClickBean;
    private ConfigBean.ListBean mListBean;
    private Bitmap mViewSnapshot;
    PullEventData pullEventData;

    public DefineEventPresenter(DefineEventContract.View view) {
        this.mDefineEventView = view;
        this.mPvBean = new ConfigBean.PvBean();
        this.mClickBean = new ConfigBean.ClickBean();
        this.mListBean = new ConfigBean.ListBean();
    }

    @Override
    public void inputPageOrEelementName(String nameJson) {
        FloatingViewManager.getInstance().showFloatingView(9);
        InputPageOrElementNameView inputPageOrElementNameView = (InputPageOrElementNameView)FloatingViewManager.getInstance().getFloatingView(9);
        if (null == inputPageOrElementNameView) {
            MLog.e(TAG, "showSnapshot()-> snapshotView is null");
            return;
        }
        inputPageOrElementNameView.initData(nameJson);
    }

    @Override
    public void loadPvData() {
        Map<Integer, Stack<Map<String, Boolean>>> tasks = MonitorCache.getInstance().getTasks();
        Map<Integer, Integer> top = MonitorCache.getInstance().getTop();
        int[] foregroundTask = MonitorCache.getInstance().getForegroundTask();
        if (null == tasks) {
            MLog.e(TAG, "loadPvData()-> tasks is null");
            return;
        }
        if (null == top) {
            MLog.e(TAG, "loadPvData()-> top is null");
            return;
        }
        if (null == foregroundTask) {
            MLog.e(TAG, "loadPvData()-> foregroundTask is null");
            return;
        }
        int taskId = foregroundTask[0];
        if (!tasks.containsKey(taskId)) {
            MLog.e(TAG, "loadPvData()-> tasks do not contain task[" + taskId + "]");
            return;
        }
        Stack<Map<String, Boolean>> task = tasks.get(taskId);
        if (null == task || task.isEmpty()) {
            MLog.e(TAG, "loadPvData()-> task[" + taskId + "] is empty");
            return;
        }
        ArrayList<String> pages = new ArrayList<String>();
        String reference = null;
        if (!top.containsKey(taskId)) {
            MLog.e(TAG, "loadPvData()-> top does not contain top[" + taskId + "]");
            return;
        }
        Integer topActivity = top.get(taskId);
        if (null == topActivity) {
            MLog.e(TAG, "loadPvData()-> top has null element");
            return;
        }
        for (int i = task.size() - 1; i >= topActivity; --i) {
            Map map = (Map)task.get(i);
            if (null == map) {
                MLog.e(TAG, "loadPvData()-> map should not be null");
                return;
            }
            String[] key = map.keySet().toArray(new String[1]);
            if (key.length != 1) {
                MLog.e(TAG, "loadPvData()-> keyset size can only be 1");
                return;
            }
            pages.add(key[0]);
            Boolean isActivity = (Boolean)map.get(key[0]);
            if (null == isActivity) {
                MLog.e(TAG, "loadPvData()-> map has null element");
                return;
            }
            if (!isActivity.booleanValue()) continue;
            reference = key[0];
        }
        Activity activity = SystemUtils.getCurrentActivity();
        String pageClassPath = activity.getClass().getName();
        String h5Url = MonitorCache.getInstance().getH5Url(pageClassPath);
        if (!TextUtils.isEmpty((CharSequence)h5Url)) {
            pages.add(pageClassPath + "::" + h5Url);
        }
        if (pages.isEmpty()) {
            MLog.e(TAG, "loadPvData()-> pages is empty!");
            return;
        }
        if (null == reference) {
            MLog.e(TAG, "loadPvData()-> reference is null!");
            return;
        }
        this.mDefineEventView.loadPagePath(pages);
        if (null == activity) {
            MLog.e(TAG, "loadPvData()-> fail to get top activity");
            return;
        }
        View decorView = activity.getWindow().getDecorView();
        this.mViewSnapshot = SnapshotUtil.takeSnapshot(decorView);
        this.mDefineEventView.showViewSnapshot(this.mViewSnapshot);
    }

    @Override
    public void updatePvData(String viewPath) {
        this.requestEventData(MD5Utils.getMD5(viewPath), "page", 7);
    }

    @Override
    public void loadH5ClickData(String viewPath, String pageClass, String findPath) {
        if (null == viewPath) {
            MLog.e(TAG, "loadClickData()-> viewPath is null!");
            return;
        }
        if (null == pageClass) {
            MLog.e(TAG, "loadClickData()-> pageClass is null!");
            return;
        }
        if (null == findPath) {
            MLog.e(TAG, "loadClickData()-> findPath is null!");
            return;
        }
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        if (null == pvBeans) {
            MLog.e(TAG, "loadClickData()-> pvBeans is null!");
            return;
        }
        String definedPage = null;
        for (ConfigBean.PvBean pvBean : pvBeans.values()) {
            if (null == pvBean) {
                MLog.e(TAG, "loadClickData()-> pvBean is null!");
                continue;
            }
            if (null == pvBean.getViewPath()) {
                MLog.e(TAG, "loadClickData()-> viewPath of pvBean is null!");
                continue;
            }
            if (!pageClass.equals(pvBean.getViewPath())) continue;
            definedPage = pvBean.getViewPath();
            break;
        }
        if (TextUtils.isEmpty(definedPage)) {
            MLog.e(TAG, "loadClickData()-> no defined page!");
            this.mDefineEventView.showToast(R.string.defined_page_hint);
            this.dismiss();
            return;
        }
        Map<String, ConfigBean.ClickBean> clickBeans = MonitorCache.getInstance().getClickBeans();
        if (null == clickBeans) {
            MLog.e(TAG, "loadClickData()-> clickBeans is null!");
            return;
        }
        String viewPathMd5 = MD5Utils.getMD5(viewPath);
        ConfigBean.ClickBean clickBean = clickBeans.get(viewPathMd5);
        if (null != clickBean) {
            this.mDefineEventView.showAlias(clickBean.getAlias());
        }
        this.mClickBean.setDefinedPage(definedPage);
        this.mClickBean.setPageClassName(pageClass);
        this.mClickBean.setViewPath(viewPath);
        this.mClickBean.setFindPath(findPath);
        this.mDefineEventView.showViewPath(viewPath);
        this.mDefineEventView.showReference(definedPage, null);
        this.requestEventData(viewPathMd5, "element", 7);
    }

    @Override
    public void loadClickData(View view, String viewPath, String pageClass, String findPath) {
        if (null == viewPath) {
            MLog.e(TAG, "loadClickData()-> viewPath is null!");
            return;
        }
        if (null == pageClass) {
            MLog.e(TAG, "loadClickData()-> pageClass is null!");
            return;
        }
        if (null == findPath) {
            MLog.e(TAG, "loadClickData()-> findPath is null!");
            return;
        }
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        if (null == pvBeans) {
            MLog.e(TAG, "loadClickData()-> pvBeans is null!");
            return;
        }
        String definedPage = null;
        for (ConfigBean.PvBean pvBean : pvBeans.values()) {
            if (null == pvBean) {
                MLog.e(TAG, "loadClickData()-> pvBean is null!");
                continue;
            }
            if (null == pvBean.getViewPath()) {
                MLog.e(TAG, "loadClickData()-> viewPath of pvBean is null!");
                continue;
            }
            if (!pageClass.equals(pvBean.getViewPath())) continue;
            definedPage = pvBean.getViewPath();
            break;
        }
        if (TextUtils.isEmpty(definedPage)) {
            MLog.e(TAG, "loadClickData()-> no defined page!");
            this.mDefineEventView.showToast(R.string.defined_page_hint);
            this.dismiss();
            return;
        }
        Map<String, ConfigBean.ClickBean> clickBeans = MonitorCache.getInstance().getClickBeans();
        if (null == clickBeans) {
            MLog.e(TAG, "loadClickData()-> clickBeans is null!");
            return;
        }
        String viewPathMd5 = MD5Utils.getMD5(viewPath);
        ConfigBean.ClickBean clickBean = clickBeans.get(viewPathMd5);
        if (null != clickBean) {
            this.mDefineEventView.showAlias(clickBean.getAlias());
        }
        this.mClickBean.setDefinedPage(definedPage);
        this.mClickBean.setPageClassName(pageClass);
        this.mClickBean.setViewPath(viewPath);
        this.mClickBean.setFindPath(findPath);
        this.mDefineEventView.showViewPath(viewPath);
        this.mDefineEventView.showReference(definedPage, null);
        this.requestEventData(viewPathMd5, "element", 7);
        this.mViewSnapshot = SnapshotUtil.takeSnapshot(view);
        this.mDefineEventView.showViewSnapshot(this.mViewSnapshot);
    }

    @Override
    public void loadListItemClickData(View view, String viewPath, String pageClass, String itemPath, String findPath, int listType) {
        if (null == viewPath) {
            MLog.e(TAG, "loadListItemClickData()-> viewPath is null!");
            return;
        }
        if (null == pageClass) {
            MLog.e(TAG, "loadListItemClickData()-> pageClass is null!");
            return;
        }
        if (null == itemPath) {
            MLog.e(TAG, "loadListItemClickData()-> itemPath is null!");
            return;
        }
        Map<String, ConfigBean.PvBean> pvMap = MonitorCache.getInstance().getPvBeans();
        if (null == pvMap) {
            MLog.e(TAG, "loadListItemClickData()-> pvMap is null!");
            return;
        }
        String definedPage = null;
        for (ConfigBean.PvBean pvBean : pvMap.values()) {
            if (null == pvBean) {
                MLog.e(TAG, "loadListItemClickData()-> pvBean is null!");
                continue;
            }
            if (null == pvBean.getViewPath()) {
                MLog.e(TAG, "loadListItemClickData()-> viewPath of pvBean is null!");
                continue;
            }
            if (!pageClass.equals(pvBean.getViewPath())) continue;
            definedPage = pvBean.getViewPath();
            break;
        }
        if (TextUtils.isEmpty(definedPage)) {
            MLog.e(TAG, "loadListItemClickData()-> no defined page!");
            this.mDefineEventView.showToast(R.string.defined_page_hint);
            this.dismiss();
            return;
        }
        Map<String, ConfigBean.ListBean> listBeans = MonitorCache.getInstance().getListBeans();
        if (null == listBeans) {
            MLog.e(TAG, "loadListItemClickData()-> listBeans is null!");
            return;
        }
        String itemMd5 = MD5Utils.getMD5(itemPath);
        String listMd5 = MD5Utils.getMD5(viewPath);
        ConfigBean.ListBean listBean = listBeans.get(MD5Utils.getMD5(viewPath));
        if (null != listBean) {
            Map<String, String> listAlias;
            Map<String, String> itemAliases = listBean.getItemAliases();
            if (null != itemAliases) {
                this.mDefineEventView.showAlias(itemAliases.get(itemMd5));
            }
            if (null != (listAlias = listBean.getListAlias())) {
                this.mDefineEventView.showListAlias(listAlias.get(listMd5));
            }
        }
        this.mListBean.setDefinedPage(definedPage);
        this.mListBean.setPageClassName(pageClass);
        this.mListBean.setViewPath(viewPath);
        this.mListBean.setFindPath(findPath);
        this.mListBean.setListType(listType);
        this.mDefineEventView.showSimilarViewPath(viewPath);
        this.mDefineEventView.showViewPath(itemPath);
        this.mDefineEventView.showReference(definedPage, null);
        this.requestEventData(itemMd5, "element", 7);
        Activity activity = SystemUtils.getCurrentActivity();
        if (null == activity) {
            MLog.e(TAG, "loadListItemClickData()-> fail to get top activity");
            return;
        }
        View decorView = activity.getWindow().getDecorView();
        this.mViewSnapshot = SnapshotUtil.takeSnapshot(decorView);
        this.mDefineEventView.showViewSnapshot(this.mViewSnapshot);
    }

    @Override
    public void saveClickEvent(String alias) {
        this.mClickBean.setAlias(alias);
        if (TextUtils.isEmpty((CharSequence)this.mClickBean.getViewPath())) {
            MLog.e(TAG, "saveClickEvent()-> viewPath is empty, save failed");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mClickBean.getDefinedPage())) {
            MLog.e(TAG, "saveClickEvent()-> defined page is empty, save failed");
            return;
        }
        String mClickPathMD5 = MD5Utils.getMD5(this.mClickBean.getViewPath());
        MonitorCache.getInstance().putClickBeans(mClickPathMD5, this.mClickBean);
        String pageClassNameMD5 = MD5Utils.getMD5(this.mClickBean.getPageClassName());
        MonitorCache.getInstance().putElemPvBeans(pageClassNameMD5, mClickPathMD5, this.mClickBean.getFindPath());
        TaskController.getInstance().submit(new WriteClickToSp());
        TaskController.getInstance().submit(new WriteElemPvToSp());
        TaskController.getInstance().submit(new SaveViewSnapshot(mClickPathMD5, this.mViewSnapshot));
        this.dismiss();
    }

    @Override
    public void saveListItemClickEvent(String alias, String itemPath, String listAlias, String listPath) {
        String itemPathMD5 = MD5Utils.getMD5(itemPath);
        String listPathMd5 = MD5Utils.getMD5(listPath);
        boolean isListExist = false;
        Map<String, ConfigBean.ListBean> listMap = MonitorCache.getInstance().getListBeans();
        if (null == listMap) {
            MLog.e(TAG, "saveListItemClickEvent()-> listMap is null");
            return;
        }
        for (ConfigBean.ListBean bean : listMap.values()) {
            if (!this.mListBean.getViewPath().equals(bean.getViewPath())) continue;
            isListExist = true;
            break;
        }
        if (isListExist) {
            ConfigBean.ListBean bean;
            String listBeanKey = MD5Utils.getMD5(this.mListBean.getViewPath());
            bean = listMap.get(listBeanKey);
            if (null == bean) {
                MLog.e(TAG, "saveListItemClickEvent()-> bean is null!");
                return;
            }
            Map<String, String> itemMap = bean.getItemAliases();
            if (null == itemMap) {
                itemMap = new HashMap<String, String>();
            }
            itemMap.put(itemPathMD5, alias);
            if (!TextUtils.isEmpty((CharSequence)listAlias)) {
                Map<String, String> listAliasMap = bean.getListAlias();
                if (null == listAliasMap) {
                    listAliasMap = new HashMap<String, String>();
                }
                listAliasMap.put(listPathMd5, listAlias);
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)this.mListBean.getDefinedPage())) {
                MLog.e(TAG, "saveListItemClickEvent()-> defined page is empty, save failed");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mListBean.getViewPath())) {
                MLog.e(TAG, "saveListItemClickEvent()-> viewPath is empty, save failed");
            }
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put(itemPathMD5, alias);
            this.mListBean.setItemAliases(itemMap);
            if (!TextUtils.isEmpty((CharSequence)listAlias)) {
                HashMap<String, String> listAliasMap = new HashMap<String, String>();
                listAliasMap.put(listPathMd5, listAlias);
                this.mListBean.setListAlias(listAliasMap);
            }
            String viewPathMD5 = MD5Utils.getMD5(this.mListBean.getViewPath());
            MonitorCache.getInstance().putListBeans(viewPathMD5, this.mListBean);
            String findPath = this.mListBean.getFindPath();
            String pageClassNameMD5 = MD5Utils.getMD5(this.mListBean.getPageClassName());
            switch (this.mListBean.getListType()) {
                case 1: {
                    MonitorCache.getInstance().putListPvBeans(pageClassNameMD5, viewPathMD5, findPath);
                    TaskController.getInstance().submit(new WriteListPvToSp());
                    break;
                }
                case 2: {
                    MonitorCache.getInstance().putRecyclerPvBeans(pageClassNameMD5, viewPathMD5, findPath);
                    TaskController.getInstance().submit(new WriteRecyclerPvToSp());
                    break;
                }
                case 3: {
                    MonitorCache.getInstance().putExpandablePvBeans(pageClassNameMD5, viewPathMD5, findPath);
                    TaskController.getInstance().submit(new WriteExpandablePvToSp());
                    break;
                }
            }
        }
        TaskController.getInstance().submit(new WriteListToSp());
        TaskController.getInstance().submit(new SaveViewSnapshot(itemPathMD5, this.mViewSnapshot));
        this.dismiss();
    }

    @Override
    public void savePageViewEvent(String alias, String definedPage) {
        this.mPvBean.setAlias(alias);
        this.mPvBean.setViewPath(definedPage);
        if (TextUtils.isEmpty((CharSequence)this.mPvBean.getViewPath())) {
            MLog.e(TAG, "savePageViewEvent()-> viewPath is empty, save failed");
            return;
        }
        String mPvMD5 = MD5Utils.getMD5(definedPage);
        MonitorCache.getInstance().putPvBeans(mPvMD5, this.mPvBean);
        TaskController.getInstance().submit(new WritePvToSp());
        TaskController.getInstance().submit(new SaveViewSnapshot(mPvMD5, this.mViewSnapshot));
        this.dismiss();
    }

    @Override
    public void dismiss() {
        this.mListBean = null;
        this.mClickBean = null;
        this.mPvBean = null;
        this.mViewSnapshot = null;
        FloatingViewManager.getInstance().dismissFloatingView(this.mDefineEventView.getViewType());
    }

    @Override
    public void init() {
    }

    private void requestEventData(String id2, String type, int counts) {
        EventDataRequest eventDataRequest = new EventDataRequest();
        eventDataRequest.setId(id2);
        eventDataRequest.setType(type);
        eventDataRequest.setCounts(counts);
        eventDataRequest.setTerminal("ANDROID");
        eventDataRequest.setUnit("d");
        this.pullEventData = new PullEventData(eventDataRequest, this);
        TaskController.getInstance().submit(this.pullEventData);
    }

    @Override
    public void updateUI(boolean isSuccess, String result) {
        if (isSuccess) {
            EventDataResponse eventDataResponse = GsonUtils.json2Bean(result, EventDataResponse.class);
            if (null == eventDataResponse) {
                MLog.e(TAG, "updateUI()-> eventDataResponse");
                return;
            }
            int status = eventDataResponse.getStatus();
            if (200 != status) {
                MLog.e(TAG, "updateUI()-> error,status=" + status);
                return;
            }
            EventDataResponse.Data[] datas = eventDataResponse.getData();
            if (null == datas && this.pullEventData != null) {
                TaskController.getInstance().scheduleDelay(this.pullEventData, 5000L);
                return;
            }
            if (datas.length == 0) {
                MLog.e(TAG, "updateUI()-> datas is null or empty");
                return;
            }
            int dateLength = datas.length;
            final long[] date = new long[dateLength];
            final long[] click = new long[dateLength];
            final long[] pv = new long[dateLength];
            for (int i = 0; i < dateLength; ++i) {
                date[i] = datas[i].getDate();
                click[i] = datas[i].getCount();
                pv[i] = datas[i].getPv();
            }
            TaskController.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefineEventPresenter.this.mDefineEventView.showLineChart(date, click, pv);
                    }
                    catch (Exception e) {
                        MLog.e(TAG, "mDefineEventView.showLineChart() -> Exception:" + e.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void showSnapShot() {
        FloatingViewManager.getInstance().showFloatingView(6);
        SnapshotView snapshotView = (SnapshotView)FloatingViewManager.getInstance().getFloatingView(6);
        if (null == snapshotView) {
            MLog.e(TAG, "showSnapshot()-> snapshotView is null");
            return;
        }
        snapshotView.loadImage(this.mViewSnapshot);
    }
}

