/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.event;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.changelistener.IEditPageOrElementNameCallback;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MD5Utils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.PageUtils;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.charts.LineChartContainer;
import com.chinapex.android.monitor.view.event.DefineEventContract;
import com.chinapex.android.monitor.view.event.DefineEventPresenter;
import com.chinapex.android.monitor.view.event.DefinePathView;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class DefineEventView
extends BaseFloatingView
implements DefineEventContract.View,
View.OnClickListener,
IEditPageOrElementNameCallback {
    private static final String TAG = DefineEventView.class.getSimpleName();
    private DefineEventContract.Presenter mPresenter;
    private LineChartContainer mLineChartContainer;
    private LinearLayout pageNameInfoLl;
    private TextView pageNameTv;
    private LinearLayout elementNameInfoLl;
    private TextView elementNameTv;
    private TextView elementPathTv;
    private LinearLayout pagePathInfoLl;
    private LinearLayout similarElementNameInfoLl;
    private TextView similarElementNameTv;
    private TextView similarElementPathTv;
    private TextView pagePathTv;
    private ImageView pathRightArrowIv;
    private List<String> mPages = new ArrayList<String>();
    private ImageView previewPageShootPicIv;
    private TextView previewPageShootPicTitleTv;
    private TextView titleTv;
    private ImageView zoomPageScreenshotIv;

    public DefineEventView(Context context, int windowType) {
        super(context, windowType);
        DefineEventView.inflate((Context)context, (int)R.layout.layout_window_define_page, (ViewGroup)this);
        this.setPresenter(new DefineEventPresenter(this));
        this.initView();
    }

    public void loadH5ClickData(String viewPath, String pageClass, String findPath) {
        this.mPresenter.loadH5ClickData(viewPath, pageClass, findPath);
    }

    public void loadClickData(View view, String viewPath, String pageClass, String findPath) {
        this.mPresenter.loadClickData(view, viewPath, pageClass, findPath);
    }

    public void loadListItemClickData(View view, String viewPath, String pageClass, String itemPath, String findPath, int listType) {
        this.mPresenter.loadListItemClickData(view, viewPath, pageClass, itemPath, findPath, listType);
    }

    @Override
    public void show() {
        super.show();
        IMonitorListenerController.getInstance().addEditPageorElementNameListener(this);
    }

    @Override
    public void dismiss() {
        IMonitorListenerController.getInstance().removeEditPageorElementNameListener(this);
        super.dismiss();
    }

    public void showPageAlias(String alias) {
        if (TextUtils.isEmpty((CharSequence)alias)) {
            MLog.w(TAG, "showPageAlias() -> alias is null or empty!");
            return;
        }
        this.pageNameTv.setText((CharSequence)alias);
    }

    @Override
    public void showAlias(String alias) {
        if (TextUtils.isEmpty((CharSequence)alias)) {
            MLog.w(TAG, "showAlias() -> alias is null or empty!");
            return;
        }
        this.elementNameTv.setText((CharSequence)alias);
    }

    @Override
    public void showListAlias(String listAlias) {
        if (TextUtils.isEmpty((CharSequence)listAlias)) {
            MLog.w(TAG, "showListAlias() -> listAlias is null or empty!");
            return;
        }
        this.similarElementNameTv.setText((CharSequence)listAlias);
    }

    public void setDefinePage(String definePage) {
        if (null == definePage) {
            return;
        }
        if (this.getViewType() == 1) {
            Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
            if (null == pvBeans) {
                MLog.e(TAG, "Spinner onItemSelected() -> pvBeans is null!");
                return;
            }
            this.pageNameTv.setText((CharSequence)"");
            ConfigBean.PvBean pvBean = pvBeans.get(MD5Utils.getMD5(definePage));
            if (null != pvBean) {
                this.showPageAlias(pvBean.getAlias());
            }
            this.mPresenter.updatePvData(definePage);
        }
        this.pagePathTv.setTag((Object)definePage);
        this.pagePathTv.setText((CharSequence)PageUtils.getPagePathName(definePage));
    }

    @Override
    public void showViewPath(String path) {
        if (null == path) {
            MLog.e(TAG, "showViewPath()-> elementPathTv is null");
            return;
        }
        this.elementPathTv.setText((CharSequence)("\u8def\u5f84: " + path));
        this.elementPathTv.setTag((Object)path);
    }

    @Override
    public void showSimilarViewPath(String path) {
        if (null == path) {
            MLog.e(TAG, "showSimilarViewPath()-> similarElementPathTv is null");
            return;
        }
        this.similarElementPathTv.setText((CharSequence)("\u8def\u5f84: " + path));
        this.similarElementPathTv.setTag((Object)path);
    }

    public void loadImage(Bitmap bitmap) {
        Glide.with((View)this).clear((View)this.previewPageShootPicIv);
        ((RequestBuilder)Glide.with((View)this).load(bitmap).centerInside()).into(this.previewPageShootPicIv);
    }

    @Override
    public void showViewSnapshot(Bitmap bitmap) {
        this.loadImage(bitmap);
        this.previewPageShootPicIv.setOnClickListener((View.OnClickListener)this);
        this.zoomPageScreenshotIv.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void loadPagePath(List<String> pages) {
        this.mPages.clear();
        this.mPages.addAll(pages);
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        if (null == pvBeans) {
            MLog.e(TAG, "loadPagePath() ->  is null!");
            return;
        }
        String pagePath = pages.get(0);
        this.pagePathTv.setText((CharSequence)PageUtils.getPagePathName(pagePath));
        this.pagePathTv.setTag((Object)pagePath);
        ConfigBean.PvBean pvBean = pvBeans.get(MD5Utils.getMD5(pagePath));
        if (null != pvBean && !TextUtils.isEmpty((CharSequence)pvBean.getAlias())) {
            this.pageNameTv.setText((CharSequence)pvBean.getAlias());
        }
        this.mPresenter.updatePvData(pagePath);
    }

    @Override
    public void showReference(String reference, List<String> pages) {
        if (null == reference) {
            MLog.e(TAG, "showPagePath()-> reference is null");
            return;
        }
        if (pages != null) {
            this.mPages.clear();
            this.mPages.addAll(pages);
        }
        String pagePath = reference;
        this.pagePathTv.setText((CharSequence)PageUtils.getPagePathName(pagePath));
        this.pagePathTv.setTag((Object)pagePath);
    }

    @Override
    public void showLineChart(long[] dateArray, long[] clickCountArray, long[] pvCountArray) {
        if (null == this.mLineChartContainer) {
            MLog.e(TAG, "showLineChart()-> mLineChart is null");
            return;
        }
        this.mLineChartContainer.setVisibility(0);
        this.mLineChartContainer.setData(dateArray, clickCountArray, pvCountArray);
    }

    public void onClick(View v) {
        try {
            int viewId = v.getId();
            if (viewId == R.id.layout_window_define_page_save_tv) {
                this.save();
            } else if (viewId == R.id.btn_cancel_define_event) {
                this.mPresenter.dismiss();
            } else if (viewId == R.id.layout_window_define_page_zoom_pagescreenshot_pic_iv) {
                this.mPresenter.showSnapShot();
            } else if (viewId == R.id.layout_window_define_page_preview_pagescreenshot_pic_iv) {
                this.mPresenter.showSnapShot();
            } else if (viewId == R.id.layout_window_define_page_pagename_tv) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("pageName", this.pageNameTv.getText().toString());
                this.mPresenter.inputPageOrEelementName(jsonObject.toString());
            } else if (viewId == R.id.layout_window_define_page_element_name_tv) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("elementName", this.elementNameTv.getText().toString());
                this.mPresenter.inputPageOrEelementName(jsonObject.toString());
            } else if (viewId == R.id.layout_window_define_page_similar_element_name_tv) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("similarElementName", this.similarElementNameTv.getText().toString());
                this.mPresenter.inputPageOrEelementName(jsonObject.toString());
            } else if (viewId == R.id.layout_window_define_page_pagepath_info_ll && this.getWindowType() == 1) {
                FloatingViewManager.getInstance().showFloatingView(11);
                DefinePathView definePathView = (DefinePathView)FloatingViewManager.getInstance().getFloatingView(11);
                if (null == definePathView) {
                    MLog.e(TAG, "definePathView is null");
                    return;
                }
                definePathView.initPathView(this.mPages, this.getViewType());
            }
        }
        catch (Exception e) {
            MLog.e(TAG, "onClick() -> Exception:" + e.getMessage());
        }
    }

    public void setPresenter(Object presenter) {
        this.mPresenter = (DefineEventContract.Presenter)presenter;
    }

    @Override
    public int getViewType() {
        return this.getWindowType();
    }

    @Override
    public void showToast(int id2) {
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getResources().getText(id2).toString(), (int)1).show();
    }

    private void initView() {
        this.mLineChartContainer = (LineChartContainer)this.findViewById(R.id.line_chart_container);
        this.zoomPageScreenshotIv = (ImageView)this.findViewById(R.id.layout_window_define_page_zoom_pagescreenshot_pic_iv);
        this.previewPageShootPicTitleTv = (TextView)this.findViewById(R.id.layout_window_define_page_preview_pagescreenshot_title_tv);
        this.pagePathInfoLl = (LinearLayout)this.findViewById(R.id.layout_window_define_page_pagepath_info_ll);
        this.titleTv = (TextView)this.findViewById(R.id.layout_window_define_page_title_tv);
        this.findViewById(R.id.layout_window_define_page_save_tv).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_cancel_define_event).setOnClickListener((View.OnClickListener)this);
        this.pathRightArrowIv = (ImageView)this.findViewById(R.id.layout_window_define_page_path_right_arrow_iv);
        this.pagePathTv = (TextView)this.findViewById(R.id.layout_window_define_page_pagepath_tv);
        this.pageNameInfoLl = (LinearLayout)this.findViewById(R.id.layout_window_define_page_pagename_info_ll);
        this.pageNameTv = (TextView)this.findViewById(R.id.layout_window_define_page_pagename_tv);
        this.pageNameTv.setOnClickListener((View.OnClickListener)this);
        this.elementNameInfoLl = (LinearLayout)this.findViewById(R.id.layout_window_define_page_element_name_info_ll);
        this.elementNameTv = (TextView)this.findViewById(R.id.layout_window_define_page_element_name_tv);
        this.elementPathTv = (TextView)this.findViewById(R.id.layout_window_define_page_element_path_tv);
        this.elementNameTv.setOnClickListener((View.OnClickListener)this);
        this.similarElementNameInfoLl = (LinearLayout)this.findViewById(R.id.layout_window_define_page_similar_element_name_info_ll);
        this.similarElementNameTv = (TextView)this.findViewById(R.id.layout_window_define_page_similar_element_name_tv);
        this.similarElementPathTv = (TextView)this.findViewById(R.id.layout_window_define_page_similar_element_path_tv);
        this.similarElementNameTv.setOnClickListener((View.OnClickListener)this);
        this.previewPageShootPicIv = (ImageView)this.findViewById(R.id.layout_window_define_page_preview_pagescreenshot_pic_iv);
        this.elementPathTv.setMovementMethod(ScrollingMovementMethod.getInstance());
        switch (this.getWindowType()) {
            case 2: {
                this.showElementView();
                break;
            }
            case 1: {
                this.pathRightArrowIv.setVisibility(0);
                this.pagePathInfoLl.setOnClickListener((View.OnClickListener)this);
                this.showPageView();
                this.loadPvData();
                break;
            }
            case 3: {
                this.showListElementView();
                break;
            }
            default: {
                this.pathRightArrowIv.setVisibility(0);
                MLog.e(TAG, "initView()-> no this view type, show pv define page");
                this.pagePathInfoLl.setOnClickListener((View.OnClickListener)this);
                this.showPageView();
                this.loadPvData();
            }
        }
    }

    private void showPageView() {
        this.titleTv.setText(this.getResources().getText(R.string.define_page));
        this.pageNameInfoLl.setVisibility(0);
        this.elementNameInfoLl.setVisibility(8);
        this.similarElementNameInfoLl.setVisibility(8);
        this.previewPageShootPicTitleTv.setText(this.getResources().getText(R.string.page_preview));
    }

    private void showListElementView() {
        this.titleTv.setText(this.getResources().getText(R.string.circle_element));
        this.pageNameInfoLl.setVisibility(8);
        this.elementNameInfoLl.setVisibility(0);
        this.similarElementNameInfoLl.setVisibility(0);
        this.previewPageShootPicTitleTv.setText(this.getResources().getText(R.string.element_preview));
    }

    private void showElementView() {
        this.titleTv.setText(this.getResources().getText(R.string.circle_element));
        this.pageNameInfoLl.setVisibility(8);
        this.elementNameInfoLl.setVisibility(0);
        this.similarElementNameInfoLl.setVisibility(8);
        this.previewPageShootPicTitleTv.setText(this.getResources().getText(R.string.element_preview));
    }

    private void save() {
        String alias = this.elementNameTv.getText().toString();
        String name = this.pageNameTv.getText().toString();
        if (TextUtils.isEmpty((CharSequence)alias) && this.getViewType() != 1) {
            MLog.e(TAG, "alias is empty");
            this.showToast(R.string.alias_leak_hint);
            return;
        }
        switch (this.getViewType()) {
            case 2: {
                this.mPresenter.saveClickEvent(alias);
                break;
            }
            case 3: {
                String itemPath = this.elementPathTv.getTag().toString();
                String listAlias = this.similarElementNameTv.getText().toString();
                String listPath = this.similarElementPathTv.getTag().toString();
                if (TextUtils.isEmpty((CharSequence)itemPath)) {
                    MLog.e(TAG, "itemPath is empty");
                    this.showToast(R.string.select_path_hint);
                    return;
                }
                this.mPresenter.saveListItemClickEvent(alias, itemPath, listAlias, listPath);
                break;
            }
            case 1: {
                String definedPage = (String)this.pagePathTv.getTag();
                if (TextUtils.isEmpty((CharSequence)definedPage) || TextUtils.isEmpty((CharSequence)name)) {
                    MLog.e(TAG, "defined page is empty");
                    this.showToast(R.string.name_leak_hint);
                    return;
                }
                this.mPresenter.savePageViewEvent(name, definedPage);
                break;
            }
            default: {
                MLog.e(TAG, "save event:no this view type");
            }
        }
    }

    private void loadPvData() {
        this.mPresenter.loadPvData();
    }

    @Override
    public void nameChange(String nameJson) {
        try {
            JSONObject jsonObject = new JSONObject(nameJson);
            if (jsonObject.has("similarElementName")) {
                this.similarElementNameTv.setText((CharSequence)jsonObject.getString("similarElementName"));
            }
            if (jsonObject.has("elementName")) {
                this.elementNameTv.setText((CharSequence)jsonObject.getString("elementName"));
            }
            if (jsonObject.has("pageName")) {
                this.pageNameTv.setText((CharSequence)jsonObject.getString("pageName"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

