/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.event;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.SystemUtils;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.google.gson.JsonObject;
import org.json.JSONObject;

public class InputPageOrElementNameView
extends BaseFloatingView {
    private static final String TAG = InputPageOrElementNameView.class.getSimpleName();
    private TextView titleTv;
    private TextView sureTv;
    private LinearLayout pageNameInfoLl;
    private EditText pageNameEt;
    private TextView pageNameCountTv;
    private int mType;
    private LinearLayout elementNameInfoLl;
    private EditText elementNameEt;
    private TextView elementNameCountTv;
    private View.OnClickListener sureListener = new View.OnClickListener(){

        public void onClick(View v) {
            JsonObject jsonObject = new JsonObject();
            switch (InputPageOrElementNameView.this.mType) {
                case 1: {
                    String name = InputPageOrElementNameView.this.pageNameEt.getText().toString();
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        Toast.makeText((Context)InputPageOrElementNameView.this.getContext(), (CharSequence)InputPageOrElementNameView.this.getResources().getText(R.string.please_input_page_name).toString(), (int)1).show();
                        return;
                    }
                    jsonObject.addProperty("pageName", InputPageOrElementNameView.this.pageNameEt.getText().toString());
                    break;
                }
                case 2: {
                    String name = InputPageOrElementNameView.this.elementNameEt.getText().toString();
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        Toast.makeText((Context)InputPageOrElementNameView.this.getContext(), (CharSequence)InputPageOrElementNameView.this.getResources().getText(R.string.alias_leak_hint).toString(), (int)1).show();
                        return;
                    }
                    jsonObject.addProperty("elementName", InputPageOrElementNameView.this.elementNameEt.getText().toString());
                    break;
                }
                case 3: {
                    String name = InputPageOrElementNameView.this.elementNameEt.getText().toString();
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        Toast.makeText((Context)InputPageOrElementNameView.this.getContext(), (CharSequence)InputPageOrElementNameView.this.getResources().getText(R.string.alias_leak_hint).toString(), (int)1).show();
                        return;
                    }
                    jsonObject.addProperty("similarElementName", InputPageOrElementNameView.this.elementNameEt.getText().toString());
                }
            }
            IMonitorListenerController.getInstance().notifyPageOrElementNameChange(jsonObject.toString());
            InputPageOrElementNameView.this.hideInput();
            InputPageOrElementNameView.this.dismiss();
        }
    };
    private TextWatcher nameCountTextWatcherListener = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            String str = s.toString();
            int length = str.length();
            StringBuffer html = new StringBuffer("<font color='#FF0000'>");
            html.append(length + "</font>").append("/20");
            switch (InputPageOrElementNameView.this.mType) {
                case 1: {
                    InputPageOrElementNameView.this.pageNameCountTv.setText((CharSequence)Html.fromHtml((String)html.toString()));
                    break;
                }
                default: {
                    InputPageOrElementNameView.this.elementNameCountTv.setText((CharSequence)Html.fromHtml((String)html.toString()));
                }
            }
        }
    };

    public InputPageOrElementNameView(@NonNull Context context, int windowType) {
        super(context, windowType);
        InputPageOrElementNameView.inflate((Context)context, (int)R.layout.layout_window_define_page_input_page_or_element_name, (ViewGroup)this);
        this.initView();
        this.addListeners();
    }

    private void hideInput() {
        Activity activity = SystemUtils.getCurrentActivity();
        if (null == activity) {
            MLog.e(TAG, "hideInput-> fail to get top activity");
            return;
        }
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        View v = activity.getWindow().peekDecorView();
        if (null != v) {
            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
        }
    }

    public void initData(String nameJson) {
        this.mType = 0;
        StringBuffer html = new StringBuffer("<font color='#FF0000'>");
        try {
            JSONObject jsonObject = new JSONObject(nameJson);
            if (jsonObject.has("similarElementName")) {
                this.mType = 3;
                this.elementNameEt.setText((CharSequence)jsonObject.getString("similarElementName"));
                html.append(this.elementNameEt.getText().toString().length() + "</font>").append("/20");
                this.showElementNameView(html.toString());
            }
            if (jsonObject.has("elementName")) {
                this.mType = 2;
                this.elementNameEt.setText((CharSequence)jsonObject.getString("elementName"));
                html.append(this.elementNameEt.getText().toString().length() + "</font>").append("/20");
                this.showElementNameView(html.toString());
            }
            if (jsonObject.has("pageName")) {
                this.mType = 1;
                this.pageNameEt.setText((CharSequence)jsonObject.getString("pageName"));
                html.append(this.pageNameEt.getText().toString().length() + "</font>").append("/20");
                this.showPageNameView(html.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addListeners() {
        this.pageNameEt.addTextChangedListener(this.nameCountTextWatcherListener);
        this.elementNameEt.addTextChangedListener(this.nameCountTextWatcherListener);
        this.sureTv.setOnClickListener(this.sureListener);
    }

    private void showPageNameView(String html) {
        this.pageNameInfoLl.setVisibility(0);
        this.elementNameInfoLl.setVisibility(8);
        this.titleTv.setText((CharSequence)"\u9875\u9762\u540d\u79f0");
        this.pageNameCountTv.setText((CharSequence)Html.fromHtml((String)html));
    }

    private void showElementNameView(String html) {
        this.pageNameInfoLl.setVisibility(8);
        this.elementNameInfoLl.setVisibility(0);
        this.titleTv.setText((CharSequence)"\u5143\u7d20\u540d\u79f0");
        this.elementNameCountTv.setText((CharSequence)Html.fromHtml((String)html));
    }

    private void initView() {
        this.titleTv = (TextView)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_title_tv);
        this.sureTv = (TextView)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_sure_tv);
        this.pageNameEt = (EditText)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_pagename_ev);
        this.pageNameInfoLl = (LinearLayout)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_pagename_info_ll);
        this.pageNameCountTv = (TextView)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_pagename_count_tv);
        this.elementNameEt = (EditText)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_elementname_ev);
        this.elementNameInfoLl = (LinearLayout)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_elementname_info_ll);
        this.elementNameCountTv = (TextView)this.findViewById(R.id.layout_window_define_page_input_page_or_element_name_elementame_count_tv);
    }
}

