/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.loading;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.FloatingViewManager;

public class LoadingView
extends BaseFloatingView
implements View.OnClickListener {
    private static final String TAG = LoadingView.class.getSimpleName();
    private ProgressBar mPbLoading;
    private ImageView mIvLoadingPicture;
    private TextView mTvLoadingContent;
    private Button mBtLoadingContent;

    public LoadingView(@NonNull Context context, int windowType) {
        super(context, windowType);
        LoadingView.inflate((Context)context, (int)R.layout.layout_window_loading, (ViewGroup)this);
        this.initView();
    }

    private void initView() {
        this.mPbLoading = (ProgressBar)this.findViewById(R.id.pb_loading);
        this.mIvLoadingPicture = (ImageView)this.findViewById(R.id.iv_loading_picture);
        this.mTvLoadingContent = (TextView)this.findViewById(R.id.tv_loading_content);
        this.mBtLoadingContent = (Button)this.findViewById(R.id.bt_loading_content);
        this.mBtLoadingContent.setOnClickListener((View.OnClickListener)this);
    }

    public void setLoading(String content) {
        this.mPbLoading.setVisibility(0);
        this.mIvLoadingPicture.setVisibility(4);
        this.mTvLoadingContent.setText((CharSequence)content);
        this.mBtLoadingContent.setText((CharSequence)"\u53d6\u6d88");
        this.mBtLoadingContent.setBackgroundResource(R.drawable.bg_loading);
    }

    public void setLoadingOk(String content) {
        this.mPbLoading.setVisibility(8);
        this.mIvLoadingPicture.setVisibility(0);
        this.mIvLoadingPicture.setImageResource(R.drawable.upload_ok_48);
        this.mTvLoadingContent.setText((CharSequence)content);
        this.mBtLoadingContent.setText((CharSequence)"\u786e\u8ba4");
        this.mBtLoadingContent.setBackgroundResource(R.drawable.bg_loading_ok);
    }

    public void setLoadingFail(String content) {
        this.mPbLoading.setVisibility(8);
        this.mIvLoadingPicture.setVisibility(0);
        this.mIvLoadingPicture.setImageResource(R.drawable.upload_fail_48);
        this.mTvLoadingContent.setText((CharSequence)content);
        this.mBtLoadingContent.setText((CharSequence)"\u53d6\u6d88");
        this.mBtLoadingContent.setBackgroundResource(R.drawable.bg_loading_fail);
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (R.id.bt_loading_content == viewId) {
            FloatingViewManager.getInstance().dismissFloatingView(8);
        }
    }
}

