/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.menu;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Switch;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ContrastItem;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.changelistener.OnComparisonElementsChangeListener;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.DensityUtil;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.menu.FloatingWindowContract;
import com.chinapex.android.monitor.view.menu.FloatingWindowPresenter;
import java.util.Set;

public class FloatingWindow
extends BaseFloatingView
implements FloatingWindowContract.View,
View.OnClickListener,
CompoundButton.OnCheckedChangeListener,
OnComparisonElementsChangeListener {
    private static final String TAG = FloatingWindow.class.getSimpleName();
    private FloatingWindowContract.Presenter mPresenter;
    private RelativeLayout mPointRl;
    private ViewGroup mMonitorMenu;
    private Switch switchMonitor;
    private Switch switchHeatMap;
    private LinearLayout heatMapChartsLl;
    private int mTouchSlop;
    private float downX;
    private float downY;
    private float lastX;
    private float lastY;
    DisplayMetrics dm;

    public FloatingWindow(Context context, int windowType) {
        super(context, windowType);
        FloatingWindow.inflate((Context)context, (int)R.layout.layout_window_floating, (ViewGroup)this);
        this.init();
        this.mTouchSlop = DensityUtil.getTouchSlop(context);
    }

    private void init() {
        this.dm = new DisplayMetrics();
        this.dm = this.getResources().getDisplayMetrics();
        int width = this.dm.widthPixels;
        this.setLayoutParams(width - 10, 10, 0x800033);
        this.setPresenter(new FloatingWindowPresenter(this));
        this.heatMapChartsLl = (LinearLayout)this.findViewById(R.id.heat_map_charts_ll);
        this.heatMapChartsLl.setOnClickListener((View.OnClickListener)this);
        this.mPointRl = (RelativeLayout)this.findViewById(R.id.iv_point_rl);
        this.mPointRl.setOnClickListener((View.OnClickListener)this);
        this.mMonitorMenu = (RelativeLayout)this.findViewById(R.id.monitor_menu);
        this.switchMonitor = (Switch)this.findViewById(R.id.switch_monitor);
        this.switchMonitor.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.switchHeatMap = (Switch)this.findViewById(R.id.switch_heat_map);
        this.switchHeatMap.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.findViewById(R.id.define_page_rl).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.upload_circle_event_rl).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.close_menu_icon_iv).setOnClickListener((View.OnClickListener)this);
        IMonitorListenerController.getInstance().addOnComparisonElementsChangeListener(this);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercepted = false;
        switch (ev.getAction()) {
            case 0: {
                intercepted = false;
                this.downX = ev.getRawX();
                this.downY = ev.getRawY();
                this.lastX = this.downX;
                this.lastY = this.downY;
                break;
            }
            case 2: {
                float moveX = ev.getRawX();
                float moveY = ev.getRawY();
                if (!(Math.abs(moveX - this.downX) > (float)this.mTouchSlop) && !(Math.abs(moveY - this.downY) > (float)this.mTouchSlop)) break;
                intercepted = true;
                break;
            }
            case 1: {
                break;
            }
        }
        return intercepted;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.downX = event.getRawX();
                this.downY = event.getRawY();
                this.lastX = this.downX;
                this.lastY = this.downY;
                break;
            }
            case 2: {
                this.getWindowParams().x = (int)((float)this.getWindowParams().x + (event.getRawX() - this.lastX));
                this.getWindowParams().y = (int)((float)this.getWindowParams().y + (event.getRawY() - this.lastY));
                this.updateLayout();
                this.lastX = event.getRawX();
                this.lastY = event.getRawY();
                break;
            }
            case 1: {
                break;
            }
        }
        return true;
    }

    private WindowManager.LayoutParams setLayoutParams(int x, int y, int gravity) {
        WindowManager.LayoutParams params = this.getWindowParams();
        params.width = -2;
        params.height = -2;
        params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
        params.flags = 8;
        params.format = -3;
        params.gravity = gravity;
        params.x = x;
        params.y = y;
        return params;
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.iv_point_rl) {
            this.transformMenu();
        } else if (viewId == R.id.define_page_rl) {
            this.mPresenter.openDefinePage();
        } else if (viewId == R.id.close_menu_icon_iv) {
            this.mPresenter.close();
        } else if (viewId == R.id.heat_map_charts_ll) {
            this.mPresenter.openContrastDataPage();
        } else if (viewId == R.id.upload_circle_event_rl) {
            this.mPresenter.openUploadEventPage();
        } else {
            MLog.e(TAG, "unknown view is clicked!");
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int i = buttonView.getId();
        if (i == R.id.switch_monitor) {
            this.mPresenter.switchMonitorMode(isChecked);
        } else if (i == R.id.switch_heat_map) {
            this.mPresenter.switchContrastMode(isChecked);
        } else {
            MLog.e(TAG, "unknown switch!");
        }
    }

    @Override
    public void transformMenu() {
        if (this.mPointRl.getVisibility() == 8) {
            this.mPointRl.setVisibility(0);
            this.mMonitorMenu.setVisibility(8);
            int width = this.dm.widthPixels;
            this.setLayoutParams(width - 10, 10, 0x800033);
            this.updateLayout();
        } else if (this.mPointRl.getVisibility() == 0) {
            this.mPointRl.setVisibility(8);
            this.mMonitorMenu.setVisibility(0);
            int width = this.dm.widthPixels;
            int height = this.dm.heightPixels;
            this.setLayoutParams(0, 0, 17);
            this.updateLayout();
        } else {
            MLog.e(TAG, "transformMenu()-> invalid visivility state for floating point");
        }
    }

    @Override
    public void closeMonitorModeIfOpened() {
        if (this.switchMonitor.isChecked()) {
            this.switchMonitor.setChecked(false);
        }
    }

    @Override
    public void closeContrastModeIfOpened() {
        if (this.switchHeatMap.isChecked()) {
            this.switchHeatMap.setChecked(false);
        }
    }

    @Override
    public void showChartOption(boolean shouldShow) {
        if (shouldShow) {
            this.heatMapChartsLl.setVisibility(0);
        } else {
            this.heatMapChartsLl.setVisibility(8);
        }
    }

    @Override
    public void comparisonElementsChange() {
        Set<ContrastItem> contrastItems = MonitorCache.getInstance().getContrastItemList();
    }

    @Override
    public void setLabel(int count) {
    }

    public void setPresenter(Object presenter) {
        this.mPresenter = (FloatingWindowContract.Presenter)presenter;
    }
}

