/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.snapshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.utils.DensityUtil;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.FloatingViewManager;

public class SnapshotView
extends BaseFloatingView {
    private ImageView ivSnapshot;
    private ImageView closeSnapshotIv;

    public SnapshotView(@NonNull Context context, int windowType) {
        super(context, windowType);
        SnapshotView.inflate((Context)context, (int)R.layout.layout_window_snapshot, (ViewGroup)this);
        this.setBackgroundColor(context.getResources().getColor(R.color.c_99000000));
        this.resetLayoutParams();
        this.ivSnapshot = (ImageView)this.findViewById(R.id.iv_snapshot);
        this.closeSnapshotIv = (ImageView)this.findViewById(R.id.close_snapsshort_iv);
        int screenWidth = DensityUtil.getScreenWidth(context);
        int screenHeight = DensityUtil.getScreenHeight(context);
        this.ivSnapshot.setMaxWidth(screenWidth * 2 / 3);
        this.ivSnapshot.setMaxHeight(screenHeight * 2 / 3);
        this.closeSnapshotIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SnapshotView.this.dismiss();
                FloatingViewManager.getInstance().dismissFloatingView(6);
            }
        });
    }

    public void loadImage(Bitmap bitmap) {
        Glide.with((View)this).clear((View)this.ivSnapshot);
        this.resetLayoutParams();
        ((RequestBuilder)Glide.with((View)this).load(bitmap).centerInside()).into(this.ivSnapshot);
    }

    public void loadImage(String path) {
        Glide.with((View)this).clear((View)this.ivSnapshot);
        ((RequestBuilder)Glide.with((View)this).load(path).centerInside()).into(this.ivSnapshot);
    }

    private WindowManager.LayoutParams resetLayoutParams() {
        WindowManager.LayoutParams params = this.getWindowParams();
        params.width = -1;
        params.height = -1;
        params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
        params.flags = 1024;
        params.format = -3;
        return params;
    }
}

