/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.statistics;

import android.content.Context;
import android.content.res.Configuration;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.StatisticsBean;
import com.chinapex.android.monitor.changelistener.IDeleteStatisticsCallback;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.adapter.ColumnListAdapter;
import com.chinapex.android.monitor.view.adapter.StatisticsListAdapter;
import com.chinapex.android.monitor.view.charts.PieChart;
import com.chinapex.android.monitor.view.charts.PieForm;
import com.chinapex.android.monitor.view.statistics.StatisticsViewContract;
import com.chinapex.android.monitor.view.statistics.StatisticsViewPresenter;
import java.util.ArrayList;
import java.util.List;

public class StatisticsView
extends BaseFloatingView
implements StatisticsViewContract.View,
View.OnClickListener,
StatisticsListAdapter.OnItemClickListener,
IDeleteStatisticsCallback {
    private static final String TAG = StatisticsView.class.getSimpleName();
    private StatisticsViewContract.Presenter mPresenter;
    private PieChart mPieChart;
    private PieForm mPieForm;
    private ScrollView mChartContainer;
    private LinearLayout mListContainer;
    private ExpandableListView mStatisticsListView;
    private ListView mColumnListView;
    private StatisticsListAdapter mListAdapter;
    private ColumnListAdapter mColumnListAdapter;
    public List<StatisticsBean> mStatisticsBeans;
    private RelativeLayout compareAnalyseListRl;
    private ImageView compareAnalyseListIconIv;
    private TextView compareAnalyseListTitleTv;
    private TextView allSelectTv;
    private TextView deleteTv;
    private TextView cancelSelectStatisticsTv;
    private RelativeLayout contrastDataBottomRl;
    private RelativeLayout compareAnalyseChartRl;
    private ImageView compareAnalyseChartIconIv;
    private TextView compareAnalyseChartTitleTv;
    private Context mContext;

    public StatisticsView(@NonNull Context context, int windowType) {
        super(context, windowType);
        this.mContext = context;
        StatisticsView.inflate((Context)context, (int)R.layout.layout_window_contrast_data, (ViewGroup)this);
        this.setPresenter(new StatisticsViewPresenter(this));
        this.initView();
        IMonitorListenerController.getInstance().addDeleteStatisticsListener(this);
    }

    private void initCompareAnalyseListView() {
        this.compareAnalyseListRl = (RelativeLayout)this.findViewById(R.id.compare_analyse_list_rl);
        this.compareAnalyseListIconIv = (ImageView)this.findViewById(R.id.compare_analyse_list_icon_iv);
        this.compareAnalyseListTitleTv = (TextView)this.findViewById(R.id.compare_analyse_list_title_tv);
        this.allSelectTv = (TextView)this.findViewById(R.id.statistics_list_all_select_tv);
        this.deleteTv = (TextView)this.findViewById(R.id.statistics_list_delete_tv);
        this.cancelSelectStatisticsTv = (TextView)this.findViewById(R.id.statistics_list_cancel_tv);
        this.cancelSelectStatisticsTv.setOnClickListener((View.OnClickListener)this);
        this.compareAnalyseListRl.setOnClickListener((View.OnClickListener)this);
        this.contrastDataBottomRl = (RelativeLayout)this.findViewById(R.id.contrast_data_bottom_rl);
        this.allSelectTv.setOnClickListener((View.OnClickListener)this);
        this.deleteTv.setOnClickListener((View.OnClickListener)this);
    }

    private void initCompareAnaylseChartView() {
        this.compareAnalyseChartRl = (RelativeLayout)this.findViewById(R.id.compare_analyse_chart_rl);
        this.compareAnalyseChartIconIv = (ImageView)this.findViewById(R.id.compare_analyse_chart_icon_iv);
        this.compareAnalyseChartTitleTv = (TextView)this.findViewById(R.id.compare_analyse_chart_title_tv);
        this.compareAnalyseChartRl.setOnClickListener((View.OnClickListener)this);
    }

    private void initView() {
        this.mPieChart = (PieChart)this.findViewById(R.id.pie_chart);
        this.mPieForm = (PieForm)this.findViewById(R.id.pie_form);
        this.mColumnListView = (ListView)this.findViewById(R.id.lv_count_rank);
        this.mStatisticsListView = (ExpandableListView)this.findViewById(R.id.statistics_list);
        this.mListContainer = (LinearLayout)this.findViewById(R.id.statistics_list_container);
        this.mChartContainer = (ScrollView)this.findViewById(R.id.statistics_chart_container);
        this.initCompareAnalyseListView();
        this.initCompareAnaylseChartView();
        this.mStatisticsBeans = new ArrayList<StatisticsBean>();
        this.mStatisticsBeans.addAll(MonitorCache.getInstance().getStatisticsBeans());
        this.mListAdapter = new StatisticsListAdapter(this.mStatisticsBeans);
        this.mStatisticsListView.setAdapter((ExpandableListAdapter)this.mListAdapter);
        this.mListAdapter.setOnItemClickListener(this);
        this.mStatisticsListView.setOnGroupExpandListener(new ExpandableListView.OnGroupExpandListener(){

            public void onGroupExpand(int groupPosition) {
                int count = StatisticsView.this.mListAdapter.getGroupCount();
                for (int i = 0; i < count; ++i) {
                    if (i == groupPosition) continue;
                    StatisticsView.this.mStatisticsListView.collapseGroup(i);
                }
            }
        });
        this.mColumnListAdapter = new ColumnListAdapter(this.mStatisticsBeans);
        this.mColumnListView.setAdapter((ListAdapter)this.mColumnListAdapter);
        this.mColumnListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                StatisticsView.this.mPieChart.popChosenPie(i);
                StatisticsView.this.mPieForm.setEventColor(MonitorCache.getInstance().getStatisticsBeans().get(i).getColor());
                StatisticsView.this.mPieForm.setTvClickCount(MonitorCache.getInstance().getStatisticsBeans().get(i).getClickCount());
                StatisticsView.this.mPieForm.setTvClickPercent(MonitorCache.getInstance().getStatisticsBeans().get(i).getClickProportion());
                String eventLabel = MonitorCache.getInstance().getStatisticsBeans().get(i).getEventLabel();
                StatisticsView.this.mPieForm.setTvEventName(TextUtils.isEmpty((CharSequence)eventLabel) ? MonitorCache.getInstance().getStatisticsBeans().get(i).getViewPathMD5() : eventLabel);
            }
        });
        this.mChartContainer.setVisibility(8);
        this.mListContainer.setVisibility(0);
        this.loadData();
    }

    private void loadData() {
        this.mPresenter.loadContrastData();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.orientation == 2 && null != this.mChartContainer && this.mChartContainer.getVisibility() == 0) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    StatisticsView.this.mChartContainer.smoothScrollTo(0, 0);
                }
            }, 200L);
        }
        super.onConfigurationChanged(newConfig);
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.statistics_list_all_select_tv) {
            this.mListAdapter.selectAllStatistics();
        } else if (viewId == R.id.statistics_list_cancel_tv) {
            this.mListAdapter.cancelSelectStatistics();
        } else if (viewId == R.id.statistics_list_delete_tv) {
            FloatingViewManager.getInstance().showFloatingView(10);
        } else if (viewId == R.id.compare_analyse_chart_rl) {
            if (this.mChartContainer.getVisibility() == 0 && this.mListContainer.getVisibility() == 8) {
                MLog.i(TAG, "onClick() -> statistics chart is already showing  !!!");
                return;
            }
            this.mChartContainer.smoothScrollTo(0, 0);
            this.compareAnalyseChartTitleTv.setTextColor(this.getResources().getColor(R.color.c_4C8EFA));
            this.compareAnalyseChartIconIv.setImageResource(R.drawable.compare_analyse_chart_tab_selected);
            this.compareAnalyseListTitleTv.setTextColor(this.getResources().getColor(R.color.c_666666));
            this.compareAnalyseListIconIv.setImageResource(R.drawable.compare_analyse_list_tab_normal);
            this.mChartContainer.setVisibility(0);
            this.mListContainer.setVisibility(8);
            this.contrastDataBottomRl.setVisibility(8);
        } else if (viewId == R.id.compare_analyse_list_rl) {
            if (this.mChartContainer.getVisibility() == 8 && this.mListContainer.getVisibility() == 0) {
                MLog.i(TAG, "onClick() -> statistics list is already showing  !!!");
                return;
            }
            this.compareAnalyseListTitleTv.setTextColor(this.getResources().getColor(R.color.c_4C8EFA));
            this.compareAnalyseListIconIv.setImageResource(R.drawable.compare_analyse_list_tab_selected);
            this.compareAnalyseChartTitleTv.setTextColor(this.getResources().getColor(R.color.c_666666));
            this.compareAnalyseChartIconIv.setImageResource(R.drawable.compare_analyse_chart_tab_normal);
            this.mChartContainer.setVisibility(8);
            this.mListContainer.setVisibility(0);
            this.contrastDataBottomRl.setVisibility(0);
        }
    }

    @Override
    public void onItemClick(int position) {
        this.mPresenter.deleteContrastItem(position);
    }

    @Override
    public void refreshViews() {
        this.mStatisticsBeans.clear();
        this.mStatisticsBeans.addAll(MonitorCache.getInstance().getStatisticsBeans());
        this.mListAdapter.getCheckStatisticsMap().clear();
        this.mListAdapter.notifyDataSetChanged();
        this.mColumnListAdapter.notifyDataSetChanged();
        this.updatePieChart();
    }

    @Override
    public void showEmptyView() {
        this.mListAdapter.notifyDataSetChanged();
        this.mColumnListAdapter.notifyDataSetChanged();
        this.mPieForm.setEventColor(-3355444);
        this.mPieForm.setTvEventName("");
        this.mPieForm.setTvClickPercent(0.0f);
        this.mPieForm.setTvClickCount(0L);
        this.updatePieChart();
    }

    @Override
    public void dismiss() {
        IMonitorListenerController.getInstance().removeDeleteStatisticsListener(this);
        super.dismiss();
    }

    private void updatePieChart() {
        List<StatisticsBean> statisticsBeans = MonitorCache.getInstance().getStatisticsBeans();
        if (null == statisticsBeans) {
            MLog.e(TAG, "setPieData() -> statisticsBeans is null !");
            return;
        }
        long[] data = new long[statisticsBeans.size()];
        int[] colorArray = new int[statisticsBeans.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = statisticsBeans.get(i).getClickCount();
            colorArray[i] = statisticsBeans.get(i).getColor();
        }
        this.mPieChart.setData(data, colorArray);
    }

    public void setPresenter(Object presenter) {
        this.mPresenter = (StatisticsViewContract.Presenter)presenter;
    }

    @Override
    public void confirmDeleteStatistics() {
        this.mPresenter.deleteContrast(this.mListAdapter.getCheckStatisticsMap());
    }
}

