/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.statistics;

import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ContrastItem;
import com.chinapex.android.monitor.bean.StatisticsBean;
import com.chinapex.android.monitor.bean.request.ContrastDataRequest;
import com.chinapex.android.monitor.bean.response.ContrastDataResponse;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.executor.runnable.IUpdateUI;
import com.chinapex.android.monitor.executor.runnable.PullContrastData;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.ColorUtils;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.statistics.StatisticsViewContract;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StatisticsViewPresenter
implements StatisticsViewContract.Presenter,
IUpdateUI {
    private static final String TAG = StatisticsViewPresenter.class.getSimpleName();
    private static final int FULL_PROPORTION = 100;
    private StatisticsViewContract.View mStatisticsView;

    public StatisticsViewPresenter(StatisticsViewContract.View view) {
        this.mStatisticsView = view;
    }

    @Override
    public void init() {
    }

    @Override
    public void loadContrastData() {
        Set<ContrastItem> contrastItems = MonitorCache.getInstance().getContrastItemList();
        if (null == contrastItems || contrastItems.isEmpty()) {
            MLog.e(TAG, "loadContrastData()-> contrastViewPathMD5List is null or empty");
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> pageSet = new HashSet<String>();
        for (ContrastItem item : contrastItems) {
            idSet.add(item.getViewPathMD5());
            pageSet.add(item.getPageClassName());
        }
        String[] ids = idSet.toArray(new String[0]);
        String[] pages = pageSet.toArray(new String[0]);
        ContrastDataRequest contrastDataRequest = new ContrastDataRequest();
        contrastDataRequest.setIds(ids);
        contrastDataRequest.setPages(pages);
        contrastDataRequest.setPeriod(0);
        contrastDataRequest.setTerminal("ANDROID");
        TaskController.getInstance().submit(new PullContrastData(contrastDataRequest, this));
    }

    @Override
    public void clearContrastItems() {
        List<StatisticsBean> statisticsBeans = MonitorCache.getInstance().getStatisticsBeans();
        if (null == statisticsBeans) {
            MLog.e(TAG, "clearContrastItems() -> StatisticsBeans is null !");
            return;
        }
        statisticsBeans.clear();
        Set<ContrastItem> contrastItems = MonitorCache.getInstance().getContrastItemList();
        if (null == contrastItems) {
            MLog.e(TAG, "loadContrastData()-> contrastViewPathMD5List is null or empty");
            return;
        }
        contrastItems.clear();
        IMonitorListenerController.getInstance().notifyComparisonElementsChange();
        this.mStatisticsView.showEmptyView();
    }

    @Override
    public void deleteContrastItem(int position) {
        Set<ContrastItem> contrastItems = MonitorCache.getInstance().getContrastItemList();
        if (null == contrastItems || contrastItems.isEmpty()) {
            MLog.e(TAG, "loadContrastData()-> contrastViewPathMD5List is null or empty");
            return;
        }
        List<StatisticsBean> statisticsBeans = MonitorCache.getInstance().getStatisticsBeans();
        if (null == statisticsBeans || statisticsBeans.isEmpty()) {
            MLog.e(TAG, "deleteContrastItem() ->  statisticsBeans is null or isEmpty !!!");
            return;
        }
        if (position < 0 || position > statisticsBeans.size() - 1) {
            MLog.e(TAG, "deleteContrastItem()-> argument error, will throw IndexOutOfBoundsException!");
            return;
        }
        StatisticsBean statisticsBean = statisticsBeans.remove(position);
        Iterator<ContrastItem> it = contrastItems.iterator();
        while (it.hasNext()) {
            ContrastItem item = it.next();
            if (!item.getViewPathMD5().equals(statisticsBean.getViewPathMD5())) continue;
            it.remove();
        }
        IMonitorListenerController.getInstance().notifyComparisonElementsChange();
        if (statisticsBeans.isEmpty()) {
            this.mStatisticsView.showEmptyView();
            return;
        }
        if (Constant.OTHERS_VIEW_PATH_MD5.equals(statisticsBean.getViewPathMD5())) {
            long sum = 0L;
            for (StatisticsBean bean : statisticsBeans) {
                sum += bean.getClickCount();
            }
            for (StatisticsBean bean : statisticsBeans) {
                bean.setClickProportion((float)bean.getClickCount() / (float)sum * 100.0f);
            }
        } else {
            boolean containsOthers = false;
            for (StatisticsBean bean : statisticsBeans) {
                if (!Constant.OTHERS_VIEW_PATH_MD5.equals(bean.getViewPathMD5())) continue;
                bean.setClickCount(bean.getClickCount() + statisticsBean.getClickCount());
                bean.setClickProportion(bean.getClickProportion() + statisticsBean.getClickProportion());
                containsOthers = true;
            }
            if (!containsOthers) {
                long sum = 0L;
                for (StatisticsBean bean : statisticsBeans) {
                    sum += bean.getClickCount();
                }
                for (StatisticsBean bean : statisticsBeans) {
                    bean.setClickProportion((float)bean.getClickCount() / (float)sum * 100.0f);
                }
            }
        }
        Collections.sort(statisticsBeans, new Comparator<StatisticsBean>(){

            @Override
            public int compare(StatisticsBean statisticsBean, StatisticsBean t1) {
                return statisticsBean.getClickProportion() > t1.getClickProportion() ? -1 : (statisticsBean.getClickCount() == t1.getClickCount() ? 0 : 1);
            }
        });
        this.mStatisticsView.refreshViews();
    }

    @Override
    public void deleteContrast(Map<String, StatisticsBean> staticsMap) {
        Set<ContrastItem> contrastItems = MonitorCache.getInstance().getContrastItemList();
        if (null == contrastItems || contrastItems.isEmpty()) {
            MLog.e(TAG, "loadContrastData()-> contrastViewPathMD5List is null or empty");
            return;
        }
        List<StatisticsBean> statisticsBeans = MonitorCache.getInstance().getStatisticsBeans();
        if (null == statisticsBeans || statisticsBeans.isEmpty()) {
            MLog.e(TAG, "deleteContrastItem() ->  statisticsBeans is null or isEmpty !!!");
            return;
        }
        if (staticsMap.size() < 1) {
            MLog.e(TAG, "deleteContrastItem()-> argument error, will throw IndexOutOfBoundsException!");
            return;
        }
        for (Map.Entry<String, StatisticsBean> entry : staticsMap.entrySet()) {
            StatisticsBean statisticsBean = entry.getValue();
            statisticsBeans.remove(statisticsBean);
            Iterator<ContrastItem> it = contrastItems.iterator();
            while (it.hasNext()) {
                ContrastItem item = it.next();
                if (!item.getViewPathMD5().equals(statisticsBean.getViewPathMD5())) continue;
                it.remove();
            }
            IMonitorListenerController.getInstance().notifyComparisonElementsChange();
            if (Constant.OTHERS_VIEW_PATH_MD5.equals(statisticsBean.getViewPathMD5())) {
                long sum = 0L;
                for (StatisticsBean bean : statisticsBeans) {
                    sum += bean.getClickCount();
                }
                for (StatisticsBean bean : statisticsBeans) {
                    bean.setClickProportion((float)bean.getClickCount() / (float)sum * 100.0f);
                }
                continue;
            }
            boolean containsOthers = false;
            for (StatisticsBean bean : statisticsBeans) {
                if (!Constant.OTHERS_VIEW_PATH_MD5.equals(bean.getViewPathMD5())) continue;
                bean.setClickCount(bean.getClickCount() + statisticsBean.getClickCount());
                bean.setClickProportion(bean.getClickProportion() + statisticsBean.getClickProportion());
                containsOthers = true;
            }
            if (containsOthers) continue;
            long sum = 0L;
            for (StatisticsBean bean : statisticsBeans) {
                sum += bean.getClickCount();
            }
            for (StatisticsBean bean : statisticsBeans) {
                bean.setClickProportion((float)bean.getClickCount() / (float)sum * 100.0f);
            }
        }
        Collections.sort(statisticsBeans, new Comparator<StatisticsBean>(){

            @Override
            public int compare(StatisticsBean statisticsBean, StatisticsBean t1) {
                return statisticsBean.getClickProportion() > t1.getClickProportion() ? -1 : (statisticsBean.getClickCount() == t1.getClickCount() ? 0 : 1);
            }
        });
        this.mStatisticsView.refreshViews();
    }

    @Override
    public void updateUI(boolean isSuccess, String result) {
        if (!isSuccess) {
            MLog.e(TAG, "updateUI() -> false!");
            return;
        }
        ContrastDataResponse contrastDataResponse = GsonUtils.json2Bean(result, ContrastDataResponse.class);
        if (null == contrastDataResponse) {
            MLog.e(TAG, "updateUI()-> contrastDataResponse is null!");
            return;
        }
        int status = contrastDataResponse.getStatus();
        if (200 != status) {
            MLog.e(TAG, "updateUI()-> error,status=" + status);
            return;
        }
        ContrastDataResponse.Data data = contrastDataResponse.getData();
        if (null == data) {
            MLog.e(TAG, "updateUI()-> data is null!");
            return;
        }
        ContrastDataResponse.Data.Element[] elements = data.getElements();
        if (null == elements || elements.length == 0) {
            MLog.e(TAG, "updateUI()-> elements is null or empty");
            return;
        }
        List<StatisticsBean> beans = MonitorCache.getInstance().getStatisticsBeans();
        if (null == beans) {
            MLog.e(TAG, "updateUI()-> beans is null");
            return;
        }
        beans.clear();
        long sum = 0L;
        float sumProportion = 0.0f;
        long total = data.getTotal();
        for (ContrastDataResponse.Data.Element element : elements) {
            if (null == element) {
                MLog.e(TAG, "testData()-> element is null!");
                continue;
            }
            long count = element.getCount();
            float clickProportion = (float)count / (float)total * 100.0f;
            if (total == 0L) {
                clickProportion = 0.0f;
            }
            sum += count;
            sumProportion += clickProportion;
            StatisticsBean statisticsBean = new StatisticsBean();
            statisticsBean.setClickCount(count);
            statisticsBean.setViewPathMD5(element.getId());
            statisticsBean.setEventLabel(element.getAlias());
            statisticsBean.setColor(ColorUtils.generateColor());
            statisticsBean.setClickProportion(clickProportion);
            statisticsBean.setSnapshotUrl(element.getSnapshot());
            beans.add(statisticsBean);
        }
        if (sum < total) {
            StatisticsBean statisticsBean = new StatisticsBean();
            statisticsBean.setViewPathMD5(Constant.OTHERS_VIEW_PATH_MD5);
            statisticsBean.setClickCount(total - sum);
            statisticsBean.setColor(ColorUtils.generateColor());
            statisticsBean.setEventLabel(MonitorCache.getInstance().getContext().getResources().getString(R.string.others));
            statisticsBean.setClickProportion(100.0f - sumProportion);
            beans.add(statisticsBean);
        }
        ColorUtils.reset();
        Collections.sort(beans, new Comparator<StatisticsBean>(){

            @Override
            public int compare(StatisticsBean statisticsBean, StatisticsBean t1) {
                return statisticsBean.getClickProportion() > t1.getClickProportion() ? -1 : (statisticsBean.getClickCount() == t1.getClickCount() ? 0 : 1);
            }
        });
        TaskController.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                StatisticsViewPresenter.this.mStatisticsView.refreshViews();
            }
        });
    }
}

