/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.upload;

import android.animation.ValueAnimator;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.StatisticsBean;
import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.changelistener.IDownloadConfigCallback;
import com.chinapex.android.monitor.changelistener.IMonitorListenerController;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.executor.runnable.WriteClickToSp;
import com.chinapex.android.monitor.executor.runnable.WriteElemPvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteExpandablePvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteListPvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteListToSp;
import com.chinapex.android.monitor.executor.runnable.WritePvToSp;
import com.chinapex.android.monitor.executor.runnable.WriteRecyclerPvToSp;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.DensityUtil;
import com.chinapex.android.monitor.utils.MD5Utils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.adapter.UploadListAdapter;
import com.chinapex.android.monitor.view.loading.LoadingView;
import com.chinapex.android.monitor.view.upload.UploadViewContract;
import com.chinapex.android.monitor.view.upload.UploadViewPresenter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class UploadView
extends BaseFloatingView
implements UploadViewContract.View,
View.OnClickListener,
UploadListAdapter.OnItemClickListener,
IDownloadConfigCallback {
    private static final String TAG = UploadView.class.getSimpleName();
    private ExpandableListView mExpandableListView;
    private UploadListAdapter mListAdapter;
    private List<UploadViewBean> mUploadViewBeans;
    private Map<String, ConfigBean.ClickBean> mClickBeans;
    private Map<String, Map<String, String>> mElemPvBeans;
    private Map<String, Map<String, String>> mRecyclerPvBeans;
    private Map<String, Map<String, String>> mListPvBeans;
    private Map<String, Map<String, String>> mExpandablePvBeans;
    private Map<String, ConfigBean.PvBean> mPvBeans;
    private Map<String, ConfigBean.ListBean> mListBeans;
    private UploadViewContract.Presenter mUploadViewPresenter;
    private RelativeLayout expandInfoRl;
    private ImageView expandIconIv;
    private TextView expandTitleTv;
    private TextView updateCountsTv;
    private int mExpandableListHeight;
    private View.OnClickListener expandOrHideListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (UploadView.this.mListAdapter != null && UploadView.this.mListAdapter.getGroupCount() > 0) {
                int tag = (Integer)UploadView.this.expandInfoRl.getTag() * -1;
                if (tag < 0) {
                    UploadView.this.hideUploadEventList((View)UploadView.this.mExpandableListView);
                    UploadView.this.openAnimation();
                    UploadView.this.expandTitleTv.setText((CharSequence)UploadView.this.getResources().getString(R.string.expand));
                } else {
                    UploadView.this.showUploadEventList((View)UploadView.this.mExpandableListView);
                    UploadView.this.closeAnimation();
                    UploadView.this.expandTitleTv.setText((CharSequence)UploadView.this.getResources().getString(R.string.hide));
                }
                UploadView.this.expandInfoRl.setTag((Object)tag);
            }
        }
    };

    public UploadView(@NonNull Context context, int windowType) {
        super(context, windowType);
        UploadView.inflate((Context)context, (int)R.layout.upload_view_layout, (ViewGroup)this);
        this.setPresenter(new UploadViewPresenter(this));
        this.initView();
        this.initData();
        this.addListener();
    }

    private void addListener() {
        this.expandInfoRl.setOnClickListener(this.expandOrHideListener);
    }

    private void showUploadEventList(View v) {
        v.measure(0, 0);
        int height = v.getMeasuredHeight() * this.mListAdapter.getGroupCount();
        ValueAnimator animator = this.createDropAnimator(v, 0, height);
        animator.start();
    }

    private void hideUploadEventList(View v) {
        v.measure(0, 0);
        int height = v.getMeasuredHeight() * this.mListAdapter.getGroupCount();
        ValueAnimator animator = this.createDropAnimator(v, height, 0);
        animator.start();
    }

    private ValueAnimator createDropAnimator(final View v, int start, int end) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{start, end});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                int value = (Integer)arg0.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
                layoutParams.height = value;
                v.setLayoutParams(layoutParams);
            }
        });
        return animator;
    }

    private void openAnimation() {
        RotateAnimation animation = new RotateAnimation(0.0f, 180.0f, 1, 0.5f, 1, 0.5f);
        animation.setFillAfter(true);
        animation.setDuration(100L);
        this.expandIconIv.startAnimation((Animation)animation);
    }

    private void closeAnimation() {
        RotateAnimation animation = new RotateAnimation(180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        animation.setFillAfter(true);
        animation.setDuration(100L);
        this.expandIconIv.startAnimation((Animation)animation);
    }

    private void initView() {
        this.expandIconIv = (ImageView)this.findViewById(R.id.upload_view_layout_expand_icon_iv);
        this.expandInfoRl = (RelativeLayout)this.findViewById(R.id.upload_view_layout_expand_info_rl);
        this.expandTitleTv = (TextView)this.findViewById(R.id.upload_view_layout_expand_title_tv);
        this.updateCountsTv = (TextView)this.findViewById(R.id.upload_view_layout_update_counts_tv);
        this.expandInfoRl.setTag((Object)1);
        this.mExpandableListView = (ExpandableListView)this.findViewById(R.id.upload_event_list);
        this.mUploadViewBeans = this.getUploadViewBeans();
        this.mListAdapter = new UploadListAdapter(this.mUploadViewBeans);
        this.mExpandableListView.setAdapter((ExpandableListAdapter)this.mListAdapter);
        this.mListAdapter.setOnItemClickListener(this);
        this.updateCountsTv.setText((CharSequence)(this.getResources().getString(R.string.update_item) + " (" + this.mUploadViewBeans.size() + ")"));
        this.mExpandableListView.setTag((Object)-1);
        this.mExpandableListView.setOnGroupExpandListener(new ExpandableListView.OnGroupExpandListener(){

            public void onGroupExpand(int groupPosition) {
                int count = UploadView.this.mListAdapter.getGroupCount();
                for (int i = 0; i < count; ++i) {
                    if (i == groupPosition) continue;
                    UploadView.this.mExpandableListView.setTag((Object)i);
                    UploadView.this.mExpandableListView.collapseGroup(i);
                }
                UploadView.this.mExpandableListView.measure(0, 0);
                UploadView.this.mExpandableListHeight = UploadView.this.mExpandableListView.getMeasuredHeight() * UploadView.this.mListAdapter.getGroupCount() + DensityUtil.dip2px(UploadView.this.getContext(), 60.0f);
                ViewGroup.LayoutParams layoutParams = UploadView.this.mExpandableListView.getLayoutParams();
                layoutParams.height = UploadView.this.mExpandableListHeight;
                UploadView.this.mExpandableListView.setLayoutParams(layoutParams);
            }
        });
        this.mExpandableListView.setOnGroupCollapseListener(new ExpandableListView.OnGroupCollapseListener(){

            public void onGroupCollapse(int groupPosition) {
                int tag = (Integer)UploadView.this.mExpandableListView.getTag();
                if (tag != groupPosition) {
                    int height = UploadView.this.mExpandableListHeight - DensityUtil.dip2px(UploadView.this.getContext(), 60.0f);
                    ViewGroup.LayoutParams layoutParams = UploadView.this.mExpandableListView.getLayoutParams();
                    layoutParams.height = height;
                    UploadView.this.mExpandableListView.setLayoutParams(layoutParams);
                    UploadView.this.mExpandableListView.setTag((Object)groupPosition);
                }
            }
        });
        this.findViewById(R.id.upload_view_layout_upload_tv).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.upload_view_layout_import_config_tv).setOnClickListener((View.OnClickListener)this);
        this.mExpandableListView.measure(0, 0);
        this.mExpandableListHeight = this.mExpandableListView.getMeasuredHeight() * this.mListAdapter.getGroupCount();
        ViewGroup.LayoutParams layoutParams = this.mExpandableListView.getLayoutParams();
        layoutParams.height = this.mExpandableListHeight;
        this.mExpandableListView.setLayoutParams(layoutParams);
    }

    private void initData() {
        List<StatisticsBean> statisticsBeans = MonitorCache.getInstance().getStatisticsBeans();
        if (null == statisticsBeans) {
            MonitorCache.getInstance().setStatisticsBeans(new ArrayList<StatisticsBean>());
        }
        this.mListAdapter.notifyDataSetChanged();
    }

    @Override
    public void show() {
        super.show();
        IMonitorListenerController.getInstance().addIDownloadConfigCallback(this);
    }

    @Override
    public void dismiss() {
        IMonitorListenerController.getInstance().removeIDownloadConfigCallback(this);
        super.dismiss();
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (R.id.upload_view_layout_upload_tv == viewId) {
            this.mUploadViewPresenter.upload(this.getUploadViewBeans());
        } else if (R.id.upload_view_layout_import_config_tv == viewId) {
            FloatingViewManager.getInstance().showFloatingView(7);
        }
    }

    @Override
    public void onItemClick(int position) {
        if (null == this.mUploadViewBeans) {
            MLog.e(TAG, "onItemClick() -> mUploadViewBeans is null!");
            return;
        }
        UploadViewBean uploadViewBean = this.mUploadViewBeans.get(position);
        if (null == uploadViewBean) {
            MLog.e(TAG, "onItemClick() -> uploadViewBean is null!");
            return;
        }
        String md5 = uploadViewBean.getMd5();
        if (TextUtils.isEmpty((CharSequence)md5)) {
            MLog.e(TAG, "onItemClick() -> md5 is null or empty!");
            return;
        }
        int eventType = uploadViewBean.getEventType();
        String pageClassName = uploadViewBean.getPageClassName();
        String pageClassNameMd5 = MD5Utils.getMD5(pageClassName);
        switch (eventType) {
            case 2: {
                if (null == this.mClickBeans) {
                    MLog.e(TAG, "onItemClick() -> mClickBeans is null!");
                    break;
                }
                this.mClickBeans.remove(md5);
                this.mUploadViewBeans.remove(position);
                TaskController.getInstance().submit(new WriteClickToSp());
                if (null == this.mElemPvBeans) {
                    MLog.e(TAG, "onItemClick() -> mElemPvBeans is null!");
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)pageClassNameMd5)) {
                    MLog.e(TAG, "onItemClick() -> pageClassNameMd5 is null or empty!");
                    break;
                }
                Map<String, String> elemPvBeans = this.mElemPvBeans.get(pageClassNameMd5);
                if (null == elemPvBeans) {
                    MLog.e(TAG, "onItemClick() -> elemPvBeans is null!");
                    break;
                }
                elemPvBeans.remove(md5);
                TaskController.getInstance().submit(new WriteElemPvToSp());
                this.updateCountsTv.setText((CharSequence)(this.getResources().getString(R.string.update_item) + " (" + this.mUploadViewBeans.size() + ")"));
                break;
            }
            case 4: {
                if (null == this.mPvBeans) {
                    MLog.e(TAG, "onItemClick() -> mPvBeans is null!");
                    break;
                }
                this.mPvBeans.remove(md5);
                this.mUploadViewBeans.remove(position);
                TaskController.getInstance().submit(new WritePvToSp());
                this.updateCountsTv.setText((CharSequence)(this.getResources().getString(R.string.update_item) + " (" + this.mUploadViewBeans.size() + ")"));
                break;
            }
            case 8: {
                if (null == this.mListBeans) {
                    MLog.e(TAG, "onItemClick() -> mListBeans is null!");
                    break;
                }
                String listId = uploadViewBean.getListId();
                if (TextUtils.isEmpty((CharSequence)listId)) {
                    MLog.e(TAG, "onItemClick() -> listId is null or empty!");
                    break;
                }
                ConfigBean.ListBean listBean = this.mListBeans.get(listId);
                if (null == listBean) {
                    MLog.e(TAG, "onItemClick() -> listBean is null!");
                    break;
                }
                Map<String, String> itemAliases = listBean.getItemAliases();
                if (null == itemAliases || itemAliases.isEmpty()) {
                    MLog.e(TAG, "onItemClick() -> itemAliases is null or empty!");
                    break;
                }
                itemAliases.remove(md5);
                this.mUploadViewBeans.remove(position);
                TaskController.getInstance().submit(new WriteListToSp());
                this.updateCountsTv.setText((CharSequence)(this.getResources().getString(R.string.update_item) + " (" + this.mUploadViewBeans.size() + ")"));
                if (TextUtils.isEmpty((CharSequence)pageClassNameMd5)) {
                    MLog.e(TAG, "onItemClick() -> pageClassNameMd5 is null or empty!");
                    return;
                }
                this.deleteRecyclerPv(pageClassNameMd5, listId);
                this.deleteListPv(pageClassNameMd5, listId);
                this.deleteExpandablePv(pageClassNameMd5, listId);
                break;
            }
        }
    }

    @Override
    public void jumpToActivity(String className) {
        Intent mIntent = new Intent();
        ComponentName component = new ComponentName(this.getContext(), className);
        mIntent.setComponent(component);
        mIntent.setFlags(0x10000000);
        this.getContext().startActivity(mIntent);
        this.dismiss();
    }

    private void deleteExpandablePv(String pageClassNameMd5, String listId) {
        if (null == this.mExpandablePvBeans) {
            MLog.e(TAG, "deleteExpandablePv() -> mExpandablePvBeans is null!");
            return;
        }
        Map<String, String> expandablePvBeans = this.mExpandablePvBeans.get(pageClassNameMd5);
        if (null == expandablePvBeans) {
            return;
        }
        expandablePvBeans.remove(listId);
        TaskController.getInstance().submit(new WriteExpandablePvToSp());
    }

    private void deleteListPv(String pageClassNameMd5, String listId) {
        if (null == this.mListPvBeans) {
            MLog.e(TAG, "deleteListPv() -> mListPvBeans is null!");
            return;
        }
        Map<String, String> listPvBeans = this.mListPvBeans.get(pageClassNameMd5);
        if (null == listPvBeans) {
            return;
        }
        listPvBeans.remove(listId);
        TaskController.getInstance().submit(new WriteListPvToSp());
    }

    private void deleteRecyclerPv(String pageClassNameMd5, String listId) {
        if (null == this.mRecyclerPvBeans) {
            MLog.e(TAG, "deleteRecyclerPv() -> mRecyclerPvBeans is null!");
            return;
        }
        Map<String, String> recyclerPvBeans = this.mRecyclerPvBeans.get(pageClassNameMd5);
        if (null == recyclerPvBeans) {
            return;
        }
        recyclerPvBeans.remove(listId);
        TaskController.getInstance().submit(new WriteRecyclerPvToSp());
    }

    public void setPresenter(Object presenter) {
        this.mUploadViewPresenter = (UploadViewContract.Presenter)presenter;
    }

    private List<UploadViewBean> getUploadViewBeans() {
        ArrayList<UploadViewBean> uploadViewBeans = new ArrayList<UploadViewBean>();
        this.mPvBeans = MonitorCache.getInstance().getPvBeans();
        this.mClickBeans = MonitorCache.getInstance().getClickBeans();
        this.mElemPvBeans = MonitorCache.getInstance().getElemPvBeans();
        this.mListBeans = MonitorCache.getInstance().getListBeans();
        this.mRecyclerPvBeans = MonitorCache.getInstance().getRecyclerPvBeans();
        this.mListPvBeans = MonitorCache.getInstance().getListPvBeans();
        this.mExpandablePvBeans = MonitorCache.getInstance().getExpandablePvBeans();
        if (null == this.mClickBeans || null == this.mElemPvBeans || null == this.mPvBeans || null == this.mListBeans || null == this.mRecyclerPvBeans || null == this.mListPvBeans || null == this.mExpandablePvBeans) {
            MLog.e(TAG, "getUploadViewBeans() -> mClickBeans or mElemPvBeans or mPvBeans or mListBeans or mRecyclerPvBeans or mListPvBeans or mExpandablePvBeans is null!");
            return uploadViewBeans;
        }
        ListIterator<Map.Entry<String, ConfigBean.ClickBean>> mClickIterator = new ArrayList<Map.Entry<String, ConfigBean.ClickBean>>(this.mClickBeans.entrySet()).listIterator(this.mClickBeans.size());
        while (mClickIterator.hasPrevious()) {
            Map.Entry<String, ConfigBean.ClickBean> clickBeanEntry = mClickIterator.previous();
            if (null == clickBeanEntry) {
                MLog.e(TAG, "getUploadViewBeans() -> clickBeanEntry is null!");
                continue;
            }
            String md5 = clickBeanEntry.getKey();
            ConfigBean.ClickBean clickBean = clickBeanEntry.getValue();
            if (TextUtils.isEmpty((CharSequence)md5) || null == clickBean) {
                MLog.e(TAG, "getUploadViewBeans() -> md5 or clickBean is null or empty!");
                continue;
            }
            UploadViewBean uploadViewBean = new UploadViewBean();
            uploadViewBean.setEventType(2);
            uploadViewBean.setMd5(md5);
            uploadViewBean.setAlias(clickBean.getAlias());
            uploadViewBean.setPageClassName(clickBean.getPageClassName());
            uploadViewBeans.add(uploadViewBean);
        }
        ListIterator<Map.Entry<String, ConfigBean.PvBean>> pvBeanIterator = new ArrayList<Map.Entry<String, ConfigBean.PvBean>>(this.mPvBeans.entrySet()).listIterator(this.mPvBeans.size());
        while (pvBeanIterator.hasPrevious()) {
            Map.Entry<String, ConfigBean.PvBean> pvBeanEntry = pvBeanIterator.previous();
            if (null == pvBeanEntry) {
                MLog.e(TAG, "getUploadViewBeans() -> pvBeanEntry is null!");
                continue;
            }
            String md5 = pvBeanEntry.getKey();
            ConfigBean.PvBean pvBean = pvBeanEntry.getValue();
            if (TextUtils.isEmpty((CharSequence)md5) || null == pvBean) {
                MLog.e(TAG, "getUploadViewBeans() -> md5 or pvBean is null or empty!");
                continue;
            }
            UploadViewBean uploadViewBean = new UploadViewBean();
            uploadViewBean.setEventType(4);
            uploadViewBean.setMd5(md5);
            uploadViewBean.setAlias(pvBean.getAlias());
            uploadViewBean.setPageClassName(pvBean.getViewPath());
            uploadViewBeans.add(uploadViewBean);
        }
        ListIterator<Map.Entry<String, ConfigBean.ListBean>> listBeanIterator = new ArrayList<Map.Entry<String, ConfigBean.ListBean>>(this.mListBeans.entrySet()).listIterator(this.mListBeans.size());
        while (listBeanIterator.hasPrevious()) {
            Map.Entry<String, ConfigBean.ListBean> listBeanEntry = listBeanIterator.previous();
            if (null == listBeanEntry) {
                MLog.e(TAG, "getUploadViewBeans() -> listBeanEntry is null!");
                continue;
            }
            String listId = listBeanEntry.getKey();
            ConfigBean.ListBean listBean = listBeanEntry.getValue();
            if (TextUtils.isEmpty((CharSequence)listId) || null == listBean) {
                MLog.e(TAG, "getUploadViewBeans() -> listId or listBean is null or empty!");
                continue;
            }
            Map<String, String> itemAliases = listBean.getItemAliases();
            if (null == itemAliases || itemAliases.isEmpty()) {
                MLog.e(TAG, "getUploadViewBeans() -> itemAliases is null or empty!");
                continue;
            }
            ListIterator<Map.Entry<String, String>> itemAliasesIterator = new ArrayList<Map.Entry<String, String>>(itemAliases.entrySet()).listIterator(itemAliases.size());
            while (itemAliasesIterator.hasPrevious()) {
                Map.Entry<String, String> itemAlias = itemAliasesIterator.previous();
                if (null == itemAlias) {
                    MLog.e(TAG, "getUploadViewBeans() -> itemAlias is null!");
                    continue;
                }
                String md5 = itemAlias.getKey();
                String alias = itemAlias.getValue();
                if (TextUtils.isEmpty((CharSequence)md5) || TextUtils.isEmpty((CharSequence)alias)) {
                    MLog.e(TAG, "getUploadViewBeans() -> md5 or alias is null!");
                    continue;
                }
                UploadViewBean uploadViewBean = new UploadViewBean();
                uploadViewBean.setEventType(8);
                uploadViewBean.setMd5(md5);
                uploadViewBean.setAlias(alias);
                uploadViewBean.setListId(listId);
                uploadViewBean.setPageClassName(listBean.getPageClassName());
                uploadViewBeans.add(uploadViewBean);
            }
        }
        return uploadViewBeans;
    }

    @Override
    public void showUploadSuccess() {
        FloatingViewManager.getInstance().showFloatingView(8);
        LoadingView loadingView = (LoadingView)FloatingViewManager.getInstance().getFloatingView(8);
        if (null == loadingView) {
            MLog.e(TAG, "showUploadSuccess()-> loadingView is null");
            return;
        }
        loadingView.setLoadingOk(this.getResources().getString(R.string.loading_upload_ok));
    }

    @Override
    public void showUploadFailed() {
        FloatingViewManager.getInstance().showFloatingView(8);
        LoadingView loadingView = (LoadingView)FloatingViewManager.getInstance().getFloatingView(8);
        if (null == loadingView) {
            MLog.e(TAG, "showUploadSuccess()-> loadingView is null");
            return;
        }
        loadingView.setLoadingFail(this.getResources().getString(R.string.loading_upload_fail));
    }

    @Override
    public void showUploading() {
        FloatingViewManager.getInstance().showFloatingView(8);
        LoadingView loadingView = (LoadingView)FloatingViewManager.getInstance().getFloatingView(8);
        if (null == loadingView) {
            MLog.e(TAG, "showUploadSuccess()-> loadingView is null");
            return;
        }
        loadingView.setLoadingOk(this.getResources().getString(R.string.loading_uploading));
    }

    @Override
    public void downloadConfig(boolean isSuccessful) {
        if (!isSuccessful) {
            MLog.e(TAG, "downloadConfig fail! no need update UI");
            return;
        }
        TaskController.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UploadView.this.mUploadViewBeans.clear();
                UploadView.this.mUploadViewBeans.addAll(UploadView.this.getUploadViewBeans());
                UploadView.this.mListAdapter.notifyDataSetChanged();
                UploadView.this.updateCountsTv.setText((CharSequence)(UploadView.this.getResources().getString(R.string.update_item) + " (" + UploadView.this.mUploadViewBeans.size() + ")"));
            }
        });
    }
}

