/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.upload;

import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.bean.response.CommonResponse;
import com.chinapex.android.monitor.callback.IWriteConfigToSpCallback;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.executor.runnable.IUpdateUI;
import com.chinapex.android.monitor.executor.runnable.UploadSnapshots;
import com.chinapex.android.monitor.executor.runnable.WriteConfigToSp;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.upload.UploadViewContract;
import java.util.List;

public class UploadViewPresenter
implements UploadViewContract.Presenter,
IWriteConfigToSpCallback,
IUpdateUI {
    private static final String TAG = UploadViewPresenter.class.getSimpleName();
    private UploadViewContract.View mUploadView;
    private boolean isUploadConfigSuccess;
    private boolean isUploadSnapshotSuccess;

    public UploadViewPresenter(UploadViewContract.View view) {
        this.mUploadView = view;
    }

    @Override
    public void init() {
    }

    @Override
    public void upload(List<UploadViewBean> uploadViewBeans) {
        this.mUploadView.showUploading();
        TaskController.getInstance().submit(new WriteConfigToSp(this));
        TaskController.getInstance().submit(new UploadSnapshots(uploadViewBeans, this));
    }

    @Override
    public void writeConfigToSp(boolean isSuccessful) {
        this.isUploadConfigSuccess = isSuccessful;
        if (!isSuccessful) {
            TaskController.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UploadViewPresenter.this.mUploadView.showUploadFailed();
                }
            });
            return;
        }
        this.result();
    }

    @Override
    public void updateUI(boolean isSuccess, String result) {
        if (!isSuccess) {
            TaskController.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UploadViewPresenter.this.mUploadView.showUploadFailed();
                }
            });
            this.isUploadSnapshotSuccess = false;
            return;
        }
        CommonResponse response = GsonUtils.json2Bean(result, CommonResponse.class);
        if (null == response) {
            MLog.e(TAG, "updateUI()-> response is null!");
            TaskController.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UploadViewPresenter.this.mUploadView.showUploadFailed();
                }
            });
            this.isUploadSnapshotSuccess = false;
            return;
        }
        int status = response.getStatus();
        this.isUploadSnapshotSuccess = response.isData();
        if (200 != status || !this.isUploadSnapshotSuccess) {
            MLog.e(TAG, "updateUI()-> error: status is " + status + ", data=" + this.isUploadSnapshotSuccess);
            TaskController.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UploadViewPresenter.this.mUploadView.showUploadFailed();
                }
            });
            return;
        }
        this.result();
    }

    private void result() {
        if (this.isUploadSnapshotSuccess && this.isUploadConfigSuccess) {
            TaskController.getInstance().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UploadViewPresenter.this.mUploadView.showUploadSuccess();
                }
            });
            this.isUploadConfigSuccess = false;
            this.isUploadSnapshotSuccess = false;
        }
    }
}

