/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.pool;

import com.github.mauricio.async.db.pool.AsyncObjectPool;
import com.github.mauricio.async.db.pool.ObjectFactory;
import com.github.mauricio.async.db.pool.PoolAlreadyTerminatedException;
import com.github.mauricio.async.db.pool.PoolConfiguration;
import com.github.mauricio.async.db.pool.PoolExhaustedException;
import com.github.mauricio.async.db.pool.SingleThreadedAsyncObjectPool$;
import com.github.mauricio.async.db.util.Worker;
import com.github.mauricio.async.db.util.Worker$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Queue;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\u0015q!B\u0001\u0003\u0011\u0003y\u0011!H*j]\u001edW\r\u00165sK\u0006$W\rZ!ts:\u001cwJ\u00196fGR\u0004vn\u001c7\u000b\u0005\r!\u0011\u0001\u00029p_2T!!\u0002\u0004\u0002\u0005\u0011\u0014'BA\u0004\t\u0003\u0015\t7/\u001f8d\u0015\tI!\"\u0001\u0005nCV\u0014\u0018nY5p\u0015\tYA\"\u0001\u0004hSRDWO\u0019\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\ti2+\u001b8hY\u0016$\u0006N]3bI\u0016$\u0017i]=oG>\u0013'.Z2u!>|Gn\u0005\u0002\u0012)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001aDQaG\t\u0005\u0002q\ta\u0001P5oSRtD#A\b\t\u000fy\t\"\u0019!C\u0001?\u000591i\\;oi\u0016\u0014X#\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013AB1u_6L7M\u0003\u0002&M\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u001dB\u0013\u0001B;uS2T\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,E\tQ\u0011\t^8nS\u000eduN\\4\t\r5\n\u0002\u0015!\u0003!\u0003!\u0019u.\u001e8uKJ\u0004\u0003bB\u0018\u0012\u0005\u0004%\t\u0001M\u0001\u0004Y><W#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!B:mMRR'\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029g\t1Aj\\4hKJDaAO\t!\u0002\u0013\t\u0014\u0001\u00027pO\u00022AA\u0005\u0002\u0001yU\u0011QhQ\n\u0004wQq\u0004c\u0001\t@\u0003&\u0011\u0001I\u0001\u0002\u0010\u0003NLhnY(cU\u0016\u001cG\u000fU8pYB\u0011!i\u0011\u0007\u0001\t\u0015!5H1\u0001F\u0005\u0005!\u0016C\u0001$J!\t)r)\u0003\u0002I-\t9aj\u001c;iS:<\u0007CA\u000bK\u0013\tYeCA\u0002B]fD\u0001\"T\u001e\u0003\u0002\u0003\u0006IAT\u0001\bM\u0006\u001cGo\u001c:z!\r\u0001r*Q\u0005\u0003!\n\u0011Qb\u00142kK\u000e$h)Y2u_JL\b\u0002\u0003*<\u0005\u0003\u0005\u000b\u0011B*\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t\u0001B+\u0003\u0002V\u0005\t\t\u0002k\\8m\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bmYD\u0011A,\u0015\u0007aK&\fE\u0002\u0011w\u0005CQ!\u0014,A\u00029CQA\u0015,A\u0002MCq\u0001X\u001eC\u0002\u0013%Q,\u0001\u0005nC&t\u0007k\\8m+\u0005q\u0006CA0b\u001b\u0005\u0001'BA\u0014\u0005\u0013\t\u0011\u0007M\u0001\u0004X_J\\WM\u001d\u0005\u0007In\u0002\u000b\u0011\u00020\u0002\u00135\f\u0017N\u001c)p_2\u0004\u0003b\u00024<\u0001\u0004%IaZ\u0001\na>|G.\u00192mKN,\u0012\u0001\u001b\t\u0004S:\u0004X\"\u00016\u000b\u0005-d\u0017!C5n[V$\u0018M\u00197f\u0015\tig#\u0001\u0006d_2dWm\u0019;j_:L!a\u001c6\u0003\t1K7\u000f\u001e\t\u0004cJ\fU\"A\u001e\u0007\tM\\D\u0001\u001e\u0002\u000f!>|G.\u00192mK\"{G\u000eZ3s+\t)(p\u0005\u0002s)!AqO\u001dBC\u0002\u0013\u0005\u00010\u0001\u0003ji\u0016lW#A=\u0011\u0005\tSH!\u0002#s\u0005\u0004)\u0005\u0002\u0003?s\u0005\u0003\u0005\u000b\u0011B=\u0002\u000b%$X-\u001c\u0011\t\u000bm\u0011H\u0011\u0001@\u0015\u0007}\f\t\u0001E\u0002refDQa^?A\u0002eD\u0011\"!\u0002s\u0005\u0004%\t!a\u0002\u0002\tQLW.Z\u000b\u0003\u0003\u0013\u00012!FA\u0006\u0013\r\tiA\u0006\u0002\u0005\u0019>tw\r\u0003\u0005\u0002\u0012I\u0004\u000b\u0011BA\u0005\u0003\u0015!\u0018.\\3!\u0011\u001d\t)B\u001dC\u0001\u0003\u000f\t1\u0002^5nK\u0016c\u0017\r]:fI\"I\u0011\u0011D\u001eA\u0002\u0013%\u00111D\u0001\u000ea>|G.\u00192mKN|F%Z9\u0015\t\u0005u\u00111\u0005\t\u0004+\u0005}\u0011bAA\u0011-\t!QK\\5u\u0011%\t)#a\u0006\u0002\u0002\u0003\u0007\u0001.A\u0002yIEBq!!\u000b<A\u0003&\u0001.\u0001\u0006q_>d\u0017M\u00197fg\u0002B\u0011\"!\f<\u0005\u0004%I!a\f\u0002\u0013\rDWmY6pkR\u001cXCAA\u0019!\u0015\t\u0019$!\u000fB\u001b\t\t)DC\u0002\u000281\fq!\\;uC\ndW-\u0003\u0003\u0002<\u0005U\"aC!se\u0006L()\u001e4gKJD\u0001\"a\u0010<A\u0003%\u0011\u0011G\u0001\u000bG\",7m[8viN\u0004\u0003\"CA\"w\t\u0007I\u0011BA#\u0003%9\u0018-\u001b;Rk\u0016,X-\u0006\u0002\u0002HA1\u00111GA%\u0003\u001bJA!a\u0013\u00026\t)\u0011+^3vKB)\u0011qJA*\u00036\u0011\u0011\u0011\u000b\u0006\u0003KYIA!!\u0016\u0002R\t9\u0001K]8nSN,\u0007\u0002CA-w\u0001\u0006I!a\u0012\u0002\u0015]\f\u0017\u000e^)vKV,\u0007\u0005C\u0005\u0002^m\u0012\r\u0011\"\u0003\u0002`\u0005)A/[7feV\u0011\u0011\u0011\r\t\u0005\u0003G\n)'D\u0001'\u0013\r\t9G\n\u0002\u0006)&lWM\u001d\u0005\t\u0003WZ\u0004\u0015!\u0003\u0002b\u00051A/[7fe\u0002B\u0011\"a\u001c<\u0001\u0004%I!!\u001d\u0002\r\rdwn]3e+\t\t\u0019\bE\u0002\u0016\u0003kJ1!a\u001e\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u001f<\u0001\u0004%I!! \u0002\u0015\rdwn]3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005}\u0004BCA\u0013\u0003s\n\t\u00111\u0001\u0002t!A\u00111Q\u001e!B\u0013\t\u0019(A\u0004dY>\u001cX\r\u001a\u0011\t\u000f\u0005\u001d5\b\"\u0001\u0002\n\u0006!A/Y6f+\t\tY\tE\u0003\u0002P\u00055\u0015)\u0003\u0003\u0002\u0010\u0006E#A\u0002$viV\u0014X\rC\u0004\u0002\u0014n\"\t!!&\u0002\u0011\u001dLg/\u001a\"bG.$B!a&\u0002\u001aB)\u0011qJAG}!1q/!%A\u0002\u0005Cq!!(<\t\u0003\t\t(\u0001\u0004jg\u001a+H\u000e\u001c\u0005\b\u0003C[D\u0011AAR\u0003\u0015\u0019Gn\\:f+\t\t9\nC\u0004\u0002(n\"\t!!+\u0002\u0015\u00054\u0018-\u001b7bE2,7/\u0006\u0002\u0002,B)\u0011QVA_\u0003:!\u0011qVA]\u001d\u0011\t\t,a.\u000e\u0005\u0005M&bAA[\u001d\u00051AH]8pizJ\u0011aF\u0005\u0004\u0003w3\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\u000b\tMA\u0006Ue\u00064XM]:bE2,'bAA^-!9\u0011QY\u001e\u0005\u0002\u0005%\u0016!B5o+N,\u0007bBAew\u0011\u0005\u00111Z\u0001\u0007cV,W/\u001a3\u0016\u0005\u00055\u0007CBAW\u0003{\u000bi\u0005C\u0004\u0002Rn\"\t!!\u001d\u0002\u0011%\u001c8\t\\8tK\u0012Dq!!6<\t\u0013\t9.A\u0004bI\u0012\u0014\u0015mY6\u0015\r\u0005u\u0011\u0011\\An\u0011\u00199\u00181\u001ba\u0001\u0003\"A\u0011Q\\Aj\u0001\u0004\ty.A\u0004qe>l\u0017n]3\u0011\u000b\u0005=\u00131\u000b \t\u000f\u0005\r8\b\"\u0003\u0002f\u0006qQM\\9vKV,\u0007K]8nSN,G\u0003BA\u000f\u0003OD\u0001\"!8\u0002b\u0002\u0007\u0011Q\n\u0005\b\u0003W\\D\u0011BAw\u0003!\u0019\u0007.Z2l_V$H\u0003BA\u000f\u0003_D\u0001\"!8\u0002j\u0002\u0007\u0011Q\n\u0005\b\u0003g\\D\u0011BA{\u0003I\u0019'/Z1uK>\u0013(+\u001a;ve:LE/Z7\u0015\t\u0005u\u0011q\u001f\u0005\t\u0003;\f\t\u00101\u0001\u0002N!9\u00111`\u001e\u0005B\u0005u\u0018\u0001\u00034j]\u0006d\u0017N_3\u0015\u0005\u0005u\u0001b\u0002B\u0001w\u0011%!1A\u0001\fi\u0016\u001cHo\u00142kK\u000e$8/\u0006\u0002\u0002\u001e\u0001")
public class SingleThreadedAsyncObjectPool<T>
implements AsyncObjectPool<T> {
    private final ObjectFactory<T> factory;
    private final PoolConfiguration configuration;
    private final Worker com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool;
    private List<PoolableHolder<T>> poolables;
    private final ArrayBuffer<T> checkouts;
    private final Queue<Promise<T>> waitQueue;
    private final Timer timer;
    private boolean closed;

    public static Logger log() {
        return SingleThreadedAsyncObjectPool$.MODULE$.log();
    }

    public static AtomicLong Counter() {
        return SingleThreadedAsyncObjectPool$.MODULE$.Counter();
    }

    @Override
    public <A> Future<A> use(Function1<T, Future<A>> f, ExecutionContext executionContext) {
        return AsyncObjectPool.use$(this, f, executionContext);
    }

    public Worker com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool() {
        return this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool;
    }

    private List<PoolableHolder<T>> poolables() {
        return this.poolables;
    }

    private void poolables_$eq(List<PoolableHolder<T>> x$1) {
        this.poolables = x$1;
    }

    private ArrayBuffer<T> checkouts() {
        return this.checkouts;
    }

    private Queue<Promise<T>> waitQueue() {
        return this.waitQueue;
    }

    private Timer timer() {
        return this.timer;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    @Override
    public Future<T> take() {
        if (this.closed()) {
            return Promise$.MODULE$.failed((Throwable)new PoolAlreadyTerminatedException()).future();
        }
        Promise promise = Promise$.MODULE$.apply();
        this.checkout(promise);
        return promise.future();
    }

    @Override
    public Future<AsyncObjectPool<T>> giveBack(T item) {
        Promise promise = Promise$.MODULE$.apply();
        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int idx = this.checkouts().indexOf(item);
            if (idx >= 0) {
                this.checkouts().remove(idx);
                Try<Object> try_ = $this.factory.validate(item);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object item = success.value();
                    this.addBack(item, promise);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    if (!(try_ instanceof Failure)) throw new MatchError(try_);
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    $this.factory.destroy(item);
                    promise.failure(e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            } else {
                Option option;
                Object object = item;
                if (object instanceof Object) {
                    Object object2 = object;
                    option = this.poolables().find((Function1 & Serializable & scala.Serializable)holder -> BoxesRunTime.boxToBoolean((boolean)SingleThreadedAsyncObjectPool.$anonfun$giveBack$2(object2, holder)));
                } else {
                    option = this.poolables().find((Function1 & Serializable & scala.Serializable)holder -> BoxesRunTime.boxToBoolean((boolean)SingleThreadedAsyncObjectPool.$anonfun$giveBack$3(item, holder)));
                }
                boolean isFromOurPool = option.isDefined();
                if (isFromOurPool) {
                    promise.failure((Throwable)new IllegalStateException("This item has already been returned"));
                    return;
                } else {
                    promise.failure((Throwable)new IllegalArgumentException("The returned item did not come from this pool."));
                }
            }
        });
        return promise.future();
    }

    public boolean isFull() {
        return this.poolables().isEmpty() && this.checkouts().size() == this.configuration.maxObjects();
    }

    @Override
    public Future<AsyncObjectPool<T>> close() {
        Future future;
        try {
            Promise promise = Promise$.MODULE$.apply();
            this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (!this.closed()) {
                    try {
                        this.timer().cancel();
                        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().shutdown();
                        this.closed_$eq(true);
                        ((List)((List)this.poolables().map((Function1 & Serializable & scala.Serializable)i -> i.item(), List$.MODULE$.canBuildFrom())).$plus$plus(this.checkouts(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                            this.factory.destroy(item);
                            return BoxedUnit.UNIT;
                        });
                        promise.success((Object)this);
                    }
                    catch (Exception e) {
                        promise.failure((Throwable)e);
                    }
                } else {
                    promise.success((Object)this);
                }
            });
            future = promise.future();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof RejectedExecutionException) || !this.closed()) {
                throw throwable;
            }
            Future future2 = Future$.MODULE$.successful((Object)this);
            future = future2;
        }
        return future;
    }

    public Traversable<T> availables() {
        return (Traversable)this.poolables().map((Function1 & Serializable & scala.Serializable)item -> item.item(), List$.MODULE$.canBuildFrom());
    }

    public Traversable<T> inUse() {
        return this.checkouts();
    }

    public Traversable<Promise<T>> queued() {
        return this.waitQueue();
    }

    public boolean isClosed() {
        return this.closed();
    }

    private void addBack(T item, Promise<AsyncObjectPool<T>> promise) {
        this.poolables_$eq(this.poolables().$colon$colon(new PoolableHolder<T>(this, item)));
        if (this.waitQueue().nonEmpty()) {
            this.checkout((Promise)this.waitQueue().dequeue());
        }
        promise.success((Object)this);
    }

    private void enqueuePromise(Promise<T> promise) {
        if (this.waitQueue().size() >= this.configuration.maxQueueSize()) {
            PoolExhaustedException exception = new PoolExhaustedException("There are no objects available and the waitQueue is full");
            exception.fillInStackTrace();
            promise.failure((Throwable)exception);
        } else {
            this.waitQueue().$plus$eq(promise);
        }
    }

    private void checkout(Promise<T> promise) {
        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isFull()) {
                this.enqueuePromise(promise);
            } else {
                this.createOrReturnItem(promise);
            }
        });
    }

    private void createOrReturnItem(Promise<T> promise) {
        if (this.poolables().isEmpty()) {
            try {
                T item = this.factory.create();
                this.checkouts().$plus$eq(item);
                promise.success(item);
            }
            catch (Exception e) {
                promise.failure((Throwable)e);
            }
        } else {
            List<PoolableHolder<T>> list = this.poolables();
            if (!(list instanceof .colon.colon)) {
                throw new MatchError(list);
            }
            .colon.colon colon2 = (.colon.colon)list;
            PoolableHolder h = (PoolableHolder)colon2.head();
            List t = colon2.tl$access$1();
            Tuple2 tuple2 = new Tuple2((Object)h, (Object)t);
            Tuple2 tuple22 = tuple2;
            PoolableHolder h2 = (PoolableHolder)tuple22._1();
            List t2 = (List)tuple22._2();
            this.poolables_$eq(t2);
            Object item = h2.item();
            this.checkouts().$plus$eq(item);
            promise.success(item);
        }
    }

    public void finalize() {
        this.close();
    }

    public void com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$testObjects() {
        ArrayBuffer removals = new ArrayBuffer();
        this.poolables().foreach((Function1 & Serializable & scala.Serializable)poolable -> {
            SingleThreadedAsyncObjectPool.$anonfun$testObjects$1(this, removals, poolable);
            return BoxedUnit.UNIT;
        });
        this.poolables_$eq((List)this.poolables().diff((GenSeq)removals));
    }

    public static final /* synthetic */ boolean $anonfun$giveBack$2(Object x2$1, PoolableHolder holder) {
        return x2$1 == holder.item();
    }

    public static final /* synthetic */ boolean $anonfun$giveBack$3(Object item$1, PoolableHolder holder) {
        return BoxesRunTime.equals((Object)item$1, holder.item());
    }

    public static final /* synthetic */ void $anonfun$testObjects$1(SingleThreadedAsyncObjectPool $this, ArrayBuffer removals$1, PoolableHolder poolable) {
        Try try_ = $this.factory.test(poolable.item());
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            if (poolable.timeElapsed() > $this.configuration.maxIdle()) {
                SingleThreadedAsyncObjectPool$.MODULE$.log().debug("Connection was idle for {}, maxIdle is {}, removing it", (Object)BoxesRunTime.boxToLong((long)poolable.timeElapsed()), (Object)BoxesRunTime.boxToLong((long)$this.configuration.maxIdle()));
                removals$1.$plus$eq((Object)poolable);
                $this.factory.destroy(poolable.item());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            SingleThreadedAsyncObjectPool$.MODULE$.log().error("Failed to validate object", e);
            removals$1.$plus$eq((Object)poolable);
            $this.factory.destroy(poolable.item());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public SingleThreadedAsyncObjectPool(ObjectFactory<T> factory, PoolConfiguration configuration) {
        this.factory = factory;
        this.configuration = configuration;
        AsyncObjectPool.$init$(this);
        this.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool = Worker$.MODULE$.apply();
        this.poolables = List$.MODULE$.empty();
        this.checkouts = new ArrayBuffer(configuration.maxObjects());
        this.waitQueue = new Queue();
        this.timer = new Timer("async-object-pool-timer-" + SingleThreadedAsyncObjectPool$.MODULE$.Counter().incrementAndGet(), true);
        this.timer().scheduleAtFixedRate(new TimerTask(this){
            private final /* synthetic */ SingleThreadedAsyncObjectPool $outer;

            public void run() {
                this.$outer.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$mainPool().action((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$$testObjects());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(com.github.mauricio.async.db.pool.SingleThreadedAsyncObjectPool$$anon$1 )}, serializedLambda);
            }
        }, configuration.validationInterval(), configuration.validationInterval());
        this.closed = false;
    }

    public class PoolableHolder<T> {
        private final T item;
        private final long time;
        public final /* synthetic */ SingleThreadedAsyncObjectPool $outer;

        public T item() {
            return this.item;
        }

        public long time() {
            return this.time;
        }

        public long timeElapsed() {
            return System.currentTimeMillis() - this.time();
        }

        public /* synthetic */ SingleThreadedAsyncObjectPool com$github$mauricio$async$db$pool$SingleThreadedAsyncObjectPool$PoolableHolder$$$outer() {
            return this.$outer;
        }

        public PoolableHolder(SingleThreadedAsyncObjectPool<T> $outer, T item) {
            this.item = item;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.time = System.currentTimeMillis();
        }
    }
}

