/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public final class ByteBufferUtils$ {
    public static ByteBufferUtils$ MODULE$;

    static {
        new ByteBufferUtils$();
    }

    public void writeLength(ByteBuf buffer) {
        int length = buffer.writerIndex() - 1;
        buffer.markWriterIndex();
        buffer.writerIndex(1);
        buffer.writeInt(length);
        buffer.resetWriterIndex();
    }

    public void writeCString(String content, ByteBuf b, Charset charset) {
        b.writeBytes(content.getBytes(charset));
        b.writeByte(0);
    }

    public void writeSizedString(String content, ByteBuf b, Charset charset) {
        byte[] bytes = content.getBytes(charset);
        b.writeByte(bytes.length);
        b.writeBytes(bytes);
    }

    public String readCString(ByteBuf b, Charset charset) {
        b.markReaderIndex();
        byte by = 0;
        int count = 0;
        do {
            by = b.readByte();
            ++count;
        } while (by != 0);
        b.resetReaderIndex();
        String result = b.toString(b.readerIndex(), count - 1, charset);
        b.readerIndex(b.readerIndex() + count);
        return result;
    }

    public String readUntilEOF(ByteBuf b, Charset charset) {
        if (b.readableBytes() == 0) {
            return "";
        }
        b.markReaderIndex();
        int n = -1;
        int count = 0;
        int offset = 1;
        while (n != 0) {
            if (b.readableBytes() > 0) {
                n = b.readByte();
                ++count;
                continue;
            }
            n = 0;
            offset = 0;
        }
        b.resetReaderIndex();
        String result = b.toString(b.readerIndex(), count - offset, charset);
        b.readerIndex(b.readerIndex() + count);
        return result;
    }

    public int read3BytesInt(ByteBuf b) {
        return b.readByte() & 0xFF | (b.readByte() & 0xFF) << 8 | (b.readByte() & 0xFF) << 16;
    }

    public void write3BytesInt(ByteBuf b, int value) {
        b.writeByte(value & 0xFF);
        b.writeByte(value >>> 8);
        b.writeByte(value >>> 16);
    }

    public void writePacketLength(ByteBuf buffer, int sequence) {
        int length = buffer.writerIndex() - 4;
        buffer.markWriterIndex();
        buffer.writerIndex(0);
        this.write3BytesInt(buffer, length);
        buffer.writeByte(sequence);
        buffer.resetWriterIndex();
    }

    public int writePacketLength$default$2() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf packetBuffer(int estimate) {
        void var2_2;
        ByteBuf buffer = this.mysqlBuffer(estimate);
        buffer.writeInt(0);
        return var2_2;
    }

    public int packetBuffer$default$1() {
        return 1024;
    }

    public ByteBuf mysqlBuffer(int estimate) {
        return Unpooled.buffer((int)estimate).order(ByteOrder.LITTLE_ENDIAN);
    }

    public int mysqlBuffer$default$1() {
        return 1024;
    }

    private ByteBufferUtils$() {
        MODULE$ = this;
    }
}

