/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.ResultSet;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.DatabaseException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.mysql.MySQLConnection$;
import com.github.mauricio.async.db.mysql.MySQLQueryResult;
import com.github.mauricio.async.db.mysql.MySQLQueryResult$;
import com.github.mauricio.async.db.mysql.codec.MySQLConnectionHandler;
import com.github.mauricio.async.db.mysql.codec.MySQLHandlerDelegate;
import com.github.mauricio.async.db.mysql.exceptions.MySQLException;
import com.github.mauricio.async.db.mysql.message.client.AuthenticationSwitchResponse;
import com.github.mauricio.async.db.mysql.message.client.HandshakeResponseMessage;
import com.github.mauricio.async.db.mysql.message.client.QueryMessage;
import com.github.mauricio.async.db.mysql.message.client.QuitMessage$;
import com.github.mauricio.async.db.mysql.message.server.AuthenticationSwitchRequest;
import com.github.mauricio.async.db.mysql.message.server.EOFMessage;
import com.github.mauricio.async.db.mysql.message.server.ErrorMessage;
import com.github.mauricio.async.db.mysql.message.server.HandshakeMessage;
import com.github.mauricio.async.db.mysql.message.server.OkMessage;
import com.github.mauricio.async.db.mysql.util.CharsetMapper;
import com.github.mauricio.async.db.pool.TimeoutScheduler;
import com.github.mauricio.async.db.util.ChannelFutureTransformer$;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\rq!B\u0001\u0003\u0011\u0003y\u0011aD'z'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!B7zgFd'BA\u0003\u0007\u0003\t!'M\u0003\u0002\b\u0011\u0005)\u0011m]=oG*\u0011\u0011BC\u0001\t[\u0006,(/[2j_*\u00111\u0002D\u0001\u0007O&$\b.\u001e2\u000b\u00035\t1aY8n\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011q\"T=T#2\u001buN\u001c8fGRLwN\\\n\u0003#Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0012\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u001dq\u0012C1A\u0005\u0006}\tqaQ8v]R,'/F\u0001!!\t\t#&D\u0001#\u0015\t\u0019C%\u0001\u0004bi>l\u0017n\u0019\u0006\u0003K\u0019\n!bY8oGV\u0014(/\u001a8u\u0015\t9\u0003&\u0001\u0003vi&d'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\t\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019i\u0013\u0003)A\u0007A\u0005A1i\\;oi\u0016\u0014\b\u0005C\u00040#\t\u0007IQ\u0001\u0019\u0002'5K7M]8tK\u000e|g\u000eZ:WKJ\u001c\u0018n\u001c8\u0016\u0003E\u0002\"A\r\u001b\u000e\u0003MR!a\n\u0003\n\u0005U\u001a$a\u0002,feNLwN\u001c\u0005\u0007oE\u0001\u000bQB\u0019\u0002)5K7M]8tK\u000e|g\u000eZ:WKJ\u001c\u0018n\u001c8!\u0011\u001dI\u0014C1A\u0005\u0006i\n1\u0001\\8h+\u0005Y\u0004C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u0010\u0002\u0007\u0019><w-\u001a:\t\r\u0011\u000b\u0002\u0015!\u0004<\u0003\u0011awn\u001a\u0011\t\u000f\u0019\u000b\u0012\u0013!C\u0001\u000f\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\u0012\u0001\u0013\u0016\u0003\u0013:\u0003\"A\u0013'\u000e\u0003-S!a\n\u0002\n\u00055[%!D\"iCJ\u001cX\r^'baB,'oK\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+A\u0005v]\u000eDWmY6fI*\u0011AKF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001,R\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b1F\t\n\u0011\"\u0001Z\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\t!L\u000b\u0002\\\u001dB\u0011AlY\u0007\u0002;*\u0011alX\u0001\bG\"\fgN\\3m\u0015\t\u0001\u0017-A\u0003oKR$\u0018PC\u0001c\u0003\tIw.\u0003\u0002e;\nqQI^3oi2{w\u000e]$s_V\u0004\bb\u00024\u0012#\u0003%\taZ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003!T#!\u001b(\u0011\u0005)dW\"A6\u000b\u0005\u00152\u0012BA7l\u0005A)\u00050Z2vi&|gnQ8oi\u0016DHO\u0002\u0003\u0013\u0005\u0001y7#\u00028\u0015aZT\bCA9u\u001b\u0005\u0011(BA:\u0003\u0003\u0015\u0019w\u000eZ3d\u0013\t)(O\u0001\u000bNsN\u000bF\nS1oI2,'\u000fR3mK\u001e\fG/\u001a\t\u0003obl\u0011\u0001B\u0005\u0003s\u0012\u0011!bQ8o]\u0016\u001cG/[8o!\tYh0D\u0001}\u0015\tiH!\u0001\u0003q_>d\u0017BA@}\u0005A!\u0016.\\3pkR\u001c6\r[3ek2,'\u000f\u0003\u0006\u0002\u00049\u0014\t\u0011)A\u0005\u0003\u000b\tQbY8oM&<WO]1uS>t\u0007cA<\u0002\b%\u0019\u0011\u0011\u0002\u0003\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011%\tiA\u001cB\u0001B\u0003%\u0011*A\u0007dQ\u0006\u00148/\u001a;NCB\u0004XM\u001d\u0005\n\u0003#q'\u0011!Q\u0001\nm\u000bQa\u001a:pkBD!\"!\u0006o\u0005\u000b\u0007I1AA\f\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001j\u0011%\tYB\u001cB\u0001B\u0003%\u0011.A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002Baa\u00078\u0005\u0002\u0005}ACCA\u0011\u0003G\t)#a\n\u0002*A\u0011\u0001C\u001c\u0005\t\u0003\u0007\ti\u00021\u0001\u0002\u0006!I\u0011QBA\u000f!\u0003\u0005\r!\u0013\u0005\n\u0003#\ti\u0002%AA\u0002mC\u0011\"!\u0006\u0002\u001eA\u0005\t9A5\t\u0013\u00055bN1A\u0005\u000e\u0005=\u0012aD2p]:,7\r^5p]\u000e{WO\u001c;\u0016\u0005\u0005E\u0002cA\u000b\u00024%\u0019\u0011Q\u0007\f\u0003\t1{gn\u001a\u0005\t\u0003sq\u0007\u0015!\u0004\u00022\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000f\t\u0005\n\u0003{q'\u0019!C\u0007\u0003\u007f\tAbY8o]\u0016\u001cG/[8o\u0013\u0012,\"!!\u0011\u0011\t\u0005\r\u0013\u0011\u000b\b\u0005\u0003\u000b\ni\u0005E\u0002\u0002HYi!!!\u0013\u000b\u0007\u0005-c\"\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001f2\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005U#AB*ue&twMC\u0002\u0002PYA\u0001\"!\u0017oA\u00035\u0011\u0011I\u0001\u000eG>tg.Z2uS>t\u0017\n\u001a\u0011\t\u0013\u0005ucN1A\u0005\u000e\u0005}\u0013!E2p]:,7\r^5p]\"\u000bg\u000e\u001a7feV\u0011\u0011\u0011\r\t\u0004c\u0006\r\u0014bAA3e\n1R*_*R\u0019\u000e{gN\\3di&|g\u000eS1oI2,'\u000f\u0003\u0005\u0002j9\u0004\u000bQBA1\u0003I\u0019wN\u001c8fGRLwN\u001c%b]\u0012dWM\u001d\u0011\t\u0013\u00055dN1A\u0005\u000e\u0005=\u0014!E2p]:,7\r^5p]B\u0013x.\\5tKV\u0011\u0011\u0011\u000f\t\u0005U\u0006Md/C\u0002\u0002v-\u0014q\u0001\u0015:p[&\u001cX\r\u0003\u0005\u0002z9\u0004\u000bQBA9\u0003I\u0019wN\u001c8fGRLwN\u001c)s_6L7/\u001a\u0011\t\u0013\u0005udN1A\u0005\u000e\u0005=\u0014\u0001\u00063jg\u000e|gN\\3di&|g\u000e\u0015:p[&\u001cX\r\u0003\u0005\u0002\u0002:\u0004\u000bQBA9\u0003U!\u0017n]2p]:,7\r^5p]B\u0013x.\\5tK\u0002B\u0011\"!\"o\u0005\u0004%I!a\"\u0002+E,XM]=Qe>l\u0017n]3SK\u001a,'/\u001a8dKV\u0011\u0011\u0011\u0012\t\u0006C\u0005-\u0015qR\u0005\u0004\u0003\u001b\u0013#aD!u_6L7MU3gKJ,gnY3\u0011\u000bU\t\t*!&\n\u0007\u0005MeC\u0001\u0004PaRLwN\u001c\t\u0006U\u0006M\u0014q\u0013\t\u0004o\u0006e\u0015bAAN\t\tY\u0011+^3ssJ+7/\u001e7u\u0011!\tyJ\u001cQ\u0001\n\u0005%\u0015AF9vKJL\bK]8nSN,'+\u001a4fe\u0016t7-\u001a\u0011\t\u0013\u0005\rf\u000e1A\u0005\n\u0005\u0015\u0016!C2p]:,7\r^3e+\t\t9\u000bE\u0002\u0016\u0003SK1!a+\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"a,o\u0001\u0004%I!!-\u0002\u001b\r|gN\\3di\u0016$w\fJ3r)\u0011\t\u0019,!/\u0011\u0007U\t),C\u0002\u00028Z\u0011A!\u00168ji\"Q\u00111XAW\u0003\u0003\u0005\r!a*\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002@:\u0004\u000b\u0015BAT\u0003)\u0019wN\u001c8fGR,G\r\t\u0005\n\u0003\u0007t\u0007\u0019!C\u0005\u0003\u000b\fab\u00187bgR,\u0005pY3qi&|g.\u0006\u0002\u0002HB!\u0011\u0011ZAj\u001d\u0011\tY-a4\u000f\t\u0005\u001d\u0013QZ\u0005\u0002/%\u0019\u0011\u0011\u001b\f\u0002\u000fA\f7m[1hK&!\u0011Q[Al\u0005%!\u0006N]8xC\ndWMC\u0002\u0002RZA\u0011\"a7o\u0001\u0004%I!!8\u0002%}c\u0017m\u001d;Fq\u000e,\u0007\u000f^5p]~#S-\u001d\u000b\u0005\u0003g\u000by\u000e\u0003\u0006\u0002<\u0006e\u0017\u0011!a\u0001\u0003\u000fD\u0001\"a9oA\u0003&\u0011qY\u0001\u0010?2\f7\u000f^#yG\u0016\u0004H/[8oA!A\u0011q\u001d8A\u0002\u0013%\u0001'A\u0007tKJ4XM\u001d,feNLwN\u001c\u0005\n\u0003Wt\u0007\u0019!C\u0005\u0003[\f\u0011c]3sm\u0016\u0014h+\u001a:tS>tw\fJ3r)\u0011\t\u0019,a<\t\u0013\u0005m\u0016\u0011^A\u0001\u0002\u0004\t\u0004bBAz]\u0002\u0006K!M\u0001\u000fg\u0016\u0014h/\u001a:WKJ\u001c\u0018n\u001c8!\u0011\u0019\t9P\u001cC\u0001a\u00059a/\u001a:tS>t\u0007bBA~]\u0012\u0005\u0011QY\u0001\u000eY\u0006\u001cH/\u0012=dKB$\u0018n\u001c8\t\u000f\u0005}h\u000e\"\u0001\u00020\u0005)1m\\;oi\"9!1\u00018\u0005B\t\u0015\u0011AD3wK:$Hj\\8q\u000fJ|W\u000f]\u000b\u00027\"9!\u0011\u00028\u0005\u0002\t-\u0011aB2p]:,7\r^\u000b\u0003\u0005\u001b\u0001BA\u001bB\bm&\u0019!\u0011C6\u0003\r\u0019+H/\u001e:f\u0011\u001d\u0011)B\u001cC\u0001\u0005\u0017\tQa\u00197pg\u0016Dq!a)o\t\u0003\u0012I\u0002\u0006\u0003\u00024\nm\u0001\u0002\u0003B\u000f\u0005/\u0001\rAa\b\u0002\u0007\r$\b\u0010E\u0002]\u0005CI1Aa\t^\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDqAa\no\t\u0003\u0012I#A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\u0011\t\u0019La\u000b\t\u0011\t5\"Q\u0005a\u0001\u0003\u000f\f\u0011\u0002\u001e5s_^\f'\r\\3\t\u000f\tEb\u000e\"\u0011\u00034\u00059qN\\#se>\u0014H\u0003BAZ\u0005kA\u0001Ba\u000e\u00030\u0001\u0007!\u0011H\u0001\b[\u0016\u001c8/Y4f!\u0011\u0011YDa\u0011\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\naa]3sm\u0016\u0014(b\u0001B\u001c\u0005%!!Q\tB\u001f\u00051)%O]8s\u001b\u0016\u001c8/Y4f\u0011\u001d\u0011IE\u001cC\u0005\u0005\u0017\nAb]3u\u000bb\u001cW\r\u001d;j_:$B!a-\u0003N!A!q\nB$\u0001\u0004\t9-A\u0001u\u0011\u001d\u0011\u0019F\u001cC!\u0005+\nAa\u001c8PWR!\u00111\u0017B,\u0011!\u00119D!\u0015A\u0002\te\u0003\u0003\u0002B\u001e\u00057JAA!\u0018\u0003>\tIqj['fgN\fw-\u001a\u0005\b\u0005CrG\u0011\u0001B2\u0003\u0015yg.R(G)\u0011\t\u0019L!\u001a\t\u0011\t]\"q\fa\u0001\u0005O\u0002BAa\u000f\u0003j%!!1\u000eB\u001f\u0005))uJR'fgN\fw-\u001a\u0005\b\u0005_rG\u0011\tB9\u0003-yg\u000eS1oIND\u0017m[3\u0015\t\u0005M&1\u000f\u0005\t\u0005o\u0011i\u00071\u0001\u0003vA!!1\bB<\u0013\u0011\u0011IH!\u0010\u0003!!\u000bg\u000eZ:iC.,W*Z:tC\u001e,\u0007b\u0002B?]\u0012\u0005#qP\u0001\u0015g^LGo\u00195BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0015\t\u0005M&\u0011\u0011\u0005\t\u0005o\u0011Y\b1\u0001\u0003\u0004B!!1\bBC\u0013\u0011\u00119I!\u0010\u00037\u0005+H\u000f[3oi&\u001c\u0017\r^5p]N;\u0018\u000e^2i%\u0016\fX/Z:u\u0011\u001d\u0011YI\u001cC\u0001\u0005\u001b\u000b\u0011b]3oIF+XM]=\u0015\t\t=%\u0011\u0013\t\u0006U\n=\u0011q\u0013\u0005\t\u0005'\u0013I\t1\u0001\u0002B\u0005)\u0011/^3ss\"9!q\u00138\u0005\n\te\u0015\u0001\u00054bS2\fV/\u001a:z!J|W.[:f)\u0011\t\u0019La'\t\u0011\t=#Q\u0013a\u0001\u0003\u000fDqAa(o\t\u0013\u0011\t+A\ntk\u000e\u001cW-\u001a3Rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX\r\u0006\u0003\u00024\n\r\u0006\u0002\u0003BS\u0005;\u0003\r!a&\u0002\u0017E,XM]=SKN,H\u000e\u001e\u0005\b\u0005SsG\u0011AAS\u0003)I7/U;fefLgn\u001a\u0005\b\u0005[sG\u0011\u0001BX\u0003-ygNU3tk2$8+\u001a;\u0015\r\u0005M&\u0011\u0017B^\u0011!\u0011\u0019La+A\u0002\tU\u0016!\u0003:fgVdGoU3u!\r9(qW\u0005\u0004\u0005s#!!\u0003*fgVdGoU3u\u0011!\u00119Da+A\u0002\t\u001d\u0004b\u0002B`]\u0012\u0005!1B\u0001\u000bI&\u001c8m\u001c8oK\u000e$\bb\u0002Bb]\u0012\u0005#QY\u0001\n_:$\u0016.\\3pkR,\"!a-\t\u000f\t%g\u000e\"\u0001\u0002&\u0006Y\u0011n]\"p]:,7\r^3e\u0011\u001d\u0011iM\u001cC\u0001\u0005\u001f\fQc]3oIB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0004\u0003\u0010\nE'1\u001b\u0005\t\u0005'\u0013Y\r1\u0001\u0002B!Q!Q\u001bBf!\u0003\u0005\rAa6\u0002\rY\fG.^3t!\u0019\tIM!7\u0003^&!!1\\Al\u0005\r\u0019V-\u001d\t\u0004+\t}\u0017b\u0001Bq-\t\u0019\u0011I\\=\t\u000f\t\u0015h\u000e\"\u0011\u0003h\u0006AAo\\*ue&tw\r\u0006\u0002\u0002B!9!1\u001e8\u0005\n\t5\u0018a\u0006<bY&$\u0017\r^3JgJ+\u0017\rZ=G_J\fV/\u001a:z)\t\t\u0019\fC\u0004\u0003r:$IAa=\u0002\u0019E,XM]=Qe>l\u0017n]3\u0016\u0005\u0005=\u0005b\u0002B|]\u0012%!\u0011`\u0001\u0010g\u0016$\u0018+^3ssB\u0013x.\\5tKR!\u00111\u0017B~\u0011!\u0011iP!>A\u0002\u0005U\u0015a\u00029s_6L7/\u001a\u0005\b\u0007\u0003qG\u0011\u0002Bz\u0003E\u0019G.Z1s#V,'/\u001f)s_6L7/\u001a")
public class MySQLConnection
implements MySQLHandlerDelegate,
Connection,
TimeoutScheduler {
    private final Configuration configuration;
    private final EventLoopGroup group;
    private final ExecutionContext executionContext;
    private final long connectionCount;
    private final String connectionId;
    private final MySQLConnectionHandler connectionHandler;
    private final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise;
    private final Promise<Connection> disconnectionPromise;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private boolean connected;
    private Throwable _lastException;
    private Version serverVersion;
    private AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;

    public static ExecutionContext $lessinit$greater$default$4() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static EventLoopGroup $lessinit$greater$default$3() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static CharsetMapper $lessinit$greater$default$2() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Logger log() {
        return MySQLConnection$.MODULE$.log();
    }

    public static Version MicrosecondsVersion() {
        return MySQLConnection$.MODULE$.MicrosecondsVersion();
    }

    public static AtomicLong Counter() {
        return MySQLConnection$.MODULE$.Counter();
    }

    public boolean isTimeouted() {
        return TimeoutScheduler.isTimeouted$((TimeoutScheduler)this);
    }

    public <A> Option<ScheduledFuture<?>> addTimeout(Promise<A> promise, Option<Duration> durationOption, ExecutionContext executionContext) {
        return TimeoutScheduler.addTimeout$((TimeoutScheduler)this, promise, durationOption, (ExecutionContext)executionContext);
    }

    public ScheduledFuture<?> schedule(Function0<BoxedUnit> block, Duration duration) {
        return TimeoutScheduler.schedule$((TimeoutScheduler)this, block, (Duration)duration);
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.inTransaction$((Connection)this, f, (ExecutionContext)executionContext);
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Connection.sendPreparedStatement$default$2$((Connection)this);
    }

    public AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool() {
        return this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;
    }

    public void com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool_$eq(AtomicBoolean x$1) {
        this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool = x$1;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private final long connectionCount() {
        return this.connectionCount;
    }

    private final String connectionId() {
        return this.connectionId;
    }

    private final MySQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    public final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise;
    }

    private final Promise<Connection> disconnectionPromise() {
        return this.disconnectionPromise;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean x$1) {
        this.connected = x$1;
    }

    private Throwable _lastException() {
        return this._lastException;
    }

    private void _lastException_$eq(Throwable x$1) {
        this._lastException = x$1;
    }

    private Version serverVersion() {
        return this.serverVersion;
    }

    private void serverVersion_$eq(Version x$1) {
        this.serverVersion = x$1;
    }

    public Version version() {
        return this.serverVersion();
    }

    public Throwable lastException() {
        return this._lastException();
    }

    public long count() {
        return this.connectionCount();
    }

    public EventLoopGroup eventLoopGroup() {
        return this.group;
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onFailure((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.executionContext());
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().future();
    }

    public Future<Connection> close() {
        block0: {
            if (!this.isConnected() || this.disconnectionPromise().isCompleted()) break block0;
            DatabaseException exception = new DatabaseException("Connection is being closed");
            exception.fillInStackTrace();
            this.failQueryPromise((Throwable)exception);
            this.connectionHandler().clearQueryState();
            ChannelFutureTransformer$.MODULE$.toFuture(this.connectionHandler().write(QuitMessage$.MODULE$.Instance())).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Object object;
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    ChannelFutureTransformer$.MODULE$.toFuture(this.connectionHandler().disconnect()).onComplete((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MySQLConnection.$anonfun$close$2(this, x0$2)), this.executionContext());
                    object = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    object = BoxesRunTime.boxToBoolean((boolean)this.disconnectionPromise().tryFailure(exception));
                } else {
                    throw new MatchError((Object)try_);
                }
                return object;
            }, this.executionContext());
        }
        return this.disconnectionPromise().future();
    }

    @Override
    public void connected(ChannelHandlerContext ctx) {
        MySQLConnection$.MODULE$.log().debug("Connected to {}", new Object[]{ctx.channel().remoteAddress()});
        this.connected_$eq(true);
    }

    @Override
    public void exceptionCaught(Throwable throwable) {
        MySQLConnection$.MODULE$.log().error("Transport failure ", throwable);
        this.setException(throwable);
    }

    @Override
    public void onError(ErrorMessage message) {
        MySQLConnection$.MODULE$.log().error("Received an error message -> {}", new Object[]{message});
        MySQLException exception = new MySQLException(message);
        exception.fillInStackTrace();
        this.setException((Throwable)((Object)exception));
    }

    private void setException(Throwable t) {
        this._lastException_$eq(t);
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().tryFailure(t);
        this.failQueryPromise(t);
    }

    @Override
    public void onOk(OkMessage message) {
        if (!this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().isCompleted()) {
            MySQLConnection$.MODULE$.log().debug("Connected to database");
            this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().success((Object)this);
        } else if (this.isQuerying()) {
            this.succeedQueryPromise(new MySQLQueryResult(message.affectedRows(), message.message(), message.lastInsertId(), message.statusFlags(), message.warnings(), MySQLQueryResult$.MODULE$.$lessinit$greater$default$6()));
        } else {
            MySQLConnection$.MODULE$.log().warn("Received OK when not querying or connecting, not sure what this is");
        }
    }

    @Override
    public void onEOF(EOFMessage message) {
        block0: {
            if (!this.isQuerying()) break block0;
            this.succeedQueryPromise(new MySQLQueryResult(0L, null, -1L, message.flags(), message.warningCount(), MySQLQueryResult$.MODULE$.$lessinit$greater$default$6()));
        }
    }

    @Override
    public void onHandshake(HandshakeMessage message) {
        this.serverVersion_$eq(Version$.MODULE$.apply(message.serverVersion()));
        String x$4 = this.configuration.username();
        Charset x$5 = this.configuration.charset();
        byte[] x$6 = message.seed();
        String x$7 = message.authenticationMethod();
        Option x$8 = this.configuration.database();
        Option x$9 = this.configuration.password();
        this.connectionHandler().write(new HandshakeResponseMessage(x$4, x$5, x$6, x$7, (Option<String>)x$9, (Option<String>)x$8));
    }

    @Override
    public void switchAuthentication(AuthenticationSwitchRequest message) {
        this.connectionHandler().write(new AuthenticationSwitchResponse((Option<String>)this.configuration.password(), message));
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateIsReadyForQuery();
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.connectionHandler().write(new QueryMessage(query));
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.tryFailure(t)));
    }

    private void succeedQueryPromise(QueryResult queryResult) {
        this.clearQueryPromise().foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.success((Object)queryResult));
    }

    public boolean isQuerying() {
        return this.queryPromise().isDefined();
    }

    @Override
    public void onResultSet(ResultSet resultSet, EOFMessage message) {
        block0: {
            if (!this.isQuerying()) break block0;
            this.succeedQueryPromise(new MySQLQueryResult(resultSet.size(), null, -1L, message.flags(), message.warningCount(), (Option<ResultSet>)new Some((Object)resultSet)));
        }
    }

    public Future<Connection> disconnect() {
        return this.close();
    }

    public void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        this.validateIsReadyForQuery();
        int totalParameters = new StringOps(Predef$.MODULE$.augmentString(query)).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MySQLConnection.$anonfun$sendPreparedStatement$1(BoxesRunTime.unboxToChar((Object)x$3))));
        if (values.length() != totalParameters) {
            throw new InsufficientParametersException(totalParameters, values);
        }
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.connectionHandler().sendPreparedStatement(query, values);
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("%s(%s,%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), this.connectionId(), BoxesRunTime.boxToLong((long)this.connectionCount())}));
    }

    private void validateIsReadyForQuery() {
        if (this.isQuerying()) {
            throw new ConnectionStillRunningQueryException(this.connectionCount(), false);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (!this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            throw new ConnectionStillRunningQueryException(this.connectionCount(), true);
        }
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$close$2(MySQLConnection $this, Try x0$2) {
        boolean bl;
        Try try_ = x0$2;
        if (try_ instanceof Success) {
            bl = $this.disconnectionPromise().trySuccess((Object)$this);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            bl = $this.disconnectionPromise().tryFailure(e);
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sendPreparedStatement$1(char x$3) {
        return x$3 == '?';
    }

    public MySQLConnection(Configuration configuration, CharsetMapper charsetMapper, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.group = group;
        this.executionContext = executionContext;
        Connection.$init$((Connection)this);
        TimeoutScheduler.$init$((TimeoutScheduler)this);
        charsetMapper.toInt(configuration.charset());
        this.connectionCount = MySQLConnection$.MODULE$.Counter().incrementAndGet();
        this.connectionId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[mysql-connection-", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.connectionCount())}));
        this.connectionHandler = new MySQLConnectionHandler(configuration, charsetMapper, this, group, executionContext, this.connectionId());
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise = Promise$.MODULE$.apply();
        this.disconnectionPromise = Promise$.MODULE$.apply();
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.connected = false;
        this._lastException = null;
        this.serverVersion = null;
    }
}

