/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql.codec;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.ResultSet;
import com.github.mauricio.async.db.exceptions.DatabaseException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.mysql.binary.BinaryRowDecoder;
import com.github.mauricio.async.db.mysql.codec.LittleEndianByteBufAllocator$;
import com.github.mauricio.async.db.mysql.codec.MySQLFrameDecoder;
import com.github.mauricio.async.db.mysql.codec.MySQLHandlerDelegate;
import com.github.mauricio.async.db.mysql.codec.MySQLOneToOneEncoder;
import com.github.mauricio.async.db.mysql.codec.PreparedStatement;
import com.github.mauricio.async.db.mysql.codec.PreparedStatementHolder;
import com.github.mauricio.async.db.mysql.codec.SendLongDataEncoder;
import com.github.mauricio.async.db.mysql.codec.SendLongDataEncoder$;
import com.github.mauricio.async.db.mysql.message.client.AuthenticationSwitchResponse;
import com.github.mauricio.async.db.mysql.message.client.HandshakeResponseMessage;
import com.github.mauricio.async.db.mysql.message.client.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.mysql.message.client.PreparedStatementPrepareMessage;
import com.github.mauricio.async.db.mysql.message.client.QueryMessage;
import com.github.mauricio.async.db.mysql.message.client.QuitMessage;
import com.github.mauricio.async.db.mysql.message.client.SendLongDataMessage;
import com.github.mauricio.async.db.mysql.message.server.AuthenticationSwitchRequest;
import com.github.mauricio.async.db.mysql.message.server.BinaryRowMessage;
import com.github.mauricio.async.db.mysql.message.server.ColumnDefinitionMessage;
import com.github.mauricio.async.db.mysql.message.server.EOFMessage;
import com.github.mauricio.async.db.mysql.message.server.ErrorMessage;
import com.github.mauricio.async.db.mysql.message.server.HandshakeMessage;
import com.github.mauricio.async.db.mysql.message.server.OkMessage;
import com.github.mauricio.async.db.mysql.message.server.PreparedStatementPrepareResponse;
import com.github.mauricio.async.db.mysql.message.server.ResultSetRowMessage;
import com.github.mauricio.async.db.mysql.message.server.ServerMessage;
import com.github.mauricio.async.db.mysql.util.CharsetMapper;
import com.github.mauricio.async.db.util.ChannelFutureTransformer$;
import com.github.mauricio.async.db.util.Log$;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.CodecException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r-d\u0001B\u0001\u0003\u0001E\u0011a#T=T#2\u001buN\u001c8fGRLwN\u001c%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\tQaY8eK\u000eT!!\u0002\u0004\u0002\u000b5L8/\u001d7\u000b\u0005\u001dA\u0011A\u00013c\u0015\tI!\"A\u0003bgft7M\u0003\u0002\f\u0019\u0005AQ.Y;sS\u000eLwN\u0003\u0002\u000e\u001d\u00051q-\u001b;ik\nT\u0011aD\u0001\u0004G>l7\u0001A\n\u0003\u0001I\u00012a\u0005\u000e\u001d\u001b\u0005!\"BA\u000b\u0017\u0003\u001d\u0019\u0007.\u00198oK2T!a\u0006\r\u0002\u000b9,G\u000f^=\u000b\u0003e\t!![8\n\u0005m!\"aG*j[BdWm\u00115b]:,G.\u00138c_VtG\rS1oI2,'\u000f\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\r=\u0013'.Z2u\u0011!)\u0003A!A!\u0002\u00131\u0013!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002(Q5\ta!\u0003\u0002*\r\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000eG\"\f'o]3u\u001b\u0006\u0004\b/\u001a:\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\"\u0011\u0001B;uS2L!!\r\u0018\u0003\u001b\rC\u0017M]:fi6\u000b\u0007\u000f]3s\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014a\u00045b]\u0012dWM\u001d#fY\u0016<\u0017\r^3\u0011\u0005U2T\"\u0001\u0002\n\u0005]\u0012!\u0001F'z'Fc\u0005*\u00198eY\u0016\u0014H)\u001a7fO\u0006$X\r\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003\u00159'o\\;q!\t\u00192(\u0003\u0002=)\tqQI^3oi2{w\u000e]$s_V\u0004\b\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002!\u0015DXmY;uS>t7i\u001c8uKb$\bC\u0001!F\u001b\u0005\t%B\u0001\"D\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\t\u0006)1oY1mC&\u0011a)\u0011\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRD\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!S\u0001\rG>tg.Z2uS>t\u0017\n\u001a\t\u0003\u0015Fs!aS(\u0011\u00051\u001bU\"A'\u000b\u00059\u0003\u0012A\u0002\u001fs_>$h(\u0003\u0002Q\u0007\u00061\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u00016\tC\u0003V\u0001\u0011\u0005a+\u0001\u0004=S:LGO\u0010\u000b\b/bK&l\u0017/^!\t)\u0004\u0001C\u0003&)\u0002\u0007a\u0005C\u0003,)\u0002\u0007A\u0006C\u00034)\u0002\u0007A\u0007C\u0003:)\u0002\u0007!\bC\u0003?)\u0002\u0007q\bC\u0003I)\u0002\u0007\u0011\nC\u0004`\u0001\t\u0007I1\u00021\u0002\u0019%tG/\u001a:oC2\u0004vn\u001c7\u0016\u0003}BaA\u0019\u0001!\u0002\u0013y\u0014!D5oi\u0016\u0014h.\u00197Q_>d\u0007\u0005C\u0004e\u0001\t\u0007IQB3\u0002\u00071|w-F\u0001g!\t9G.D\u0001i\u0015\tI'.A\u0003tY\u001a$$NC\u0001l\u0003\ry'oZ\u0005\u0003[\"\u0014a\u0001T8hO\u0016\u0014\bBB8\u0001A\u00035a-\u0001\u0003m_\u001e\u0004\u0003bB9\u0001\u0005\u0004%iA]\u0001\nE>|Go\u001d;sCB,\u0012a\u001d\t\u0003iZl\u0011!\u001e\u0006\u0003cZI!a^;\u0003\u0013\t{w\u000e^:ue\u0006\u0004\bBB=\u0001A\u000351/\u0001\u0006c_>$8\u000f\u001e:ba\u0002Bqa\u001f\u0001C\u0002\u00135A0A\td_:tWm\u0019;j_:\u0004&o\\7jg\u0016,\u0012! \t\u0004\u0001z<\u0016BA@B\u0005\u001d\u0001&o\\7jg\u0016Dq!a\u0001\u0001A\u00035Q0\u0001\nd_:tWm\u0019;j_:\u0004&o\\7jg\u0016\u0004\u0003\"CA\u0004\u0001\t\u0007IQBA\u0005\u0003\u001d!WmY8eKJ,\"!a\u0003\u0011\u0007U\ni!C\u0002\u0002\u0010\t\u0011\u0011#T=T#23%/Y7f\t\u0016\u001cw\u000eZ3s\u0011!\t\u0019\u0002\u0001Q\u0001\u000e\u0005-\u0011\u0001\u00033fG>$WM\u001d\u0011\t\u0013\u0005]\u0001A1A\u0005\u000e\u0005e\u0011aB3oG>$WM]\u000b\u0003\u00037\u00012!NA\u000f\u0013\r\tyB\u0001\u0002\u0015\u001bf\u001c\u0016\u000bT(oKR{wJ\\3F]\u000e|G-\u001a:\t\u0011\u0005\r\u0002\u0001)A\u0007\u00037\t\u0001\"\u001a8d_\u0012,'\u000f\t\u0005\n\u0003O\u0001!\u0019!C\u0007\u0003S\t1c]3oI2{gn\u001a#bi\u0006,enY8eKJ,\"!a\u000b\u0011\u0007U\ni#C\u0002\u00020\t\u00111cU3oI2{gn\u001a#bi\u0006,enY8eKJD\u0001\"a\r\u0001A\u00035\u00111F\u0001\u0015g\u0016tG\rT8oO\u0012\u000bG/Y#oG>$WM\u001d\u0011\t\u0013\u0005]\u0002A1A\u0005\u000e\u0005e\u0012!E2veJ,g\u000e\u001e)be\u0006lW\r^3sgV\u0011\u00111\b\t\u0007\u0003{\t9%a\u0013\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nq!\\;uC\ndWMC\u0002\u0002F\r\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI%a\u0010\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\u0019\u0019XM\u001d<fe*\u0019\u0011Q\u000b\u0003\u0002\u000f5,7o]1hK&!\u0011\u0011LA(\u0005]\u0019u\u000e\\;n]\u0012+g-\u001b8ji&|g.T3tg\u0006<W\r\u0003\u0005\u0002^\u0001\u0001\u000bQBA\u001e\u0003I\u0019WO\u001d:f]R\u0004\u0016M]1nKR,'o\u001d\u0011\t\u0013\u0005\u0005\u0004A1A\u0005\u000e\u0005e\u0012AD2veJ,g\u000e^\"pYVlgn\u001d\u0005\t\u0003K\u0002\u0001\u0015!\u0004\u0002<\u0005y1-\u001e:sK:$8i\u001c7v[:\u001c\b\u0005C\u0005\u0002j\u0001\u0011\r\u0011\"\u0004\u0002l\u0005\u0001\u0002/\u0019:tK\u0012\u001cF/\u0019;f[\u0016tGo]\u000b\u0003\u0003[\u0002r!!\u0010\u0002p%\u000b\u0019(\u0003\u0003\u0002r\u0005}\"a\u0002%bg\"l\u0015\r\u001d\t\u0004k\u0005U\u0014bAA<\u0005\t9\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;I_2$WM\u001d\u0005\t\u0003w\u0002\u0001\u0015!\u0004\u0002n\u0005\t\u0002/\u0019:tK\u0012\u001cF/\u0019;f[\u0016tGo\u001d\u0011\t\u0013\u0005}\u0004A1A\u0005\u000e\u0005\u0005\u0015\u0001\u00052j]\u0006\u0014\u0018PU8x\t\u0016\u001cw\u000eZ3s+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tI\tB\u0001\u0007E&t\u0017M]=\n\t\u00055\u0015q\u0011\u0002\u0011\u0005&t\u0017M]=S_^$UmY8eKJD\u0001\"!%\u0001A\u00035\u00111Q\u0001\u0012E&t\u0017M]=S_^$UmY8eKJ\u0004\u0003\"CAK\u0001\u0001\u0007I\u0011BAL\u0003y\u0019WO\u001d:f]R\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e%pY\u0012,'/\u0006\u0002\u0002t!I\u00111\u0014\u0001A\u0002\u0013%\u0011QT\u0001#GV\u0014(/\u001a8u!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bj\u001c7eKJ|F%Z9\u0015\t\u0005}\u0015q\u0015\t\u0005\u0003C\u000b\u0019+D\u0001D\u0013\r\t)k\u0011\u0002\u0005+:LG\u000f\u0003\u0006\u0002*\u0006e\u0015\u0011!a\u0001\u0003g\n1\u0001\u001f\u00132\u0011!\ti\u000b\u0001Q!\n\u0005M\u0014aH2veJ,g\u000e\u001e)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"{G\u000eZ3sA!I\u0011\u0011\u0017\u0001A\u0002\u0013%\u00111W\u0001\u0019GV\u0014(/\u001a8u!J,\u0007/\u0019:fIN#\u0018\r^3nK:$XCAA[!\r)\u0014qW\u0005\u0004\u0003s\u0013!!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"I\u0011Q\u0018\u0001A\u0002\u0013%\u0011qX\u0001\u001dGV\u0014(/\u001a8u!J,\u0007/\u0019:fIN#\u0018\r^3nK:$x\fJ3r)\u0011\ty*!1\t\u0015\u0005%\u00161XA\u0001\u0002\u0004\t)\f\u0003\u0005\u0002F\u0002\u0001\u000b\u0015BA[\u0003e\u0019WO\u001d:f]R\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0011\t\u0013\u0005%\u0007\u00011A\u0005\n\u0005-\u0017\u0001D2veJ,g\u000e^)vKJLXCAAg!\u0019\ty-!6\u0002L5\u0011\u0011\u0011\u001b\u0006\u0004\u0003'4\u0011aB4f]\u0016\u0014\u0018\r\\\u0005\u0005\u0003/\f\tN\u0001\tNkR\f'\r\\3SKN,H\u000e^*fi\"I\u00111\u001c\u0001A\u0002\u0013%\u0011Q\\\u0001\u0011GV\u0014(/\u001a8u#V,'/_0%KF$B!a(\u0002`\"Q\u0011\u0011VAm\u0003\u0003\u0005\r!!4\t\u0011\u0005\r\b\u0001)Q\u0005\u0003\u001b\fQbY;se\u0016tG/U;fef\u0004\u0003\"CAt\u0001\u0001\u0007I\u0011BAu\u00039\u0019WO\u001d:f]R\u001cuN\u001c;fqR,\"!a;\u0011\u0007M\ti/C\u0002\u0002pR\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0005\u0002t\u0002\u0001\r\u0011\"\u0003\u0002v\u0006\u00112-\u001e:sK:$8i\u001c8uKb$x\fJ3r)\u0011\ty*a>\t\u0015\u0005%\u0016\u0011_A\u0001\u0002\u0004\tY\u000f\u0003\u0005\u0002|\u0002\u0001\u000b\u0015BAv\u0003=\u0019WO\u001d:f]R\u001cuN\u001c;fqR\u0004\u0003bBA\u0000\u0001\u0011\u0005!\u0011A\u0001\bG>tg.Z2u+\t\u0011\u0019\u0001\u0005\u0003A\u0005\u000b9\u0016b\u0001B\u0004\u0003\n1a)\u001e;ve\u0016DqAa\u0003\u0001\t\u0003\u0012i!\u0001\u0007dQ\u0006tg.\u001a7SK\u0006$\u0007\u0007\u0006\u0004\u0002 \n=!1\u0003\u0005\t\u0005#\u0011I\u00011\u0001\u0002l\u0006\u00191\r\u001e=\t\u000f\u0005U#\u0011\u0002a\u00019!9!q\u0003\u0001\u0005B\te\u0011!D2iC:tW\r\\!di&4X\r\u0006\u0003\u0002 \nm\u0001\u0002\u0003B\t\u0005+\u0001\r!a;\t\u000f\t}\u0001\u0001\"\u0011\u0003\"\u0005y1\r[1o]\u0016d\u0017J\\1di&4X\r\u0006\u0003\u0002 \n\r\u0002\u0002\u0003B\t\u0005;\u0001\r!a;\t\u000f\t\u001d\u0002\u0001\"\u0011\u0003*\u0005yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u0002 \n-\"Q\u0006\u0005\t\u0005#\u0011)\u00031\u0001\u0002l\"A!q\u0006B\u0013\u0001\u0004\u0011\t$A\u0003dCV\u001cX\r\u0005\u0003\u00034\tub\u0002\u0002B\u001b\u0005sq1\u0001\u0014B\u001c\u0013\u0005!\u0015b\u0001B\u001e\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B \u0005\u0003\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\tm2\tC\u0004\u0003F\u0001!IAa\u0012\u0002\u001f!\fg\u000e\u001a7f\u000bb\u001cW\r\u001d;j_:$B!a(\u0003J!A!q\u0006B\"\u0001\u0004\u0011\t\u0004C\u0004\u0003N\u0001!\tEa\u0014\u0002\u0019!\fg\u000e\u001a7fe\u0006#G-\u001a3\u0015\t\u0005}%\u0011\u000b\u0005\t\u0005#\u0011Y\u00051\u0001\u0002l\"9!Q\u000b\u0001\u0005\u0002\t]\u0013!B<sSR,G\u0003\u0002B-\u0005?\u00022a\u0005B.\u0013\r\u0011i\u0006\u0006\u0002\u000e\u0007\"\fgN\\3m\rV$XO]3\t\u0011\u0005U#1\u000ba\u0001\u0005C\u0002BAa\u0019\u0003j5\u0011!Q\r\u0006\u0005\u0005O\n\u0019&\u0001\u0004dY&,g\u000e^\u0005\u0005\u0005W\u0012)G\u0001\u0007Rk\u0016\u0014\u00180T3tg\u0006<W\rC\u0004\u0003p\u0001!\tA!\u001d\u0002+M,g\u000e\u001a)sKB\f'/\u001a3Ti\u0006$X-\\3oiR1!1\u000fB;\u0005s\u0002R\u0001\u0011B\u0003\u00053BqAa\u001e\u0003n\u0001\u0007\u0011*A\u0003rk\u0016\u0014\u0018\u0010\u0003\u0005\u0003|\t5\u0004\u0019\u0001B?\u0003\u00191\u0018\r\\;fgB1!1\u0007B@\u0005\u0007KAA!!\u0003B\t\u00191+Z9\u0011\t\u0005\u0005&QQ\u0005\u0004\u0005\u000f\u001b%aA!os\"9!Q\u000b\u0001\u0005\u0002\t-E\u0003\u0002B-\u0005\u001bC\u0001\"!\u0016\u0003\n\u0002\u0007!q\u0012\t\u0005\u0005G\u0012\t*\u0003\u0003\u0003\u0014\n\u0015$\u0001\u0007%b]\u0012\u001c\b.Y6f%\u0016\u001c\bo\u001c8tK6+7o]1hK\"9!Q\u000b\u0001\u0005\u0002\t]E\u0003\u0002B-\u00053C\u0001\"!\u0016\u0003\u0016\u0002\u0007!1\u0014\t\u0005\u0005G\u0012i*\u0003\u0003\u0003 \n\u0015$\u0001H!vi\",g\u000e^5dCRLwN\\*xSR\u001c\u0007NU3ta>t7/\u001a\u0005\b\u0005+\u0002A\u0011\u0001BR)\u0011\u0011IF!*\t\u0011\u0005U#\u0011\u0015a\u0001\u0005O\u0003BAa\u0019\u0003*&!!1\u0016B3\u0005-\tV/\u001b;NKN\u001c\u0018mZ3\t\u000f\t=\u0006\u0001\"\u0001\u00032\u0006QA-[:d_:tWm\u0019;\u0016\u0005\te\u0003b\u0002B[\u0001\u0011\u0005!qW\u0001\u0010G2,\u0017M])vKJL8\u000b^1uKV\u0011\u0011q\u0014\u0005\b\u0005w\u0003A\u0011\u0001B_\u0003-I7oQ8o]\u0016\u001cG/\u001a3\u0016\u0005\t}\u0006\u0003BAQ\u0005\u0003L1Aa1D\u0005\u001d\u0011un\u001c7fC:DqAa2\u0001\t\u0013\u0011I-\u0001\rfq\u0016\u001cW\u000f^3Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R$\"Ba\u001d\u0003L\nm'Q\u001dBt\u0011!\u0011iM!2A\u0002\t=\u0017aC:uCR,W.\u001a8u\u0013\u0012\u0004b!!)\u0003R\nU\u0017b\u0001Bj\u0007\n)\u0011I\u001d:bsB!\u0011\u0011\u0015Bl\u0013\r\u0011In\u0011\u0002\u0005\u0005f$X\r\u0003\u0005\u0003^\n\u0015\u0007\u0019\u0001Bp\u00031\u0019w\u000e\\;n]N\u001cu.\u001e8u!\u0011\t\tK!9\n\u0007\t\r8IA\u0002J]RD\u0001Ba\u001f\u0003F\u0002\u0007!Q\u0010\u0005\t\u0005S\u0014)\r1\u0001\u0003l\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\r\tM\"qPA&\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005c\fa![:M_:<G\u0003\u0002B`\u0005gD\u0001B!>\u0003n\u0002\u0007!1Q\u0001\u0006m\u0006dW/\u001a\u0005\b\u0005s\u0004A\u0011\u0002B~\u0003E\u0019XM\u001c3M_:<\u0007+\u0019:b[\u0016$XM\u001d\u000b\t\u0005g\u0012iPa@\u0004\u0004!A!Q\u001aB|\u0001\u0004\u0011y\r\u0003\u0005\u0004\u0002\t]\b\u0019\u0001Bp\u0003\u0015Ig\u000eZ3y\u0011!\u0019)Aa>A\u0002\t\r\u0015!\u00037p]\u001e4\u0016\r\\;f\u0011\u001d\u0019I\u0001\u0001C\u0005\u0007\u0017\t!b]3oI\n+hMZ3s)!\u0011If!\u0004\u0004\u001c\ru\u0001\u0002CB\b\u0007\u000f\u0001\ra!\u0005\u0002\r\t,hMZ3s!\u0011\u0019\u0019ba\u0006\u000e\u0005\rU!bAB\b-%!1\u0011DB\u000b\u0005\u001d\u0011\u0015\u0010^3Ck\u001aD\u0001B!4\u0004\b\u0001\u0007!q\u001a\u0005\t\u0007?\u00199\u00011\u0001\u0003`\u00069\u0001/\u0019:b[&#\u0007bBB\u0012\u0001\u0011%1QE\u0001#_:\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e)sKB\f'/\u001a*fgB|gn]3\u0015\t\u0005}5q\u0005\u0005\t\u0003+\u001a\t\u00031\u0001\u0004*A!\u0011QJB\u0016\u0013\u0011\u0019i#a\u0014\u0003AA\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\u0015:fa\u0006\u0014XMU3ta>t7/\u001a\u0005\b\u0007c\u0001A\u0011AB\u001a\u0003iygnQ8mk6tG)\u001a4j]&$\u0018n\u001c8GS:L7\u000f[3e)\t\ty\nC\u0004\u00048\u0001!Ia!\u000f\u0002']\u0014\u0018\u000e^3B]\u0012D\u0015M\u001c3mK\u0016\u0013(o\u001c:\u0015\t\te31\b\u0005\t\u0003+\u001a)\u00041\u0001\u0003\u0004\"91q\b\u0001\u0005\n\r\u0005\u0013!\u00035b]\u0012dW-R(G)\u0011\tyja\u0011\t\u0011\r\u00153Q\ba\u0001\u0007\u000f\n\u0011!\u001c\t\u0005\u0003\u001b\u001aI%\u0003\u0003\u0004L\u0005=#!D*feZ,'/T3tg\u0006<W\rC\u0004\u0004P\u0001!\ta!\u0015\u0002\u0011M\u001c\u0007.\u001a3vY\u0016$b!a(\u0004T\ru\u0003\"CB+\u0007\u001b\"\t\u0019AB,\u0003\u0015\u0011Gn\\2l!\u0019\t\tk!\u0017\u0002 &\u001911L\"\u0003\u0011q\u0012\u0017P\\1nKzB\u0001ba\u0018\u0004N\u0001\u00071\u0011M\u0001\tIV\u0014\u0018\r^5p]B!11MB4\u001b\t\u0019)GC\u0002\u0004`\u0005KAa!\u001b\u0004f\tAA)\u001e:bi&|g\u000e")
public class MySQLConnectionHandler
extends SimpleChannelInboundHandler<Object> {
    private final Configuration configuration;
    private final MySQLHandlerDelegate handlerDelegate;
    private final ExecutionContext internalPool;
    private final Logger log;
    private final Bootstrap bootstrap;
    private final Promise<MySQLConnectionHandler> com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise;
    private final MySQLFrameDecoder com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder;
    private final MySQLOneToOneEncoder com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$encoder;
    private final SendLongDataEncoder com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$sendLongDataEncoder;
    private final ArrayBuffer<ColumnDefinitionMessage> currentParameters;
    private final ArrayBuffer<ColumnDefinitionMessage> currentColumns;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private final BinaryRowDecoder binaryRowDecoder;
    private PreparedStatementHolder currentPreparedStatementHolder;
    private PreparedStatement currentPreparedStatement;
    private MutableResultSet<ColumnDefinitionMessage> currentQuery;
    private ChannelHandlerContext currentContext;

    private ExecutionContext internalPool() {
        return this.internalPool;
    }

    private final Logger log() {
        return this.log;
    }

    private final Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public final Promise<MySQLConnectionHandler> com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise() {
        return this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise;
    }

    public final MySQLFrameDecoder com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder() {
        return this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder;
    }

    public final MySQLOneToOneEncoder com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$encoder() {
        return this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$encoder;
    }

    public final SendLongDataEncoder com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$sendLongDataEncoder() {
        return this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$sendLongDataEncoder;
    }

    private final ArrayBuffer<ColumnDefinitionMessage> currentParameters() {
        return this.currentParameters;
    }

    private final ArrayBuffer<ColumnDefinitionMessage> currentColumns() {
        return this.currentColumns;
    }

    private final HashMap<String, PreparedStatementHolder> parsedStatements() {
        return this.parsedStatements;
    }

    private final BinaryRowDecoder binaryRowDecoder() {
        return this.binaryRowDecoder;
    }

    private PreparedStatementHolder currentPreparedStatementHolder() {
        return this.currentPreparedStatementHolder;
    }

    private void currentPreparedStatementHolder_$eq(PreparedStatementHolder x$1) {
        this.currentPreparedStatementHolder = x$1;
    }

    private PreparedStatement currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(PreparedStatement x$1) {
        this.currentPreparedStatement = x$1;
    }

    private MutableResultSet<ColumnDefinitionMessage> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(MutableResultSet<ColumnDefinitionMessage> x$1) {
        this.currentQuery = x$1;
    }

    private ChannelHandlerContext currentContext() {
        return this.currentContext;
    }

    private void currentContext_$eq(ChannelHandlerContext x$1) {
        this.currentContext = x$1;
    }

    public Future<MySQLConnectionHandler> connect() {
        this.bootstrap().channel(NioSocketChannel.class);
        this.bootstrap().handler((ChannelHandler)new ChannelInitializer<Channel>(this){
            private final /* synthetic */ MySQLConnectionHandler $outer;

            public void initChannel(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{this.$outer.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder(), this.$outer.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$encoder(), this.$outer.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$sendLongDataEncoder(), this.$outer});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.bootstrap().option(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(true));
        this.bootstrap().option(ChannelOption.ALLOCATOR, (Object)LittleEndianByteBufAllocator$.MODULE$.INSTANCE());
        ChannelFutureTransformer$.MODULE$.toFuture(this.bootstrap().connect((SocketAddress)new InetSocketAddress(this.configuration.host(), this.configuration.port()))).onFailure((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLConnectionHandler $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.internalPool());
        return this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise().future();
    }

    public void channelRead0(ChannelHandlerContext ctx, Object message) {
        BoxedUnit boxedUnit;
        Object object = message;
        if (object instanceof ServerMessage) {
            ServerMessage serverMessage = (ServerMessage)object;
            int n = serverMessage.kind();
            switch (n) {
                case 10: {
                    this.handlerDelegate.onHandshake((HandshakeMessage)serverMessage);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 0: {
                    this.clearQueryState();
                    this.handlerDelegate.onOk((OkMessage)serverMessage);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case -1: {
                    this.clearQueryState();
                    this.handlerDelegate.onError((ErrorMessage)serverMessage);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case -2: {
                    this.handleEOF(serverMessage);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 100: {
                    ColumnDefinitionMessage message2 = (ColumnDefinitionMessage)serverMessage;
                    if (this.currentPreparedStatementHolder() != null && this.currentPreparedStatementHolder().needsAny()) {
                        this.currentPreparedStatementHolder().add(message2);
                    }
                    this.currentColumns().$plus$eq((Object)message2);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 101: {
                    this.onColumnDefinitionFinished();
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 106: {
                    this.onPreparedStatementPrepareResponse((PreparedStatementPrepareResponse)serverMessage);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 104: {
                    ResultSetRowMessage message3 = (ResultSetRowMessage)serverMessage;
                    Object[] items = new Object[message3.size()];
                    for (int x = 0; x < message3.size(); ++x) {
                        Object object2;
                        if (message3.apply(x) == null) {
                            object2 = null;
                        } else {
                            ColumnDefinitionMessage columnDescription = (ColumnDefinitionMessage)this.currentQuery().columnTypes().apply(x);
                            object2 = columnDescription.textDecoder().decode((ColumnData)columnDescription, message3.apply(x), this.configuration.charset());
                        }
                        items[x] = object2;
                    }
                    this.currentQuery().addRow(items);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 105: {
                    BinaryRowMessage message4 = (BinaryRowMessage)serverMessage;
                    this.currentQuery().addRow(this.binaryRowDecoder().decode(message4.buffer(), (Seq<ColumnDefinitionMessage>)this.currentColumns()));
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 102: {
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 103: {
                    this.onColumnDefinitionFinished();
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        } else {
            throw new MatchError(object);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log().debug("Channel became active");
        this.handlerDelegate.connected(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.log().debug("Channel became inactive");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Throwable throwable = cause;
        if (throwable instanceof CodecException) {
            CodecException codecException = (CodecException)throwable;
            this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$handleException(codecException.getCause());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$handleException(cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$handleException(Throwable cause) {
        Object object = !this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise().isCompleted() ? this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise().failure(cause) : BoxedUnit.UNIT;
        this.handlerDelegate.exceptionCaught(cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.currentContext_$eq(ctx);
    }

    public ChannelFuture write(QueryMessage message) {
        this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder().queryProcessStarted();
        return this.writeAndHandleError(message);
    }

    public Future<ChannelFuture> sendPreparedStatement(String query, Seq<Object> values) {
        Future<ChannelFuture> future;
        PreparedStatement preparedStatement = new PreparedStatement(query, values);
        this.currentColumns().clear();
        this.currentParameters().clear();
        this.currentPreparedStatement_$eq(preparedStatement);
        Option option = this.parsedStatements().get((Object)preparedStatement.statement());
        if (option instanceof Some) {
            Some some = (Some)option;
            PreparedStatementHolder item = (PreparedStatementHolder)some.value();
            future = this.executePreparedStatement(item.statementId(), item.columns().size(), preparedStatement.values(), (Seq<ColumnDefinitionMessage>)item.parameters());
        } else if (None$.MODULE$.equals(option)) {
            this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder().preparedStatementPrepareStarted();
            future = ChannelFutureTransformer$.MODULE$.toFuture(this.writeAndHandleError(new PreparedStatementPrepareMessage(preparedStatement.statement())));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public ChannelFuture write(HandshakeResponseMessage message) {
        this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder().hasDoneHandshake_$eq(true);
        return this.writeAndHandleError(message);
    }

    public ChannelFuture write(AuthenticationSwitchResponse message) {
        return this.writeAndHandleError(message);
    }

    public ChannelFuture write(QuitMessage message) {
        return this.writeAndHandleError(message);
    }

    public ChannelFuture disconnect() {
        return this.currentContext().close();
    }

    public void clearQueryState() {
        this.currentColumns().clear();
        this.currentParameters().clear();
        this.currentQuery_$eq(null);
    }

    public boolean isConnected() {
        return this.currentContext() != null && this.currentContext().channel() != null ? this.currentContext().channel().isActive() : false;
    }

    private Future<ChannelFuture> executePreparedStatement(byte[] statementId, int columnsCount, Seq<Object> values, Seq<ColumnDefinitionMessage> parameters) {
        Future future;
        this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder().preparedStatementExecuteStarted(columnsCount, parameters.size());
        this.currentColumns().clear();
        this.currentParameters().clear();
        Tuple2 tuple2 = ((GenericTraversableTemplate)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Some some;
                Object value;
                Object object = tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (object instanceof Some && this.isLong(value = (some = (Some)object).value())) {
                    return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), value)));
                }
            }
            if (tuple2 != null) {
                Object value = tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (this.isLong(value)) {
                    return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), value)));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int index = tuple2._2$mcI$sp();
            return new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)index)), (Object)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq nonLongIndicesOpt = (Seq)tuple2._1();
        Seq longValuesOpt = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nonLongIndicesOpt, (Object)longValuesOpt);
        Tuple2 tuple23 = tuple22;
        Seq nonLongIndicesOpt2 = (Seq)tuple23._1();
        Seq longValuesOpt2 = (Seq)tuple23._2();
        Seq nonLongIndices = (Seq)nonLongIndicesOpt2.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        Seq longValues = (Seq)longValuesOpt2.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        if (longValues.nonEmpty()) {
            Tuple2 tuple24 = (Tuple2)longValues.head();
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            int firstIndex = tuple24._1$mcI$sp();
            Object firstValue = tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)firstIndex), firstValue);
            Tuple2 tuple26 = tuple25;
            int firstIndex2 = tuple26._1$mcI$sp();
            Object firstValue2 = tuple26._2();
            ObjectRef channelFuture = ObjectRef.create(this.sendLongParameter(statementId, firstIndex2, firstValue2));
            ((IterableLike)longValues.tail()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                MySQLConnectionHandler.$anonfun$executePreparedStatement$4(this, statementId, channelFuture, x0$2);
                return BoxedUnit.UNIT;
            });
            future = ((Future)channelFuture.elem).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> ChannelFutureTransformer$.MODULE$.toFuture(this.writeAndHandleError(new PreparedStatementExecuteMessage(statementId, values, (Set<Object>)nonLongIndices.toSet(), parameters))), this.internalPool());
        } else {
            future = ChannelFutureTransformer$.MODULE$.toFuture(this.writeAndHandleError(new PreparedStatementExecuteMessage(statementId, values, (Set<Object>)nonLongIndices.toSet(), parameters)));
        }
        return future;
    }

    private boolean isLong(Object value) {
        ByteBuf byteBuf;
        ByteBuffer byteBuffer;
        byte[] byArray;
        Object object = value;
        boolean bl = object instanceof byte[] ? (byArray = (byte[])object).length > SendLongDataEncoder$.MODULE$.LONG_THRESHOLD() : (object instanceof ByteBuffer ? (byteBuffer = (ByteBuffer)object).remaining() > SendLongDataEncoder$.MODULE$.LONG_THRESHOLD() : (object instanceof ByteBuf ? (byteBuf = (ByteBuf)object).readableBytes() > SendLongDataEncoder$.MODULE$.LONG_THRESHOLD() : false));
        return bl;
    }

    private Future<ChannelFuture> sendLongParameter(byte[] statementId, int index, Object longValue) {
        Future future;
        Object object = longValue;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            future = ChannelFutureTransformer$.MODULE$.toFuture(this.sendBuffer(Unpooled.wrappedBuffer((byte[])byArray), statementId, index));
        } else if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            future = ChannelFutureTransformer$.MODULE$.toFuture(this.sendBuffer(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer), statementId, index));
        } else if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            future = ChannelFutureTransformer$.MODULE$.toFuture(this.sendBuffer(byteBuf, statementId, index));
        } else {
            throw new MatchError(object);
        }
        return future;
    }

    private ChannelFuture sendBuffer(ByteBuf buffer, byte[] statementId, int paramId) {
        return this.writeAndHandleError(new SendLongDataMessage(statementId, buffer, paramId));
    }

    private void onPreparedStatementPrepareResponse(PreparedStatementPrepareResponse message) {
        this.currentPreparedStatementHolder_$eq(new PreparedStatementHolder(this.currentPreparedStatement().statement(), message));
    }

    public void onColumnDefinitionFinished() {
        block0: {
            ArrayBuffer<ColumnDefinitionMessage> columns = this.currentPreparedStatementHolder() != null ? this.currentPreparedStatementHolder().columns() : this.currentColumns();
            this.currentQuery_$eq((MutableResultSet<ColumnDefinitionMessage>)new MutableResultSet(columns));
            if (this.currentPreparedStatementHolder() == null) break block0;
            this.parsedStatements().put((Object)this.currentPreparedStatementHolder().statement(), (Object)this.currentPreparedStatementHolder());
            this.executePreparedStatement(this.currentPreparedStatementHolder().statementId(), this.currentPreparedStatementHolder().columns().size(), this.currentPreparedStatement().values(), (Seq<ColumnDefinitionMessage>)this.currentPreparedStatementHolder().parameters());
            this.currentPreparedStatementHolder_$eq(null);
            this.currentPreparedStatement_$eq(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture writeAndHandleError(Object message) {
        ChannelFuture channelFuture;
        if (this.currentContext().channel().isActive()) {
            void var2_2;
            ChannelFuture res = this.currentContext().writeAndFlush(message);
            ChannelFutureTransformer$.MODULE$.toFuture(res).onFailure((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MySQLConnectionHandler $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 != null) {
                        A1 A12 = A1;
                        this.$outer.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$handleException(A12);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable != null;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.internalPool());
            channelFuture = var2_2;
        } else {
            DatabaseException error = new DatabaseException("This channel is not active and can't take messages");
            this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$handleException((Throwable)error);
            channelFuture = this.currentContext().channel().newFailedFuture((Throwable)error);
        }
        return channelFuture;
    }

    private void handleEOF(ServerMessage m) {
        ServerMessage serverMessage = m;
        if (serverMessage instanceof EOFMessage) {
            BoxedUnit boxedUnit;
            EOFMessage eOFMessage = (EOFMessage)serverMessage;
            MutableResultSet<ColumnDefinitionMessage> resultSet = this.currentQuery();
            this.clearQueryState();
            if (resultSet != null) {
                this.handlerDelegate.onResultSet((ResultSet)resultSet, eOFMessage);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.handlerDelegate.onEOF(eOFMessage);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (serverMessage instanceof AuthenticationSwitchRequest) {
            AuthenticationSwitchRequest authenticationSwitchRequest = (AuthenticationSwitchRequest)serverMessage;
            this.handlerDelegate.switchAuthentication(authenticationSwitchRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)serverMessage);
        }
    }

    public void schedule(Function0<BoxedUnit> block, Duration duration) {
        this.currentContext().channel().eventLoop().schedule(new Runnable(null, block){
            private final Function0 block$1;

            public void run() {
                this.block$1.apply$mcV$sp();
            }
            {
                this.block$1 = block$1;
            }
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ void $anonfun$executePreparedStatement$4(MySQLConnectionHandler $this, byte[] statementId$1, ObjectRef channelFuture$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int index = tuple2._1$mcI$sp();
        Object value = tuple2._2();
        channelFuture$1.elem = ((Future)channelFuture$1.elem).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> $this.sendLongParameter(statementId$1, index, value), $this.internalPool());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MySQLConnectionHandler(Configuration configuration, CharsetMapper charsetMapper, MySQLHandlerDelegate handlerDelegate, EventLoopGroup group, ExecutionContext executionContext, String connectionId) {
        this.configuration = configuration;
        this.handlerDelegate = handlerDelegate;
        this.internalPool = executionContext;
        this.log = Log$.MODULE$.getByName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[connection-handler]", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionId})));
        this.bootstrap = (Bootstrap)new Bootstrap().group(group);
        this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$connectionPromise = Promise$.MODULE$.apply();
        this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$decoder = new MySQLFrameDecoder(configuration.charset(), connectionId);
        this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$encoder = new MySQLOneToOneEncoder(configuration.charset(), charsetMapper);
        this.com$github$mauricio$async$db$mysql$codec$MySQLConnectionHandler$$sendLongDataEncoder = new SendLongDataEncoder();
        this.currentParameters = new ArrayBuffer();
        this.currentColumns = new ArrayBuffer();
        this.parsedStatements = new HashMap();
        this.binaryRowDecoder = new BinaryRowDecoder();
        this.currentPreparedStatementHolder = null;
        this.currentPreparedStatement = null;
        this.currentQuery = null;
        this.currentContext = null;
    }
}

