/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql.encoder;

import com.github.mauricio.async.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.mauricio.async.db.mysql.encoder.HandshakeResponseEncoder$;
import com.github.mauricio.async.db.mysql.encoder.MessageEncoder;
import com.github.mauricio.async.db.mysql.encoder.auth.AuthenticationMethod;
import com.github.mauricio.async.db.mysql.encoder.auth.AuthenticationMethod$;
import com.github.mauricio.async.db.mysql.message.client.ClientMessage;
import com.github.mauricio.async.db.mysql.message.client.HandshakeResponseMessage;
import com.github.mauricio.async.db.mysql.util.CharsetMapper;
import com.github.mauricio.async.db.util.ByteBufferUtils$;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Uq!B\u0001\u0003\u0011\u0003\t\u0012\u0001\u0007%b]\u0012\u001c\b.Y6f%\u0016\u001c\bo\u001c8tK\u0016s7m\u001c3fe*\u00111\u0001B\u0001\bK:\u001cw\u000eZ3s\u0015\t)a!A\u0003nsN\fHN\u0003\u0002\b\u0011\u0005\u0011AM\u0019\u0006\u0003\u0013)\tQ!Y:z]\u000eT!a\u0003\u0007\u0002\u00115\fWO]5dS>T!!\u0004\b\u0002\r\u001dLG\u000f[;c\u0015\u0005y\u0011aA2p[\u000e\u0001\u0001C\u0001\n\u0014\u001b\u0005\u0011a!\u0002\u000b\u0003\u0011\u0003)\"\u0001\u0007%b]\u0012\u001c\b.Y6f%\u0016\u001c\bo\u001c8tK\u0016s7m\u001c3feN\u00111C\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000bu\u0019B\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005\t\u0002b\u0002\u0011\u0014\u0005\u0004%)!I\u0001\f\u001b\u0006CvlM0C3R+5+F\u0001#\u001f\u0005\u0019S\u0004\u0002\u0001\u0000\u0000\u0000Ha!J\n!\u0002\u001b\u0011\u0013\u0001D'B1~\u001btLQ-U\u000bN\u0003\u0003bB\u0014\u0014\u0005\u0004%)\u0001K\u0001\b!\u0006#E)\u0013(H+\u0005I\u0003cA\f+Y%\u00111\u0006\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003/5J!A\f\r\u0003\t\tKH/\u001a\u0005\u0007aM\u0001\u000bQB\u0015\u0002\u0011A\u000bE\tR%O\u000f\u0002BqAM\nC\u0002\u0013\u00151'A\u0002m_\u001e,\u0012\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\nQa\u001d7gi)T\u0011!O\u0001\u0004_J<\u0017BA\u001e7\u0005\u0019aunZ4fe\"1Qh\u0005Q\u0001\u000eQ\nA\u0001\\8hA\u0019!AC\u0001\u0001@'\rqd\u0003\u0011\t\u0003%\u0005K!A\u0011\u0002\u0003\u001d5+7o]1hK\u0016s7m\u001c3fe\"AAI\u0010B\u0001B\u0003%Q)A\u0004dQ\u0006\u00148/\u001a;\u0011\u0005\u0019cU\"A$\u000b\u0005\u0011C%BA%K\u0003\rq\u0017n\u001c\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\tiuIA\u0004DQ\u0006\u00148/\u001a;\t\u0011=s$\u0011!Q\u0001\nA\u000bQb\u00195beN,G/T1qa\u0016\u0014\bCA)U\u001b\u0005\u0011&BA*\u0005\u0003\u0011)H/\u001b7\n\u0005U\u0013&!D\"iCJ\u001cX\r^'baB,'\u000fC\u0003\u001e}\u0011\u0005q\u000bF\u0002Y3j\u0003\"A\u0005 \t\u000b\u00113\u0006\u0019A#\t\u000b=3\u0006\u0019\u0001)\t\u000fqs$\u0019!C\u0005;\u0006)\u0012-\u001e;iK:$\u0018nY1uS>tW*\u001a;i_\u0012\u001cX#\u00010\u0011\t}#g\r\\\u0007\u0002A*\u0011\u0011MY\u0001\nS6lW\u000f^1cY\u0016T!a\u0019\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fA\n\u0019Q*\u00199\u0011\u0005\u001dTW\"\u00015\u000b\u0005%T\u0015\u0001\u00027b]\u001eL!a\u001b5\u0003\rM#(/\u001b8h!\ti\u0007/D\u0001o\u0015\ty'!\u0001\u0003bkRD\u0017BA9o\u0005Q\tU\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e5pI\"11O\u0010Q\u0001\ny\u000ba#Y;uQ\u0016tG/[2bi&|g.T3uQ>$7\u000f\t\u0005\u0006kz\"\tA^\u0001\u0007K:\u001cw\u000eZ3\u0015\u0007]\f\u0019\u0001\u0005\u0002y\u007f6\t\u0011P\u0003\u0002{w\u00061!-\u001e4gKJT!\u0001`?\u0002\u000b9,G\u000f^=\u000b\u0003y\f!![8\n\u0007\u0005\u0005\u0011PA\u0004CsR,')\u001e4\t\u000f\u0005\u0015A\u000f1\u0001\u0002\b\u00059Q.Z:tC\u001e,\u0007\u0003BA\u0005\u0003#i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0007G2LWM\u001c;\u000b\u0007\u0005\u0015A!\u0003\u0003\u0002\u0014\u0005-!!D\"mS\u0016tG/T3tg\u0006<W\r")
public class HandshakeResponseEncoder
implements MessageEncoder {
    private final Charset charset;
    private final CharsetMapper charsetMapper;
    private final Map<String, AuthenticationMethod> authenticationMethods;

    public static Logger log() {
        return HandshakeResponseEncoder$.MODULE$.log();
    }

    public static byte[] PADDING() {
        return HandshakeResponseEncoder$.MODULE$.PADDING();
    }

    public static int MAX_3_BYTES() {
        return HandshakeResponseEncoder$.MODULE$.MAX_3_BYTES();
    }

    private Map<String, AuthenticationMethod> authenticationMethods() {
        return this.authenticationMethods;
    }

    @Override
    public ByteBuf encode(ClientMessage message) {
        ByteBuf byteBuf;
        HandshakeResponseMessage m = (HandshakeResponseMessage)message;
        int clientCapabilities = 0;
        clientCapabilities |= 0xAA200;
        if (m.database().isDefined()) {
            clientCapabilities |= 8;
        }
        ByteBuf buffer = ByteBufferUtils$.MODULE$.packetBuffer(ByteBufferUtils$.MODULE$.packetBuffer$default$1());
        buffer.writeInt(clientCapabilities);
        buffer.writeInt(0xFFFFFF);
        buffer.writeByte(this.charsetMapper.toInt(this.charset));
        buffer.writeBytes(HandshakeResponseEncoder$.MODULE$.PADDING());
        ByteBufferUtils$.MODULE$.writeCString(m.username(), buffer, this.charset);
        if (m.password().isDefined()) {
            String method = m.authenticationMethod();
            AuthenticationMethod authenticator = (AuthenticationMethod)this.authenticationMethods().getOrElse((Object)method, (Function0 & java.io.Serializable & Serializable)() -> {
                throw new UnsupportedAuthenticationMethodException(method);
            });
            byte[] bytes = authenticator.generateAuthentication(this.charset, m.password(), m.seed());
            buffer.writeByte(bytes.length);
            byteBuf = buffer.writeBytes(bytes);
        } else {
            byteBuf = buffer.writeByte(0);
        }
        if (m.database().isDefined()) {
            ByteBufferUtils$.MODULE$.writeCString((String)m.database().get(), buffer, this.charset);
        }
        ByteBufferUtils$.MODULE$.writeCString(m.authenticationMethod(), buffer, this.charset);
        return buffer;
    }

    public HandshakeResponseEncoder(Charset charset, CharsetMapper charsetMapper) {
        this.charset = charset;
        this.charsetMapper = charsetMapper;
        this.authenticationMethods = AuthenticationMethod$.MODULE$.Availables();
    }
}

