/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck;

import com.github.mauricioaniche.ck.CKMethodResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CKClassResult {
    private String file;
    private String className;
    private String type;
    private int dit;
    private int wmc;
    private int cbo;
    private int lcom;
    private int rfc;
    private int nosi;
    private int loc;
    private Set<CKMethodResult> methods;
    private Set<CKMethodResult> visibleMethods;
    private Set<String> fieldNames;
    private int returnQty;
    private int loopQty;
    private int comparisonsQty;
    private int tryCatchQty;
    private int parenthesizedExpsQty;
    private int stringLiteralsQty;
    private int numbersQty;
    private int assignmentsQty;
    private int mathOperationsQty;
    private int variablesQty;
    private int maxNestedBlocks;
    private int anonymousClassesQty;
    private int innerClassesQty;
    private int lambdasQty;
    private int uniqueWordsQty;
    private int numberOfMethods;
    private int numberOfStaticMethods;
    private int numberOfPublicMethods;
    private int numberOfPrivateMethods;
    private int numberOfProtectedMethods;
    private int numberOfDefaultMethods;
    private int numberOfAbstractMethods;
    private int numberOfFinalMethods;
    private int numberOfSynchronizedMethods;
    private int numberOfFields;
    private int numberOfStaticFields;
    private int numberOfPublicFields;
    private int numberOfPrivateFields;
    private int numberOfProtectedFields;
    private int numberOfDefaultFields;
    private int numberOfFinalFields;
    private int numberOfSynchronizedFields;
    private int modifiers;
    private int numberOfLogStatements;
    private float tightClassCohesion;
    private float looseClassCohesion;

    public CKClassResult(String file, String className, String type, int modifiers) {
        this.file = file;
        this.className = className;
        this.type = type;
        this.methods = new HashSet<CKMethodResult>();
        this.visibleMethods = new HashSet<CKMethodResult>();
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getFile() {
        return this.file;
    }

    public int getDit() {
        return this.dit;
    }

    public void setDit(int dit) {
        this.dit = dit;
    }

    public String getClassName() {
        return this.className;
    }

    public void setWmc(int cc) {
        this.wmc = cc;
    }

    public int getWmc() {
        return this.wmc;
    }

    public int getCbo() {
        return this.cbo;
    }

    public void setCbo(int cbo) {
        this.cbo = cbo;
    }

    public void setLcom(int lcom) {
        this.lcom = lcom;
    }

    public int getLcom() {
        return this.lcom;
    }

    public void setRfc(int rfc) {
        this.rfc = rfc;
    }

    public int getRfc() {
        return this.rfc;
    }

    public int getNosi() {
        return this.nosi;
    }

    public void setNosi(int nosi) {
        this.nosi = nosi;
    }

    public int getLoc() {
        return this.loc;
    }

    public void setLoc(int loc) {
        this.loc = loc;
    }

    public String toString() {
        return "CKClassResult [file=" + this.file + ", className=" + this.className + "]";
    }

    public void addMethod(CKMethodResult method) {
        this.methods.add(method);
        if (method.getIsVisible()) {
            this.visibleMethods.add(method);
        }
    }

    public Set<CKMethodResult> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public Set<CKMethodResult> getVisibleMethods() {
        return Collections.unmodifiableSet(this.visibleMethods);
    }

    public Optional<CKMethodResult> getMethod(String methodName) {
        return this.methods.stream().filter(m -> m.getMethodName().equals(methodName)).findFirst();
    }

    public void setFieldNames(Set<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setReturnQty(int returnQty) {
        this.returnQty = returnQty;
    }

    public int getReturnQty() {
        return this.returnQty;
    }

    public void setLoopQty(int loopQty) {
        this.loopQty = loopQty;
    }

    public int getLoopQty() {
        return this.loopQty;
    }

    public void setComparisonsQty(int comparisonsQty) {
        this.comparisonsQty = comparisonsQty;
    }

    public int getComparisonsQty() {
        return this.comparisonsQty;
    }

    public void setTryCatchQty(int tryCatchQty) {
        this.tryCatchQty = tryCatchQty;
    }

    public int getTryCatchQty() {
        return this.tryCatchQty;
    }

    public void setParenthesizedExpsQty(int parenthesizedExpsQty) {
        this.parenthesizedExpsQty = parenthesizedExpsQty;
    }

    public int getParenthesizedExpsQty() {
        return this.parenthesizedExpsQty;
    }

    public void setStringLiteralsQty(int stringLiteralsQty) {
        this.stringLiteralsQty = stringLiteralsQty;
    }

    public int getStringLiteralsQty() {
        return this.stringLiteralsQty;
    }

    public void setNumbersQty(int numbersQty) {
        this.numbersQty = numbersQty;
    }

    public int getNumbersQty() {
        return this.numbersQty;
    }

    public void setAssignmentsQty(int assignmentsQty) {
        this.assignmentsQty = assignmentsQty;
    }

    public int getAssignmentsQty() {
        return this.assignmentsQty;
    }

    public void setMathOperationsQty(int mathOperationsQty) {
        this.mathOperationsQty = mathOperationsQty;
    }

    public int getMathOperationsQty() {
        return this.mathOperationsQty;
    }

    public void setVariablesQty(int variablesQty) {
        this.variablesQty = variablesQty;
    }

    public int getVariablesQty() {
        return this.variablesQty;
    }

    public void setMaxNestedBlocks(int maxNestedBlocks) {
        this.maxNestedBlocks = maxNestedBlocks;
    }

    public int getMaxNestedBlocks() {
        return this.maxNestedBlocks;
    }

    public void setAnonymousClassesQty(int anonymousClassesQty) {
        this.anonymousClassesQty = anonymousClassesQty;
    }

    public int getAnonymousClassesQty() {
        return this.anonymousClassesQty;
    }

    public void setInnerClassesQty(int innerClassesQty) {
        this.innerClassesQty = innerClassesQty;
    }

    public int getInnerClassesQty() {
        return this.innerClassesQty;
    }

    public void setLambdasQty(int lambdasQty) {
        this.lambdasQty = lambdasQty;
    }

    public int getLambdasQty() {
        return this.lambdasQty;
    }

    public void setUniqueWordsQty(int uniqueWordsQty) {
        this.uniqueWordsQty = uniqueWordsQty;
    }

    public int getUniqueWordsQty() {
        return this.uniqueWordsQty;
    }

    public void setNumberOfMethods(int numberOfMethods) {
        this.numberOfMethods = numberOfMethods;
    }

    public int getNumberOfMethods() {
        return this.numberOfMethods;
    }

    public void setNumberOfStaticMethods(int numberOfStaticMethods) {
        this.numberOfStaticMethods = numberOfStaticMethods;
    }

    public int getNumberOfStaticMethods() {
        return this.numberOfStaticMethods;
    }

    public void setNumberOfPublicMethods(int numberOfPublicMethods) {
        this.numberOfPublicMethods = numberOfPublicMethods;
    }

    public int getNumberOfPublicMethods() {
        return this.numberOfPublicMethods;
    }

    public void setNumberOfPrivateMethods(int numberOfPrivateMethods) {
        this.numberOfPrivateMethods = numberOfPrivateMethods;
    }

    public int getNumberOfPrivateMethods() {
        return this.numberOfPrivateMethods;
    }

    public void setNumberOfProtectedMethods(int numberOfProtectedMethods) {
        this.numberOfProtectedMethods = numberOfProtectedMethods;
    }

    public int getNumberOfProtectedMethods() {
        return this.numberOfProtectedMethods;
    }

    public void setNumberOfDefaultMethods(int numberOfDefaultMethods) {
        this.numberOfDefaultMethods = numberOfDefaultMethods;
    }

    public int getNumberOfDefaultMethods() {
        return this.numberOfDefaultMethods;
    }

    public void setNumberOfAbstractMethods(int numberOfAbstractMethods) {
        this.numberOfAbstractMethods = numberOfAbstractMethods;
    }

    public int getNumberOfAbstractMethods() {
        return this.numberOfAbstractMethods;
    }

    public void setNumberOfFinalMethods(int numberOfFinalMethods) {
        this.numberOfFinalMethods = numberOfFinalMethods;
    }

    public int getNumberOfFinalMethods() {
        return this.numberOfFinalMethods;
    }

    public void setNumberOfSynchronizedMethods(int numberOfSynchronizedMethods) {
        this.numberOfSynchronizedMethods = numberOfSynchronizedMethods;
    }

    public int getNumberOfVisibleMethods() {
        return this.visibleMethods.size();
    }

    public int getNumberOfSynchronizedMethods() {
        return this.numberOfSynchronizedMethods;
    }

    public void setNumberOfFields(int numberOfFields) {
        this.numberOfFields = numberOfFields;
    }

    public int getNumberOfFields() {
        return this.numberOfFields;
    }

    public void setNumberOfStaticFields(int numberOfStaticFields) {
        this.numberOfStaticFields = numberOfStaticFields;
    }

    public int getNumberOfStaticFields() {
        return this.numberOfStaticFields;
    }

    public void setNumberOfPublicFields(int numberOfPublicFields) {
        this.numberOfPublicFields = numberOfPublicFields;
    }

    public int getNumberOfPublicFields() {
        return this.numberOfPublicFields;
    }

    public void setNumberOfPrivateFields(int numberOfPrivateFields) {
        this.numberOfPrivateFields = numberOfPrivateFields;
    }

    public int getNumberOfPrivateFields() {
        return this.numberOfPrivateFields;
    }

    public void setNumberOfProtectedFields(int numberOfProtectedFields) {
        this.numberOfProtectedFields = numberOfProtectedFields;
    }

    public int getNumberOfProtectedFields() {
        return this.numberOfProtectedFields;
    }

    public void setNumberOfDefaultFields(int numberOfDefaultFields) {
        this.numberOfDefaultFields = numberOfDefaultFields;
    }

    public int getNumberOfDefaultFields() {
        return this.numberOfDefaultFields;
    }

    public void setNumberOfFinalFields(int numberOfFinalFields) {
        this.numberOfFinalFields = numberOfFinalFields;
    }

    public int getNumberOfFinalFields() {
        return this.numberOfFinalFields;
    }

    public void setNumberOfSynchronizedFields(int numberOfSynchronizedFields) {
        this.numberOfSynchronizedFields = numberOfSynchronizedFields;
    }

    public int getNumberOfSynchronizedFields() {
        return this.numberOfSynchronizedFields;
    }

    public String getType() {
        return this.type;
    }

    public void setLogStatementsQty(int numberOfLogStatements) {
        this.numberOfLogStatements = numberOfLogStatements;
    }

    public int getNumberOfLogStatements() {
        return this.numberOfLogStatements;
    }

    public float getTightClassCohesion() {
        return this.tightClassCohesion;
    }

    public float getLooseClassCohesion() {
        return this.looseClassCohesion;
    }

    public void setTightClassCohesion(float tightClassCohesion) {
        this.tightClassCohesion = tightClassCohesion;
    }

    public void setLooseClassCohesion(float looseClassCohesion) {
        this.looseClassCohesion = looseClassCohesion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CKClassResult that = (CKClassResult)o;
        return this.file.equals(that.file) && this.className.equals(that.className) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.className, this.type);
    }
}

