/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck;

import com.github.mauricioaniche.ck.CK;
import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKNotifier;
import com.github.mauricioaniche.ck.ResultWriter;
import java.io.IOException;

public class Runner {
    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 1) {
            System.out.println("Usage java -jar ck.jar <path to project> <use Jars=true|false> <max files per partition, 0=automatic selection> <print variables and fields metrics? True|False>");
            System.exit(1);
        }
        String path = args[0];
        boolean useJars = false;
        if (args.length >= 2) {
            useJars = Boolean.parseBoolean(args[1]);
        }
        int maxAtOnce = 0;
        if (args.length >= 3) {
            maxAtOnce = Integer.parseInt(args[2]);
        }
        boolean variablesAndFields = true;
        if (args.length >= 4) {
            variablesAndFields = Boolean.parseBoolean(args[3]);
        }
        final ResultWriter writer = new ResultWriter("class.csv", "method.csv", "variable.csv", "field.csv", variablesAndFields);
        new CK(useJars, maxAtOnce, variablesAndFields).calculate(path, new CKNotifier(){

            @Override
            public void notify(CKClassResult result) {
                try {
                    writer.printResult(result);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void notifyError(String sourceFilePath, Exception e) {
                System.err.println("Error in " + sourceFilePath);
                e.printStackTrace(System.err);
            }
        });
        writer.flushAndClose();
    }
}

