/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.util.WordCounter;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ClassLevelWordCounter
implements CKASTVisitor,
ClassLevelMetric {
    private String classSourceCode;

    @Override
    public void visit(TypeDeclaration node) {
        String typeSourceCode = node.toString();
        this.setOrRemoveSourceCode(typeSourceCode);
    }

    @Override
    public void visit(AnonymousClassDeclaration node) {
        this.setOrRemoveSourceCode(node.toString());
    }

    @Override
    public void visit(EnumDeclaration node) {
        this.setOrRemoveSourceCode(node.toString());
    }

    private void setOrRemoveSourceCode(String typeSourceCode) {
        if (this.classSourceCode == null) {
            this.classSourceCode = WordCounter.removeSpacesAndIdentation(typeSourceCode);
        } else {
            String otherType = WordCounter.removeSpacesAndIdentation(typeSourceCode);
            this.classSourceCode = WordCounter.removeSpacesAndIdentation(this.classSourceCode.replace(otherType, ""));
        }
    }

    @Override
    public void setResult(CKClassResult result) {
        int qtyOfUniqueWords = WordCounter.wordsIn(this.classSourceCode).size();
        result.setUniqueWordsQty(qtyOfUniqueWords);
    }
}

