/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import com.github.mauricioaniche.ck.util.WordCounter;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class MethodLevelWordCounter
implements CKASTVisitor,
MethodLevelMetric {
    private String methodSourceCode;

    @Override
    public void visit(MethodDeclaration node) {
        this.methodSourceCode = WordCounter.removeSpacesAndIdentation(node.toString());
    }

    @Override
    public void visit(Initializer node) {
        this.methodSourceCode = WordCounter.removeSpacesAndIdentation(node.toString());
    }

    @Override
    public void visit(TypeDeclaration node) {
        String otherType = WordCounter.removeSpacesAndIdentation(node.toString());
        this.methodSourceCode = WordCounter.removeSpacesAndIdentation(this.methodSourceCode.replace(otherType, ""));
    }

    @Override
    public void setResult(CKMethodResult result) {
        int qtyOfUniqueWords = WordCounter.wordsIn(this.methodSourceCode).size();
        result.setUniqueWordsQty(qtyOfUniqueWords);
    }
}

