/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.util.JDTUtils;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;

public class NumberOfFields
implements CKASTVisitor,
ClassLevelMetric {
    private Set<String> fieldNames = new HashSet<String>();
    private int fields;
    private int staticFields;
    private int publicFields;
    private int privateFields;
    private int protectedFields;
    private int defaultFields;
    private int finalFields;
    private int synchronizedFields;

    @Override
    public void visit(FieldDeclaration node) {
        ++this.fields;
        this.fieldNames.addAll(JDTUtils.getVariableName(node.fragments()));
        boolean isPublic = Modifier.isPublic((int)node.getModifiers());
        boolean isPrivate = Modifier.isPrivate((int)node.getModifiers());
        boolean isProtected = Modifier.isProtected((int)node.getModifiers());
        if (isPublic) {
            ++this.publicFields;
        } else if (isPrivate) {
            ++this.privateFields;
        } else if (isProtected) {
            ++this.protectedFields;
        } else {
            ++this.defaultFields;
        }
        boolean isStatic = Modifier.isStatic((int)node.getModifiers());
        boolean isFinal = Modifier.isFinal((int)node.getModifiers());
        boolean isSynchronized = Modifier.isSynchronized((int)node.getModifiers());
        if (isStatic) {
            ++this.staticFields;
        }
        if (isFinal) {
            ++this.finalFields;
        }
        if (isSynchronized) {
            ++this.synchronizedFields;
        }
    }

    @Override
    public void setResult(CKClassResult result) {
        result.setNumberOfFields(this.fields);
        result.setFieldNames(this.fieldNames);
        result.setNumberOfStaticFields(this.staticFields);
        result.setNumberOfPublicFields(this.publicFields);
        result.setNumberOfPrivateFields(this.privateFields);
        result.setNumberOfProtectedFields(this.protectedFields);
        result.setNumberOfDefaultFields(this.defaultFields);
        result.setNumberOfFinalFields(this.finalFields);
        result.setNumberOfSynchronizedFields(this.synchronizedFields);
    }
}

