/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class NumberOfLogStatements
implements CKASTVisitor,
MethodLevelMetric,
ClassLevelMetric {
    private int qty = 0;

    public static boolean isLogStatement(String line) {
        line = line.toLowerCase().trim();
        return line.matches(".*\\.(at)?(info|warn|debug|error|trace)\\(.*");
    }

    @Override
    public void visit(MethodInvocation node) {
        ExpressionStatement expr;
        String rawExpr;
        ASTNode parentNode = node.getParent();
        if (parentNode instanceof ExpressionStatement && NumberOfLogStatements.isLogStatement(rawExpr = (expr = (ExpressionStatement)parentNode).toString())) {
            ++this.qty;
        }
    }

    @Override
    public void setResult(CKMethodResult result) {
        result.setLogStatementsQty(this.qty);
    }

    @Override
    public void setResult(CKClassResult result) {
        result.setLogStatementsQty(this.qty);
    }
}

