/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;

public class NumberOfMethods
implements CKASTVisitor,
ClassLevelMetric {
    private int methods;
    private int staticMethods;
    private int publicMethods;
    private int privateMethods;
    private int protectedMethods;
    private int defaultMethods;
    private int abstractMethods;
    private int finalMethods;
    private int synchronizedMethods;

    @Override
    public void visit(MethodDeclaration node) {
        ++this.methods;
        boolean isPublic = Modifier.isPublic((int)node.getModifiers());
        boolean isPrivate = Modifier.isPrivate((int)node.getModifiers());
        boolean isProtected = Modifier.isProtected((int)node.getModifiers());
        if (isPublic) {
            ++this.publicMethods;
        } else if (isPrivate) {
            ++this.privateMethods;
        } else if (isProtected) {
            ++this.protectedMethods;
        } else {
            ++this.defaultMethods;
        }
        boolean isFinal = Modifier.isFinal((int)node.getModifiers());
        boolean isSynchronized = Modifier.isSynchronized((int)node.getModifiers());
        boolean isAbstract = Modifier.isAbstract((int)node.getModifiers());
        boolean isStatic = Modifier.isStatic((int)node.getModifiers());
        if (isStatic) {
            ++this.staticMethods;
        }
        if (isAbstract) {
            ++this.abstractMethods;
        }
        if (isFinal) {
            ++this.finalMethods;
        }
        if (isSynchronized) {
            ++this.synchronizedMethods;
        }
    }

    @Override
    public void setResult(CKClassResult result) {
        result.setNumberOfMethods(this.methods);
        result.setNumberOfStaticMethods(this.staticMethods);
        result.setNumberOfPublicMethods(this.publicMethods);
        result.setNumberOfPrivateMethods(this.privateMethods);
        result.setNumberOfProtectedMethods(this.protectedMethods);
        result.setNumberOfDefaultMethods(this.defaultMethods);
        result.setNumberOfAbstractMethods(this.abstractMethods);
        result.setNumberOfFinalMethods(this.finalMethods);
        result.setNumberOfSynchronizedMethods(this.synchronizedMethods);
    }
}

