/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodInvocationsLocal;
import com.github.mauricioaniche.ck.metric.MethodLevelFieldUsageCount;
import com.github.mauricioaniche.ck.metric.RFC;
import com.github.mauricioaniche.ck.metric.RunAfter;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

@RunAfter(metrics={RFC.class, MethodLevelFieldUsageCount.class, MethodInvocationsLocal.class})
public class TightClassCohesion
implements CKASTVisitor,
ClassLevelMetric {
    private HashMap<String, Set<String>> accessedFields = new HashMap();

    private Set<ImmutablePair<String, String>> getDirectConnections(CKClassResult result) {
        for (CKMethodResult cKMethodResult : result.getMethods()) {
            this.accessedFields.put(cKMethodResult.getMethodName(), cKMethodResult.getFieldsAccessed());
        }
        HashMap<String, Set<String>> allAccessedFields = new HashMap<String, Set<String>>();
        for (CKMethodResult method : result.getVisibleMethods()) {
            Set<String> allLocalFields = this.collectAccessedFields(method);
            allLocalFields.addAll(method.getFieldsAccessed());
            allAccessedFields.put(method.getMethodName(), allLocalFields);
        }
        HashSet<ImmutablePair<String, String>> hashSet = new HashSet<ImmutablePair<String, String>>();
        for (String firstKey : allAccessedFields.keySet()) {
            for (String secondKey : allAccessedFields.keySet()) {
                HashSet accessedFieldsFirst = Sets.newHashSet((Iterable)((Iterable)allAccessedFields.get(firstKey)));
                Set accessedFieldsSecond = (Set)allAccessedFields.get(secondKey);
                accessedFieldsFirst.retainAll(accessedFieldsSecond);
                if (firstKey.equals(secondKey) || accessedFieldsFirst.size() <= 0) continue;
                hashSet.add((ImmutablePair<String, String>)new ImmutablePair((Object)firstKey, (Object)secondKey));
            }
        }
        return hashSet;
    }

    private Set<String> collectAccessedFields(CKMethodResult method) {
        Set<String> allLocalInvocations = method.getMethodInvocationsIndirectLocal().keySet();
        HashSet<String> allLocalFields = new HashSet<String>();
        for (String invocation : allLocalInvocations) {
            Set<String> currentFields = this.accessedFields.get(invocation);
            if (currentFields == null) continue;
            allLocalFields.addAll(currentFields);
        }
        return allLocalFields;
    }

    private Set<ImmutablePair<String, String>> getIndirectConnections(CKClassResult result, Set<ImmutablePair<String, String>> directConnections) {
        HashMap<String, Set<String>> directConnectionsMap = new HashMap<String, Set<String>>();
        for (CKMethodResult cKMethodResult : result.getMethods()) {
            directConnectionsMap.put(cKMethodResult.getMethodName(), Sets.newHashSet((Iterable)Sets.newHashSet((Object[])ArrayUtils.EMPTY_STRING_ARRAY)));
        }
        for (ImmutablePair immutablePair : directConnections) {
            ((Set)directConnectionsMap.get(immutablePair.left)).add((String)immutablePair.right);
        }
        HashMap<String, Set<String>> indirectConnectionsMap = new HashMap<String, Set<String>>();
        for (CKMethodResult method : result.getVisibleMethods()) {
            Set<String> localConnections = this.extractConnections(method.getMethodName(), new HashSet<String>(), directConnectionsMap);
            indirectConnectionsMap.put(method.getMethodName(), localConnections);
        }
        HashSet<ImmutablePair<String, String>> hashSet = new HashSet<ImmutablePair<String, String>>();
        for (String key : indirectConnectionsMap.keySet()) {
            hashSet.addAll(((Set)indirectConnectionsMap.get(key)).stream().filter(right -> !key.equals(right)).map(right -> new ImmutablePair((Object)key, right)).collect(Collectors.toSet()));
        }
        hashSet.removeAll(directConnections);
        return hashSet;
    }

    private Set<String> extractConnections(String currentConnection, Set<String> explored, HashMap<String, Set<String>> connections) {
        explored.add(currentConnection);
        Set nextConnections = connections.get(currentConnection).stream().filter(connection -> !explored.contains(connection)).collect(Collectors.toSet());
        explored.addAll(nextConnections);
        for (String nextConnection : nextConnections) {
            explored.addAll(this.extractConnections(nextConnection, explored, connections));
        }
        return explored;
    }

    @Override
    public void setResult(CKClassResult result) {
        if (result.getVisibleMethods().size() < 1) {
            result.setTightClassCohesion(-1.0f);
            result.setLooseClassCohesion(-1.0f);
        } else {
            float np = result.getVisibleMethods().size() * (result.getVisibleMethods().size() - 1);
            Set<ImmutablePair<String, String>> directConnections = this.getDirectConnections(result);
            result.setTightClassCohesion((float)directConnections.size() / np);
            Set<ImmutablePair<String, String>> indirectConnections = this.getIndirectConnections(result, directConnections);
            result.setLooseClassCohesion((float)(directConnections.size() + indirectConnections.size()) / np);
        }
    }
}

