/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.util;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class FileUtils {
    public static String[] getAllDirs(String path) {
        try {
            return (String[])Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(x -> !FileUtils.isGitDir(x.toAbsolutePath().toString())).map(x -> x.toAbsolutePath().toString()).toArray(String[]::new);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] getAllJavaFiles(String path) {
        return FileUtils.getAllFiles(path, "java");
    }

    public static String[] getAllJars(String path) {
        return FileUtils.getAllFiles(path, "jar");
    }

    private static String[] getAllFiles(String path, String ending) {
        try {
            return (String[])Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x -> !FileUtils.isGitDir(x.toAbsolutePath().toString())).filter(x -> x.toAbsolutePath().toString().toLowerCase().endsWith(ending)).map(x -> x.toAbsolutePath().toString()).toArray(String[]::new);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isGitDir(String path) {
        return path.contains("/.git/");
    }
}

