/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class JDTUtils {
    public static int getStartLine(CompilationUnit cu, MethodDeclaration node) {
        return node.getBody() != null ? cu.getLineNumber(node.getBody().getStartPosition()) : cu.getLineNumber(node.getStartPosition());
    }

    public static int getStartLine(CompilationUnit cu, Initializer node) {
        return node.getBody() != null ? cu.getLineNumber(node.getBody().getStartPosition()) : cu.getLineNumber(node.getStartPosition());
    }

    public static String getMethodFullName(IMethodBinding binding) {
        String methodName = binding.getName();
        return methodName + "/" + JDTUtils.getMethodSignature(binding);
    }

    public static String getMethodFullName(MethodDeclaration node) {
        if (node.resolveBinding() != null) {
            return JDTUtils.getMethodFullName(node.resolveBinding());
        }
        String methodName = node.getName().getFullyQualifiedName();
        return methodName + "/" + JDTUtils.getMethodSignature(node);
    }

    public static String getQualifiedMethodFullName(IMethodBinding binding) {
        String methodName = binding.getName();
        if (binding.getDeclaringClass() != null) {
            methodName = binding.getDeclaringClass().getQualifiedName() + "." + binding.getName();
        }
        return methodName + "/" + JDTUtils.getMethodSignature(binding);
    }

    public static String getQualifiedMethodFullName(MethodDeclaration node) {
        if (node.resolveBinding() != null) {
            return JDTUtils.getQualifiedMethodFullName(node.resolveBinding());
        }
        String methodName = node.getName().getFullyQualifiedName();
        return methodName + "/" + JDTUtils.getMethodSignature(node);
    }

    public static String getQualifiedMethodFullName(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            return JDTUtils.getQualifiedMethodFullName(binding);
        }
        return node.getName().getFullyQualifiedName() + "/" + JDTUtils.getMethodSignature(node.arguments(), node.typeArguments());
    }

    public static String getQualifiedMethodFullName(SuperMethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            return JDTUtils.getQualifiedMethodFullName(binding);
        }
        if (node.getQualifier() != null) {
            return node.getQualifier().getFullyQualifiedName() + JDTUtils.getMethodSignature(node.arguments(), node.typeArguments());
        }
        return node.getName().getFullyQualifiedName() + "/" + JDTUtils.getMethodSignature(node.arguments(), node.typeArguments());
    }

    public static String getMethodSignature(IMethodBinding node) {
        int parameterCount = node.getParameterTypes() == null ? 0 : node.getParameterTypes().length;
        ArrayList<String> parameterTypes = new ArrayList<String>();
        if (parameterCount > 0) {
            for (ITypeBinding binding : node.getParameterTypes()) {
                String v = binding.getQualifiedName();
                parameterTypes.add(v);
            }
        }
        return JDTUtils.formatSignature(parameterTypes);
    }

    public static String getMethodSignature(MethodDeclaration node) {
        int parameterCount = node.parameters() == null ? 0 : node.parameters().size();
        ArrayList<String> parameterTypes = new ArrayList<String>();
        if (parameterCount > 0) {
            for (Object p0 : node.parameters()) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)p0;
                ITypeBinding binding = parameter.getType().resolveBinding();
                String v = binding == null || binding.isRecovered() ? parameter.getType().toString() : binding.getQualifiedName();
                if (parameter.isVarargs()) {
                    v = v + "[]";
                }
                parameterTypes.add(v);
            }
        }
        return JDTUtils.formatSignature(parameterTypes);
    }

    private static String getMethodSignature(List<?> arguments, List<?> typeArguments) {
        int argumentCount = arguments != null ? arguments.size() : 0;
        List<String> parameterTypes = typeArguments.stream().map(object -> object.toString()).collect(Collectors.toList());
        return JDTUtils.formatSignature(parameterTypes);
    }

    private static String formatSignature(List<String> parameters) {
        int parameterCount = parameters.size();
        return String.format("%d%s%s%s", parameterCount, parameterCount > 0 ? "[" : "", parameterCount > 0 ? String.join((CharSequence)",", parameters) : "", parameterCount > 0 ? "]" : "");
    }

    public static List<String> getVariableName(List<VariableDeclarationFragment> fragments) {
        if (fragments != null) {
            return fragments.stream().map(fragment -> fragment.getName().getIdentifier()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

