/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class WordCounter {
    private static Set<String> javaKeywords = new HashSet<String>(){
        {
            this.add("abstract");
            this.add("continue");
            this.add("for");
            this.add("new");
            this.add("switch");
            this.add("assert***");
            this.add("default");
            this.add("goto*");
            this.add("package");
            this.add("synchronized");
            this.add("boolean");
            this.add("do");
            this.add("if");
            this.add("private");
            this.add("this");
            this.add("break");
            this.add("double");
            this.add("implements");
            this.add("protected");
            this.add("throw");
            this.add("byte");
            this.add("else");
            this.add("import");
            this.add("public");
            this.add("throws");
            this.add("case");
            this.add("enum****");
            this.add("instanceof");
            this.add("return");
            this.add("transient");
            this.add("catch");
            this.add("extends");
            this.add("int");
            this.add("short");
            this.add("try");
            this.add("char");
            this.add("final");
            this.add("interface");
            this.add("static");
            this.add("void");
            this.add("class");
            this.add("finally");
            this.add("long");
            this.add("strictfp**");
            this.add("volatile");
            this.add("const*");
            this.add("float");
            this.add("native");
            this.add("super");
            this.add("while");
            this.add("String");
        }
    };

    public static Set<String> wordsIn(String fullString) {
        String[] cleanString = fullString.replace("\t", " ").replace("\n", " ").replace("\r", " ").replace("(", " ").replace(")", " ").replace("{", " ").replace("}", " ").replace("=", " ").replace(">", " ").replace(">", " ").replace("&", " ").replace("|", " ").replace("!", " ").replace("+", " ").replace("*", " ").replace("/", " ").replace("-", " ").replace(";", " ").split(" ");
        List strings = Arrays.stream(cleanString).filter(word -> !javaKeywords.contains(word)).filter(word -> !word.isEmpty()).filter(word -> word.matches("\\w*")).filter(word -> !word.matches("[0-9]*")).collect(Collectors.toList());
        HashSet<String> words = new HashSet<String>();
        for (String string : strings) {
            words.addAll(WordCounter.breakString(string));
        }
        return words;
    }

    private static Collection<? extends String> breakString(String string) {
        if (string.length() == 1) {
            return Arrays.asList(string);
        }
        int current = 0;
        ArrayList<String> words = new ArrayList<String>();
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) != '_' && !Character.isUpperCase(string.charAt(i))) continue;
            String wordToAdd = string.substring(current, i);
            words.add(wordToAdd);
            current = i + (string.charAt(i) == '_' ? 1 : 0);
        }
        String remainingWord = string.substring(current);
        words.add(remainingWord);
        return words;
    }

    public static String removeSpacesAndIdentation(String toString) {
        return toString.trim().replace("\r", " ").replace("\t", " ").replace("\n", " ").replaceAll(" +", " ");
    }
}

