/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck;

import com.github.mauricioaniche.ck.CKNotifier;
import com.github.mauricioaniche.ck.MetricsExecutor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import com.github.mauricioaniche.ck.util.FileUtils;
import com.github.mauricioaniche.ck.util.MetricsFinder;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class CK {
    private final int maxAtOnce;
    private final boolean useJars;
    private static Logger log = Logger.getLogger(CK.class);
    Callable<List<ClassLevelMetric>> classLevelMetrics;
    Callable<List<MethodLevelMetric>> methodLevelMetrics;

    public CK(Callable<List<ClassLevelMetric>> classLevelMetrics, Callable<List<MethodLevelMetric>> methodLevelMetrics) {
        this.useJars = false;
        this.classLevelMetrics = classLevelMetrics;
        this.methodLevelMetrics = methodLevelMetrics;
        this.maxAtOnce = 100;
    }

    public CK(boolean useJars, int maxAtOnce, boolean variablesAndFields) {
        MetricsFinder finder = new MetricsFinder();
        this.classLevelMetrics = () -> finder.allClassLevelMetrics();
        this.methodLevelMetrics = () -> finder.allMethodLevelMetrics(variablesAndFields);
        this.useJars = useJars;
        this.maxAtOnce = maxAtOnce == 0 ? this.getMaxPartitionBasedOnMemory() : maxAtOnce;
    }

    public CK() {
        this(false, 0, true);
    }

    public void calculate(String path, CKNotifier notifier) {
        String[] javaFiles = FileUtils.getAllJavaFiles(path);
        log.info((Object)("Found " + javaFiles.length + " java files"));
        this.calculate(Paths.get(path, new String[0]), notifier, (Path[])Stream.of(javaFiles).map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new));
    }

    public void calculate(Path path, CKNotifier notifier) {
        this.calculate(path.toString(), notifier);
    }

    public void calculate(Path path, CKNotifier notifier, Path ... javaFilePaths) {
        String[] allDependencies;
        String[] srcDirs = FileUtils.getAllDirs(path.toString());
        log.info((Object)("Found " + srcDirs.length + " src dirs"));
        String[] stringArray = allDependencies = this.useJars ? FileUtils.getAllJars(path.toString()) : null;
        if (this.useJars) {
            log.info((Object)("Found " + allDependencies.length + " jar dependencies"));
        }
        MetricsExecutor storage = new MetricsExecutor(this.classLevelMetrics, this.methodLevelMetrics, notifier);
        List strJavaFilePaths = Stream.of(javaFilePaths).map(file -> file.isAbsolute() ? file.toString() : path.resolve((Path)file).toString()).collect(Collectors.toList());
        List partitions = Lists.partition(strJavaFilePaths, (int)this.maxAtOnce);
        log.debug((Object)("Max partition size: " + this.maxAtOnce + ", total partitions=" + partitions.size()));
        for (List partition : partitions) {
            log.debug((Object)"Next partition");
            ASTParser parser = ASTParser.newParser((int)11);
            parser.setResolveBindings(true);
            parser.setBindingsRecovery(true);
            Hashtable options = JavaCore.getOptions();
            JavaCore.setComplianceOptions((String)"11", (Map)options);
            parser.setCompilerOptions((Map)options);
            parser.setEnvironment(allDependencies, srcDirs, null, true);
            parser.createASTs(partition.toArray(new String[partition.size()]), null, new String[0], (FileASTRequestor)storage, null);
        }
        log.info((Object)"Finished parsing");
    }

    private int getMaxPartitionBasedOnMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        if (maxMemory >= 2000L) {
            return 400;
        }
        if (maxMemory >= 1500L) {
            return 300;
        }
        if (maxMemory >= 1000L) {
            return 200;
        }
        if (maxMemory >= 500L) {
            return 100;
        }
        return 25;
    }
}

