/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import com.github.mauricioaniche.ck.util.JDTUtils;
import com.github.mauricioaniche.ck.util.LOCCalculator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;

public class CKVisitor
extends ASTVisitor {
    private String sourceFilePath;
    private int anonymousNumber;
    private int initializerNumber;
    private Stack<ClassInTheStack> classes;
    private Set<CKClassResult> collectedClasses;
    private CompilationUnit cu;
    private Callable<List<ClassLevelMetric>> classLevelMetrics;
    private Callable<List<MethodLevelMetric>> methodLevelMetrics;

    public CKVisitor(String sourceFilePath, CompilationUnit cu, Callable<List<ClassLevelMetric>> classLevelMetrics, Callable<List<MethodLevelMetric>> methodLevelMetrics) {
        this.sourceFilePath = sourceFilePath;
        this.cu = cu;
        this.classLevelMetrics = classLevelMetrics;
        this.methodLevelMetrics = methodLevelMetrics;
        this.classes = new Stack();
        this.collectedClasses = new HashSet<CKClassResult>();
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        String className = binding != null ? binding.getBinaryName() : node.getName().getFullyQualifiedName();
        String type = this.getTypeOfTheUnit(node);
        int modifiers = node.getModifiers();
        CKClassResult currentClass = new CKClassResult(this.sourceFilePath, className, type, modifiers);
        currentClass.setLoc(LOCCalculator.calculate(node.toString()));
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        List<ClassLevelMetric> classLevelMetrics = this.instantiateClassLevelMetricVisitors(className);
        ClassInTheStack classInTheStack = new ClassInTheStack();
        classInTheStack.result = currentClass;
        classInTheStack.classLevelMetrics = classLevelMetrics;
        this.classes.push(classInTheStack);
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        ClassInTheStack completedClass = this.classes.pop();
        completedClass.classLevelMetrics.forEach(m -> m.setResult(completedClass.result));
        this.collectedClasses.add(completedClass.result);
    }

    public boolean visit(MethodDeclaration node) {
        IMethodBinding binding = node.resolveBinding();
        String currentMethodName = JDTUtils.getMethodFullName(node);
        String currentQualifiedMethodName = JDTUtils.getQualifiedMethodFullName(node);
        boolean isConstructor = node.isConstructor();
        String className = currentQualifiedMethodName.lastIndexOf(currentMethodName) - 1 > 0 ? currentQualifiedMethodName.substring(0, currentQualifiedMethodName.lastIndexOf(currentMethodName) - 1) : "";
        CKMethodResult currentMethod = new CKMethodResult(currentMethodName, currentQualifiedMethodName, isConstructor, node.getModifiers());
        currentMethod.setLoc(LOCCalculator.calculate(node.toString()));
        currentMethod.setStartLine(JDTUtils.getStartLine(this.cu, node));
        List<MethodLevelMetric> methodLevelMetrics = this.instantiateMethodLevelMetricVisitors(currentQualifiedMethodName);
        MethodInTheStack methodInTheStack = new MethodInTheStack();
        methodInTheStack.result = currentMethod;
        methodInTheStack.methodLevelMetrics = methodLevelMetrics;
        this.classes.peek().methods.push(methodInTheStack);
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        }
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        MethodInTheStack completedMethod = this.classes.peek().methods.pop();
        completedMethod.methodLevelMetrics.forEach(m -> m.setResult(completedMethod.result));
        this.classes.peek().result.addMethod(completedMethod.result);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        List<Object> stringList = new ArrayList();
        stringList = stringList.stream().map(string -> string.toString()).collect(Collectors.toList());
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        }
        String anonClassName = this.classes.peek().result.getClassName() + "$Anonymous" + ++this.anonymousNumber;
        CKClassResult currentClass = new CKClassResult(this.sourceFilePath, anonClassName, "anonymous", -1);
        currentClass.setLoc(LOCCalculator.calculate(node.toString()));
        List<ClassLevelMetric> classLevelMetrics = this.instantiateClassLevelMetricVisitors(anonClassName);
        ClassInTheStack classInTheStack = new ClassInTheStack();
        classInTheStack.result = currentClass;
        classInTheStack.classLevelMetrics = classLevelMetrics;
        this.classes.push(classInTheStack);
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        }
        return true;
    }

    public void endVisit(AnonymousClassDeclaration node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        ClassInTheStack completedClass = this.classes.pop();
        completedClass.classLevelMetrics.forEach(m -> m.setResult(completedClass.result));
        this.collectedClasses.add(completedClass.result);
    }

    public boolean visit(Initializer node) {
        String currentMethodName = "(initializer " + ++this.initializerNumber + ")";
        CKMethodResult currentMethod = new CKMethodResult(currentMethodName, currentMethodName, false, node.getModifiers());
        currentMethod.setLoc(LOCCalculator.calculate(node.toString()));
        currentMethod.setStartLine(JDTUtils.getStartLine(this.cu, node));
        List<MethodLevelMetric> methodLevelMetrics = this.instantiateMethodLevelMetricVisitors(currentMethodName);
        MethodInTheStack methodInTheStack = new MethodInTheStack();
        methodInTheStack.result = currentMethod;
        methodInTheStack.methodLevelMetrics = methodLevelMetrics;
        this.classes.peek().methods.push(methodInTheStack);
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        }
        return true;
    }

    public void endVisit(Initializer node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        MethodInTheStack completedMethod = this.classes.peek().methods.pop();
        completedMethod.methodLevelMetrics.forEach(m -> m.setResult(completedMethod.result));
        this.classes.peek().result.addMethod(completedMethod.result);
    }

    public boolean visit(EnumDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        String className = binding != null ? binding.getBinaryName() : node.getName().getFullyQualifiedName();
        String type = "enum";
        int modifiers = node.getModifiers();
        CKClassResult currentClass = new CKClassResult(this.sourceFilePath, className, type, modifiers);
        currentClass.setLoc(LOCCalculator.calculate(node.toString()));
        List<ClassLevelMetric> classLevelMetrics = this.instantiateClassLevelMetricVisitors(className);
        ClassInTheStack classInTheStack = new ClassInTheStack();
        classInTheStack.result = currentClass;
        classInTheStack.classLevelMetrics = classLevelMetrics;
        this.classes.push(classInTheStack);
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
        return true;
    }

    public void endVisit(EnumDeclaration node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        ClassInTheStack completedClass = this.classes.pop();
        completedClass.classLevelMetrics.forEach(m -> m.setResult(completedClass.result));
        this.collectedClasses.add(completedClass.result);
    }

    private List<ClassLevelMetric> instantiateClassLevelMetricVisitors(String className) {
        try {
            List<ClassLevelMetric> classes = this.classLevelMetrics.call();
            classes.forEach(c -> c.setClassName(className));
            return classes;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate class level visitors", e);
        }
    }

    private List<MethodLevelMetric> instantiateMethodLevelMetricVisitors(String methodName) {
        try {
            List<MethodLevelMetric> methods = this.methodLevelMetrics.call();
            methods.forEach(m -> m.setMethodName(methodName));
            return methods;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate method level visitors", e);
        }
    }

    public Set<CKClassResult> getCollectedClasses() {
        return this.collectedClasses;
    }

    private String getTypeOfTheUnit(TypeDeclaration node) {
        return node.isInterface() ? "interface" : (this.classes.isEmpty() ? "class" : "innerclass");
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ArrayAccess node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ArrayCreation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ArrayType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(AssertStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(Assignment node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(Block node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(BlockComment node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(BooleanLiteral node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(BreakStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(CastExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(CatchClause node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(CharacterLiteral node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(CompilationUnit node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ConditionalExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ContinueStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(CreationReference node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(Dimension node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(DoStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(EmptyStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(EnhancedForStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(EnumConstantDeclaration node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ExpressionMethodReference node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ExpressionStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(FieldAccess node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ForStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(IfStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(InfixExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(InstanceofExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(IntersectionType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(LabeledStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(LambdaExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(LineComment node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(MemberRef node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(MemberValuePair node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(MethodRef node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(MethodRefParameter node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(Modifier node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(NameQualifiedType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(NormalAnnotation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(NullLiteral node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(NumberLiteral node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(PackageDeclaration node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ParameterizedType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ParenthesizedExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(PostfixExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(PrefixExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(PrimitiveType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(QualifiedName node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(QualifiedType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ReturnStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SimpleType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SingleMemberAnnotation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(StringLiteral node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SuperFieldAccess node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SuperMethodReference node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SwitchCase node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SwitchStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(SynchronizedStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(TagElement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(TextElement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ThisExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(ThrowStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(TryStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(TypeDeclarationStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(TypeLiteral node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(TypeMethodReference node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(TypeParameter node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(UnionType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(WhileStatement node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(WildcardType node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public boolean visit(Javadoc node) {
        if (!this.classes.isEmpty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.visit(node));
            }
        }
        return true;
    }

    public void endVisit(Block node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(FieldAccess node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(ConditionalExpression node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(ForStatement node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(EnhancedForStatement node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(DoStatement node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(WhileStatement node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(SwitchCase node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(IfStatement node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(SwitchStatement node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(CatchClause node) {
        this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        if (!this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    public void endVisit(Javadoc node) {
        if (!this.classes.empty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
            if (!this.classes.peek().methods.isEmpty()) {
                this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
            }
        }
    }

    public void endVisit(QualifiedName node) {
        if (!this.classes.empty()) {
            this.classes.peek().classLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
        if (!this.classes.isEmpty() && !this.classes.peek().methods.isEmpty()) {
            this.classes.peek().methods.peek().methodLevelMetrics.stream().map(metric -> (CKASTVisitor)((Object)metric)).forEach(ast -> ast.endVisit(node));
        }
    }

    class ClassInTheStack {
        CKClassResult result;
        List<ClassLevelMetric> classLevelMetrics;
        Stack<MethodInTheStack> methods = new Stack();

        ClassInTheStack() {
        }
    }

    class MethodInTheStack {
        CKMethodResult result;
        List<MethodLevelMetric> methodLevelMetrics;

        MethodInTheStack() {
        }
    }
}

