/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKNotifier;
import com.github.mauricioaniche.ck.CKVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class MetricsExecutor
extends FileASTRequestor {
    private Callable<List<ClassLevelMetric>> classLevelMetrics;
    private Callable<List<MethodLevelMetric>> methodLevelMetrics;
    private CKNotifier notifier;
    private static Logger log = Logger.getLogger(MetricsExecutor.class);

    public MetricsExecutor(Callable<List<ClassLevelMetric>> classLevelMetrics, Callable<List<MethodLevelMetric>> methodLevelMetrics, CKNotifier notifier) {
        this.classLevelMetrics = classLevelMetrics;
        this.methodLevelMetrics = methodLevelMetrics;
        this.notifier = notifier;
    }

    public void acceptAST(String sourceFilePath, CompilationUnit cu) {
        try {
            log.info((Object)("Processing: " + sourceFilePath));
            CKVisitor visitor = new CKVisitor(sourceFilePath, cu, this.classLevelMetrics, this.methodLevelMetrics);
            cu.accept((ASTVisitor)visitor);
            Set<CKClassResult> collectedClasses = visitor.getCollectedClasses();
            for (CKClassResult collectedClass : collectedClasses) {
                log.info((Object)collectedClass);
                this.notifier.notify(collectedClass);
            }
        }
        catch (Exception e) {
            log.error((Object)("error in " + sourceFilePath), (Throwable)e);
            this.notifier.notifyError(sourceFilePath, e);
        }
    }
}

