/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.CouplingExtras;
import com.github.mauricioaniche.ck.metric.MethodLevelMetric;
import com.github.mauricioaniche.ck.util.JDTUtils;
import java.util.List;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WildcardType;

public class Coupling
implements CKASTVisitor,
ClassLevelMetric,
MethodLevelMetric {
    private CouplingExtras extras = CouplingExtras.getInstance();
    private String className;
    private String methodName;

    @Override
    public void visit(VariableDeclarationStatement node) {
        if (this.className != null) {
            this.coupleTo(node.getType());
        }
    }

    @Override
    public void visit(ClassInstanceCreation node) {
        if (this.className != null) {
            this.coupleTo(node.getType());
        } else if (this.methodName != null) {
            IMethodBinding binding = node.resolveConstructorBinding();
            this.coupleTo(binding);
        }
    }

    @Override
    public void visit(ArrayCreation node) {
        if (this.className != null) {
            this.coupleTo((Type)node.getType());
        }
    }

    @Override
    public void visit(FieldDeclaration node) {
        if (this.className != null) {
            this.coupleTo(node.getType());
        }
    }

    @Override
    public void visit(ReturnStatement node) {
        if (this.className != null && node.getExpression() != null) {
            this.coupleTo(node.getExpression().resolveTypeBinding());
        }
    }

    @Override
    public void visit(TypeLiteral node) {
        if (this.className != null) {
            this.coupleTo(node.getType());
        }
    }

    @Override
    public void visit(ThrowStatement node) {
        if (this.className != null && node.getExpression() != null) {
            this.coupleTo(node.getExpression().resolveTypeBinding());
        }
    }

    @Override
    public void visit(TypeDeclaration node) {
        if (this.className != null) {
            ITypeBinding resolvedType = node.resolveBinding();
            if (resolvedType != null) {
                ITypeBinding binding = resolvedType.getSuperclass();
                if (binding != null) {
                    this.coupleTo(binding);
                }
                for (ITypeBinding interfaces : resolvedType.getInterfaces()) {
                    this.coupleTo(interfaces);
                }
            } else {
                this.coupleTo(node.getSuperclassType());
                List list = node.superInterfaceTypes();
                list.forEach(x -> this.coupleTo((Type)x));
            }
        }
    }

    @Override
    public void visit(MethodDeclaration node) {
        if (this.className != null) {
            IMethodBinding resolvedMethod = node.resolveBinding();
            if (resolvedMethod != null) {
                this.coupleTo(resolvedMethod.getReturnType());
                for (ITypeBinding param : resolvedMethod.getParameterTypes()) {
                    this.coupleTo(param);
                }
            } else {
                this.coupleTo(node.getReturnType2());
                List list = node.typeParameters();
                list.forEach(x -> this.coupleTo(x.getName()));
            }
        }
    }

    @Override
    public void visit(CastExpression node) {
        if (this.className != null) {
            this.coupleTo(node.getType());
        }
    }

    @Override
    public void visit(InstanceofExpression node) {
        if (this.className != null) {
            this.coupleTo(node.getRightOperand());
            this.coupleTo(node.getLeftOperand().resolveTypeBinding());
        }
    }

    @Override
    public void visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            if (this.className != null) {
                this.coupleTo(binding.getDeclaringClass());
            } else if (this.methodName != null) {
                this.coupleTo(binding);
            }
        }
    }

    @Override
    public void visit(NormalAnnotation node) {
        if (this.className != null) {
            this.coupleTo((Annotation)node);
        }
    }

    @Override
    public void visit(MarkerAnnotation node) {
        if (this.className != null) {
            this.coupleTo((Annotation)node);
        }
    }

    @Override
    public void visit(SingleMemberAnnotation node) {
        if (this.className != null) {
            this.coupleTo((Annotation)node);
        }
    }

    @Override
    public void visit(ParameterizedType node) {
        if (this.className != null) {
            try {
                ITypeBinding binding = node.resolveBinding();
                if (binding != null) {
                    this.coupleTo(binding);
                    for (ITypeBinding types : binding.getTypeArguments()) {
                        this.coupleTo(types);
                    }
                } else {
                    this.coupleTo(node.getType());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void coupleTo(Annotation type) {
        if (this.className != null) {
            ITypeBinding resolvedType = type.resolveTypeBinding();
            if (resolvedType != null) {
                this.coupleTo(resolvedType);
            } else {
                this.addToSet(type.getTypeName().getFullyQualifiedName());
            }
        }
    }

    private void coupleTo(Type type) {
        if (type == null) {
            return;
        }
        if (this.className != null) {
            ITypeBinding resolvedBinding = type.resolveBinding();
            if (resolvedBinding != null) {
                this.coupleTo(resolvedBinding);
            } else if (type instanceof SimpleType) {
                SimpleType castedType = (SimpleType)type;
                this.addToSet(castedType.getName().getFullyQualifiedName());
            } else if (type instanceof QualifiedType) {
                QualifiedType castedType = (QualifiedType)type;
                this.addToSet(castedType.getName().getFullyQualifiedName());
            } else if (type instanceof NameQualifiedType) {
                NameQualifiedType castedType = (NameQualifiedType)type;
                this.addToSet(castedType.getName().getFullyQualifiedName());
            } else if (type instanceof ParameterizedType) {
                ParameterizedType castedType = (ParameterizedType)type;
                this.coupleTo(castedType.getType());
            } else if (type instanceof WildcardType) {
                WildcardType castedType = (WildcardType)type;
                this.coupleTo(castedType.getBound());
            } else if (type instanceof ArrayType) {
                ArrayType castedType = (ArrayType)type;
                this.coupleTo(castedType.getElementType());
            } else if (type instanceof IntersectionType) {
                IntersectionType castedType = (IntersectionType)type;
                List types = castedType.types();
                types.stream().forEach(x -> this.coupleTo((Type)x));
            } else if (type instanceof UnionType) {
                UnionType castedType = (UnionType)type;
                List types = castedType.types();
                types.stream().forEach(x -> this.coupleTo((Type)x));
            }
        }
    }

    private void coupleTo(SimpleName name) {
        if (this.className != null) {
            this.addToSet(name.getFullyQualifiedName());
        }
    }

    private void coupleTo(ITypeBinding binding) {
        if (this.className != null) {
            if (binding == null) {
                return;
            }
            if (binding.isWildcardType()) {
                return;
            }
            if (binding.isNullType()) {
                return;
            }
            String type = binding.getQualifiedName();
            if (type.equals("null")) {
                return;
            }
            if (this.isFromJava(type) || binding.isPrimitive()) {
                return;
            }
            String cleanedType = this.cleanClassName(type);
            this.addToSet(cleanedType);
        }
    }

    private void coupleTo(IMethodBinding binding) {
        if (binding == null) {
            return;
        }
        String methodNameInvoked = JDTUtils.getQualifiedMethodFullName(binding);
        if (methodNameInvoked.equals("null")) {
            return;
        }
        if (this.isFromJava(methodNameInvoked)) {
            return;
        }
        this.addToSet(methodNameInvoked);
    }

    private String cleanClassName(String type) {
        String cleanedType = type.replace("[]", "").replace("\\$", ".");
        if (cleanedType.contains("<")) {
            cleanedType = cleanedType.substring(0, cleanedType.indexOf("<"));
        }
        return cleanedType;
    }

    private boolean isFromJava(String type) {
        return type.startsWith("java.") || type.startsWith("javax.");
    }

    private void addToSet(String name) {
        if (this.className != null) {
            this.extras.addToSetClassIn(name, this.className);
            this.extras.addToSetClassOut(this.className, name);
        } else {
            this.extras.addToSetMethodIn(name, this.methodName);
            this.extras.addToSetMethodOut(this.methodName, name);
        }
    }

    @Override
    public void setResult(CKClassResult result) {
    }

    @Override
    public void setResult(CKMethodResult result) {
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }
}

