/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.util.JDTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class LCOMNormalized
implements CKASTVisitor,
ClassLevelMetric {
    HashMap<String, TreeSet<String>> declaredFields = new HashMap();
    ArrayList<String> methods = new ArrayList();
    ArrayList<Integer> flags = new ArrayList();

    @Override
    public void visit(FieldDeclaration node) {
        for (Object o : node.fragments()) {
            VariableDeclarationFragment vdf = (VariableDeclarationFragment)o;
            this.declaredFields.put(vdf.getName().toString(), new TreeSet());
        }
    }

    @Override
    public void visit(SimpleName node) {
        String name = node.getFullyQualifiedName();
        if (this.declaredFields.containsKey(name)) {
            this.acessed(name);
        }
    }

    private void acessed(String name) {
        if (!this.methods.isEmpty()) {
            this.declaredFields.get(name).add(this.methods.get(this.methods.size() - 1));
        }
    }

    @Override
    public void visit(MethodDeclaration node) {
        String currentMethodName = JDTUtils.getMethodFullName(node);
        if (!this.methods.isEmpty()) {
            if (this.methods.get(this.methods.size() - 1).equals(currentMethodName)) {
                if (this.flags.get(this.flags.size() - 1) == 0) {
                    this.flags.set(this.flags.size() - 1, 1);
                } else {
                    this.methods.add(currentMethodName);
                    this.flags.add(0);
                }
            } else {
                this.methods.add(currentMethodName);
                this.flags.add(0);
            }
        } else {
            this.methods.add(currentMethodName);
            this.flags.add(0);
        }
    }

    @Override
    public void setResult(CKClassResult result) {
        float sum = 0.0f;
        float lcomNormalized = 0.0f;
        int numberOfAttributes = this.declaredFields.size();
        int numberOfMethods = this.methods.size();
        for (String key : this.declaredFields.keySet()) {
            sum += (float)(numberOfMethods - this.declaredFields.get(key).size()) / (float)numberOfMethods;
        }
        if (numberOfAttributes > 0) {
            lcomNormalized = 1.0f * sum / (float)numberOfAttributes;
        }
        result.setLcomNormalized(lcomNormalized);
    }
}

