/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricioaniche.ck.metric;

import com.github.mauricioaniche.ck.CKClassResult;
import com.github.mauricioaniche.ck.CKMethodResult;
import com.github.mauricioaniche.ck.metric.CKASTVisitor;
import com.github.mauricioaniche.ck.metric.ClassLevelMetric;
import com.github.mauricioaniche.ck.metric.MethodLevelFieldUsageCount;
import com.github.mauricioaniche.ck.metric.RFC;
import com.github.mauricioaniche.ck.metric.RunAfter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@RunAfter(metrics={RFC.class, MethodLevelFieldUsageCount.class})
public class MethodInvocationsLocal
implements CKASTVisitor,
ClassLevelMetric {
    private Map<String, Set<String>> invocations(String invokedMethod, Map<String, Set<String>> explored, HashMap<String, Set<String>> invocations) {
        Set<String> exploredKeys = explored.keySet();
        Set nextInvocations = invocations.get(invokedMethod).stream().filter(invoked -> !exploredKeys.contains(invoked) && !invoked.equals(invokedMethod)).collect(Collectors.toSet());
        if (nextInvocations.size() > 0) {
            explored.put(invokedMethod, nextInvocations);
            for (String nextInvocation : nextInvocations) {
                explored = this.invocations(nextInvocation, explored, invocations);
            }
        }
        return explored;
    }

    private HashMap<String, Map<String, Set<String>>> invocationsIndirect(Set<CKMethodResult> methods, HashMap<String, Set<String>> methodInvocationsLocal) {
        HashMap<String, Map<String, Set<String>>> methodInvocationsIndirectLocal = new HashMap<String, Map<String, Set<String>>>();
        for (CKMethodResult method : methods) {
            Map<String, Set<String>> localInvocations = this.invocations(method.getQualifiedMethodName(), new HashMap<String, Set<String>>(), methodInvocationsLocal);
            methodInvocationsIndirectLocal.put(method.getQualifiedMethodName(), localInvocations);
        }
        return methodInvocationsIndirectLocal;
    }

    private HashMap<String, Set<String>> extractLocalInvocations(Set<CKMethodResult> methods) {
        HashMap<String, Set<String>> methodInvocationsLocal = new HashMap<String, Set<String>>();
        Set methodNames = methods.stream().map(CKMethodResult::getQualifiedMethodName).collect(Collectors.toSet());
        for (CKMethodResult method : methods) {
            Set invokedLocal = method.getMethodInvocations().stream().filter(methodNames::contains).collect(Collectors.toSet());
            methodInvocationsLocal.put(method.getQualifiedMethodName(), invokedLocal);
        }
        return methodInvocationsLocal;
    }

    @Override
    public void setResult(CKClassResult result) {
        Set<CKMethodResult> methods = result.getMethods();
        HashMap<String, Set<String>> methodInvocationsLocal = this.extractLocalInvocations(methods);
        for (CKMethodResult method : methods) {
            method.setMethodInvocationLocal(methodInvocationsLocal.get(method.getQualifiedMethodName()));
        }
        HashMap<String, Map<String, Set<String>>> methodInvocationsIndirectLocal = this.invocationsIndirect(methods, methodInvocationsLocal);
        for (CKMethodResult method : methods) {
            method.setMethodInvocationsIndirectLocal(methodInvocationsIndirectLocal.get(method.getQualifiedMethodName()));
        }
    }
}

